#include "spawn.h"

#include "..\algorithms.h"

void botInfo::gotHelp(Player *p, Command *c)
{
	// List commands

	if (!*c->final)
	{
		switch (p->access)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_SysOp:
			{	// SysOp-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_SuperModerator:
			{	// SuperModerator-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_Moderator:
			{	// Moderator-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
				sendPrivate(p,"NOATTACHBOT: !noattach <Switches: -l -b=[ON/OFF] -a [Name] -r [Name] -c >");
			}
		}

		return;
	}

	// Specific command help

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
			if(c->checkParam("noattach"))
			{
				sendPrivate(p,"-=Using the below commands you can control who is able to attach to your ship=-");
				sendPrivate(p,"- !noattach -l              : Prints out your noattach list");
				sendPrivate(p,"- !noattach -b=[on/off]     : Turn ON or OFF the blocking of ALL attaches");
				sendPrivate(p,"- !noattach -a [PlayerName] : Add a player to your noattach list");
				sendPrivate(p,"- !noattach -r [PlayerName] : Remove a player from your noattach list");
				sendPrivate(p,"- !noattach -c              : Clears your noattach profile");
			}
		}
	}
}

void botInfo::gotCommand(Player *p, Command *c)
{
	if (!p) return;
	if (!c) return;

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
			if(c->check("noattach"))
			{
				if(c->slist.total>0)
				{
					_switch *S=c->slist.head->item;
					if(S!=NULL) //this should never happen, but its protection
					{
						NoAttach *Item=NULL;
						String Message;
						Uint16 i=0;
						_listnode <Player> *pl=NULL;

						for(_listnode <NoAttach> *nal=NoAttachList.head;nal;nal=nal->next)
						{
							if(CMPSTR(nal->item->name,p->name))
							{
								Item=nal->item;
								break;
							}
						}
						if(Item==NULL)
						{
							Item=new NoAttach;	
							memcpy(Item->name,p->name,20);
							for(i=0;i<5;i++)
							{Item->Blocked[i][0]=NULL;}
							Item->NoneAttach=false;
							NoAttachList.append(Item);
						}

						switch(S->type | 0x20)
						{
						case 'l'://list
							{
								Message="People on your noattach list: ";
								for(i=0;i<5;i++)
								{
									if(Item->Blocked[i][0]!=NULL)
									{
										Message+=Item->Blocked[i];
										Message+=",";
									}
								}
								Message.msg[Message.len-1]=' ';
							}
						break;

						case 'b'://block all on/off
							{
								if(S->param[0])
								{
									if(CMPSTR(S->param,"on"))
									{
										Item->NoneAttach=true;
										Message="The bot will now block all attempted attaches to you";
										for(pl=playerlist->head;pl;pl=pl->next)
										{
											if(pl->item->turret==p)
											{ForceDetach(pl->item);}
										}
									}
									else if(CMPSTR(S->param,"off"))
									{
										Item->NoneAttach=false;
										Message="The bot will now only block the people on your noturret list";
									}
									else
									{Message="Please specify either ON or OFF, Example- !noattach -b=ON";}
								}
								else
								{Message="You must specify if you want the \"block all turrets feature\" on or off. Example- !noattach -b=ON";}
							}
							break;

						case 'a'://add player
							{
								if(c->final[0])
								{
									for(i=0;i<5;i++)
									{
										if(CMPSTR(c->final,Item->Blocked[i]))
										{break;}
									}
									if(i==5)
									{
										if(isValidName(c->final))
										{
											for(i=0;i<5;i++)
											{
												if(Item->Blocked[i][0]==NULL)
												{
													memcpy(Item->Blocked[i],c->final,20);
												
													for(pl=playerlist->head;pl;pl=pl->next)
													{
														if(pl->item->turret==p && CMPSTR(c->final,pl->item->name))
														{ForceDetach(pl->item);}
													}
	
													Message=c->final;
													Message+=" has been added to your noattach list.";
													break;
												}
											}
	
											if(i==5)
											{Message="You may only have 5 people maximum on your noattach list. Use !noattach -r <PlayerName> to delete a player from your list. :(";}
										}
										else
										{Message="Invalid player name! Try again with a valid SubSpace name";}
									}
									else
									{Message="That player is already on your noattach list. Type !noattach -l to list the players on your list!";}
								}
								else
								{Message="Please specify a player\'s name to add to your noattach list. Example !noattach -a 50% Packetloss";}
							}
							break;
		
						case 'r'://remove player
							{
								if(c->final[0])
								{
									for(i=0;i<5;i++)
									{
										if(CMPSTR(Item->Blocked[i],c->final))
										{
											Item->Blocked[i][0]=NULL;
											Message=c->final;
											Message+=" has been removed from your noattach list.";
											break;
										}
									}
									if(i==5)
									{Message="That player was not found on your noattach list!";}
								}
								else
								{Message="You must specify a player\'s name to be removed from your noattach list! Example- !noattach -r Rifleman";}
							}
							break;

						case 'c': //clear
							{
								NoAttachList.kill(Item);
								Message="Your noattach profile has been cleared.";
							}
							break;

						default:
							{
								Message="Illegal Command- Command Reminders Above";
								gotHelp(p,&Command("help noattach"));

							}
							break;
						}

						sendPrivate(p,Message);
					}
					else
					{sendPrivate(p,"Eww, try your command again!");}//this should never happen, but its here just in case
				}
				else
				{gotHelp(p,&Command("help noattach"));}
			}
			else if (c->check("about") || c->check("version"))
			{
				sendPrivate(p, "No Attach Bot by 50% Packetloss(FiftyPacketloss@socal.rr.com)");
			}
		}
	}
}

void botInfo::gotRemoteHelp(char *p, Command *c, Operator_Level l)
{
	// List commands

	if (!*c->final)
	{
		switch (l)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
			}
		case OP_SysOp:
			{	// SysOp-level commands
			}
		case OP_SuperModerator:
			{	// SuperModerator-level commands
			}
		case OP_Moderator:
			{	// Moderator-level commands
			}
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
			}
		}

		return;
	}

	// Specific command help

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}

void botInfo::gotRemote(char *p, Command *c, Operator_Level l)
{
	if (!c) return;

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}
