#include "spawn.h"

#include "..\algorithms.h"

void botInfo::gotHelp(Player *p, Command *c)
{
	// List commands

	if (!*c->final)
	{
		switch (p->access)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
//				sendPrivate(p, "Ext: ");
			}
		case OP_SysOp:
			{	// SysOp-level commands
//				sendPrivate(p, "Ext: ");
				sendPrivate(p,"-Music Bot Sysop Commands: !listlocked !addplayer !delplayer");
			}
			break;
		case OP_SuperModerator:
			{	// SuperModerator-level commands
//				sendPrivate(p, "Ext: ");
			}
			break;
		case OP_Moderator:
			{	// Moderator-level commands
//				sendPrivate(p, "Ext: ");
			}
			break;
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
				
			}
		}

		return;
	}

	// Specific command help

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
			if(c->checkParam("addplayer"))
			{
				sendPrivate(p, "Command !addplayer <PlayerName>: Allows a player to join the freq that is locked");
			}
			else if(c->checkParam("delplayer"))
			{
				sendPrivate(p, "Command !delplayer <PlayerName>: Removes a player from being the locked freq");
			}
			else if(c->checkParam("listlocked"))
			{
				sendPrivate(p,"Command !listlocked: Prints the locked freq number and the players that are allowed on that freq");
			}
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}

void botInfo::gotCommand(Player *p, Command *c)
{
	if (!p) return;
	if (!c) return;

	switch (p->access)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
			if(c->check("listlocked"))
			{
				if(locked && winningFreq >= 0 && winningFreq <= 9999)
				{
					String Lines=   "|-----------------------------|";
					String Message;
					Message= "| Winning Freq#: ";
					Message+=winningFreq;
					while(Message.len < Lines.len-1)
					{
						Message+=" ";
					}
					Message+= "|";

					sendPrivate(p,Lines);
					sendPrivate(p,Message);
					sendPrivate(p,Lines);

					char *PlayerName=new char[20];
					for (std::list<std::string>::iterator iter = dbase.begin(); iter != dbase.end(); ++iter)
					{
						Message="| Player: ";
						memcpy(PlayerName,iter->c_str(),20);
						Message+= PlayerName;
						

						while(Message.len < Lines.len-1)
						{
							Message+=" ";
						}
						Message+= "|";
						sendPrivate(p,Message);
					}
					delete [] PlayerName;
					sendPrivate(p,Lines);
				}
				else
				{
					sendPrivate(p, "Freqs are not currently locked!");
				}
			}
			else if(c->check("addplayer"))
			{
				String Message;
				String PlayerName=c->final;
				if(locked && winningFreq >= 0 && winningFreq <= 9999)
				{
					if(!PlayerName.IsEmpty())
					{
						Player* add=GetPlayer(PlayerName);
						if(add != NULL)
						{
							for (std::list<std::string>::iterator iter = dbase.begin(); iter != dbase.end(); ++iter)
							{
								if (stricmp(iter->c_str(), add->name) == 0)
								{
									Message="That player is already on the winning team list!";
									break;
								}
							}
							if(Message.IsEmpty())
							{
								dbase.push_back(add->name);
								set_tag(add, TAG_FREQ, true);
								if(add->ship != 8)
								{sendPrivate(add, "*setfreq " + (String)winningFreq);}
								sendPrivate(add,"You have been added to the winning team by a moderator!");
								Message= "Player Added to list Sucessfully!";
							}
						}
						else
						{Message= "Player must be in the arena inorder to add them to the list";}
					}
					else
					{Message= "You must specify a playername, Format- !addplayer <PlayerName>";}
					
				}
				else
				{Message="All of the flags are not owned currently and the freq is not locked";}
				sendPrivate(p,Message);
			}
			else if(c->check("delplayer"))
			{
				String Message;
				String PlayerName=c->final;
				if(locked)
				{
					if(!PlayerName.IsEmpty())
					{
						Player* del=GetPlayer(PlayerName);
						if(del != NULL)
						{
							for (std::list<std::string>::iterator iter = dbase.begin(); iter != dbase.end(); ++iter)
							{
								if (stricmp(iter->c_str(), del->name) == 0)
								{
									dbase.erase(iter);
									killTags(del);
									gotEvent(makePlayerTeam(del,del->team,del->ship));
									sendPrivate(del,"You have been removed from the winning team by a moderator!");
									Message= "Player Deleted from list Sucessfully!";
									break;
								}
							}
							
							if(Message.IsEmpty())
							{Message="That player was not found on the winning freq list";}
						}
						else
						{Message= "Player must be in the arena inorder to delete them from the list";}
					}
					else
					{Message= "You must specify a playername, Format- !delplayer <PlayerName>";}
					
				}
				else
				{Message="All of the flags are not owned currently and the freq is not locked";}
				sendPrivate(p,Message);
			}
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
			if (c->check("version"))
			{
				sendPrivate(p, "[name:musiclock.dll] [maker:cat02e@fsu.edu] [build:2]");
			}
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
			if (c->check("about"))
			{
				sendPrivate(p, "When one team owns all the flags, I disallow freq-hopping.");
			}
		}
	}
}

void botInfo::gotRemoteHelp(char *p, Command *c, Operator_Level l)
{
	// List commands

	if (!*c->final)
	{
		switch (l)
		{
		case OP_Duke:
		case OP_Baron:
		case OP_King:
		case OP_Emperor:
		case OP_RockStar:
		case OP_Q:
		case OP_God:
		case OP_Owner:
			{	// Owner-level commands
			}
		case OP_SysOp:
			{	// SysOp-level commands
			}
		case OP_SuperModerator:
			{	// SuperModerator-level commands
			}
		case OP_Moderator:
			{	// Moderator-level commands
			}
		case OP_Limited:
			{	// Limited-level commands
			}
		case OP_Player:
			{	// Player-level commands
			}
		}

		return;
	}

	// Specific command help

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}

void botInfo::gotRemote(char *p, Command *c, Operator_Level l)
{
	if (!c) return;

	switch (l)
	{
	case OP_Duke:
	case OP_Baron:
	case OP_King:
	case OP_Emperor:
	case OP_RockStar:
	case OP_Q:
	case OP_God:
	case OP_Owner:
		{	// Owner-level commands
		}
	case OP_SysOp:
		{	// SysOp-level commands
		}
	case OP_SuperModerator:
		{	// SuperModerator-level commands
		}
	case OP_Moderator:
		{	// Moderator-level commands
		}
	case OP_Limited:
		{	// Limited-level commands
		}
	case OP_Player:
		{	// Player-level commands
		}
	}
}
