Attribute VB_Name = "PluginCommands"
Option Explicit

Public LaserRef_Enabled             As Boolean

Public OpList(0 To 255)             As String
Public TotalOps                     As Integer

Public Specials(0 To 255)           As String
Public TotalSpecials                As Integer

Public Enum ACCESS_LEVELS
    PUBLIC_ACCESS = 0
    SIMPLE_ACCESS = 1
    ACCOUNT_ACCESS = 2
    SUPER_ACCESS = 3
End Enum

Public Enum SHIPS_ALLOWED
    FIGHTERS = 0
    CRUISERS = 1
    CAPITALS = 2
    BANNED = 3
End Enum

Private I                           As Integer
Private L                           As Long
Private S                           As String

Public Sub HandlePlayer(Sender As Integer, Team As Integer, Ship As Byte)
    If LaserRef_Enabled = False Then Exit Sub
    
    Select Case pList(Sender).ShipRestrictions
        Case SHIPS_ALLOWED.FIGHTERS
            If Ship > 3 Then PrivateMessage Sender, "*setship " + CStr(Int(Rnd * 3) + 1) + " to " + pList(Sender).SSName
        Case SHIPS_ALLOWED.CRUISERS
            If Ship > 6 Then PrivateMessage Sender, "*setship " + CStr(Int(Rnd * 6) + 1) + " to " + pList(Sender).SSName
        Case SHIPS_ALLOWED.BANNED
            If Ship < 8 Then PrivateMessage Sender, "*spec"
    End Select
End Sub

Public Sub AddOp(UserName As String)
    DelOp UserName
    TotalOps = TotalOps + 1
    OpList(TotalOps) = UserName
End Sub

Public Sub DelOp(UserName As String)
    For L = 1 To TotalOps
        If OpList(L) = UserName Then I = CInt(L): Exit For
    Next
    
    If I > 0 Then
        For L = I To TotalOps
            OpList(L) = OpList(L + 1)
        Next
        TotalOps = TotalOps - 1
    End If
End Sub

Public Sub AddSpec(UserName As String)
    DelSpec UserName
    TotalSpecials = TotalSpecials + 1
    Specials(TotalSpecials) = UserName
End Sub

Public Sub DelSpec(UserName As String)
    For L = 1 To TotalSpecials
        If Specials(L) = UserName Then I = CInt(L): Exit For
    Next
    
    If I > 0 Then
        For L = I To TotalSpecials
            Specials(L) = Specials(L + 1)
        Next
        TotalSpecials = TotalSpecials - 1
    End If
End Sub

Public Sub HandleCommand(Sender As Integer, Message As String)
    Select Case pList(Sender).BotAccess
        Case ACCESS_LEVELS.PUBLIC_ACCESS    'PUBLIC OPERATORS
            Select Case Message
                Case "!public"
                    pList(Sender).BotAccess = ACCESS_LEVELS.PUBLIC_ACCESS
                Case "!simple"
                    pList(Sender).BotAccess = ACCESS_LEVELS.SIMPLE_ACCESS
                Case "!account"
                    pList(Sender).BotAccess = ACCESS_LEVELS.ACCOUNT_ACCESS
                Case "!super"
                    pList(Sender).BotAccess = ACCESS_LEVELS.SUPER_ACCESS
                
                Case "!help"
                    PrivateMessage Sender, "!listops - List online 'Ops"
                    PrivateMessage Sender, "!list - List special ships"
                    PrivateMessage Sender, "!status - Display your ship's power level"
                
                Case "!listops"
                    For L = 1 To TotalOps
                        I = FindPlayer(OpList(L))
                        If I > 0 Then
                            Select Case pList(I).BotAccess
                                Case ACCESS_LEVELS.SIMPLE_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Simple]"
                                Case ACCESS_LEVELS.ACCOUNT_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Account]"
                                Case ACCESS_LEVELS.SUPER_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Super]"
                            End Select
                        End If
                    Next
                    
                    If S = "" Then
                        PrivateMessage Sender, "No online operators"
                    Else
                        For L = 1 To Len(S) Step 40
                            PrivateMessage Sender, Mid(S, L, 40)
                        Next
                    End If
                    
                Case "!list"
                    For L = 1 To TotalSpecials
                        I = FindPlayer(Specials(L))
                        If I > 0 Then
                            Select Case pList(I).ShipRestrictions
                                Case SHIPS_ALLOWED.CRUISERS
                                    S = S + pList(I).SSName + "[Cruiser|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.CAPITALS
                                    S = S + pList(I).SSName + "[Capital|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.BANNED
                                    S = S + pList(I).SSName + "[Banned|Team " + CStr(pList(I).Frequency) + "]"
                            End Select
                        End If
                    Next
                    
                    If S = "" Then
                        PrivateMessage Sender, "No online special ships"
                    Else
                        For L = 1 To Len(S) Step 40
                            PrivateMessage Sender, Mid(S, L, 40)
                        Next
                    End If
                    
                Case "!status"
                    Select Case pList(Sender).ShipRestrictions
                        Case SHIPS_ALLOWED.FIGHTERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters only"
                        Case SHIPS_ALLOWED.CRUISERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Cruisers only"
                        Case SHIPS_ALLOWED.CAPITALS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Capital Ships only"
                        Case SHIPS_ALLOWED.BANNED
                            PrivateMessage Sender, "Unrestricted ships: You are banned from this game"
                    End Select
                
                Case Else
                    PrivateMessage Sender, "(LaserRef) Access level: Public - Send !help for commands"
            End Select
        
        Case ACCESS_LEVELS.SIMPLE_ACCESS    'SIMPLE OPERATORS
            If Left(Message, 7) = "!set 0 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " set to fighter for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a fighter. Use ships (1 to 4)  -" + pList(Sender).SSName
                    AddSpec pList(I).SSName
                    pList(I).ShipRestrictions = 0
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 1 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " becomes a cruiser for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a cruiser. Use ships (1 to 7)  -" + pList(Sender).SSName
                    AddSpec pList(I).SSName
                    pList(I).ShipRestrictions = 1
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 2 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " upgraded to capital ship for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a capital ship. Use any ship  -" + pList(Sender).SSName
                    AddSpec pList(I).SSName
                    pList(I).ShipRestrictions = 2
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            Select Case Message
                Case "!help"
                    PrivateMessage Sender, "!listops - List online 'Ops"
                    PrivateMessage Sender, "!list - List special ships"
                    PrivateMessage Sender, "!status - Display your ship's power level"
                    
                    PrivateMessage Sender, "!enable - Engage LaserRef"
                    PrivateMessage Sender, "!disable - Disengage LaserRef"
                    
                    PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-capital> <name> - Set player ship"
                
                Case "!listops"
                    For L = 1 To TotalOps
                        I = FindPlayer(OpList(L))
                        If I > 0 Then
                            Select Case pList(I).BotAccess
                                Case ACCESS_LEVELS.SIMPLE_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Simple]"
                                Case ACCESS_LEVELS.ACCOUNT_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Account]"
                                Case ACCESS_LEVELS.SUPER_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Super]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!list"
                    For L = 1 To TotalSpecials
                        I = FindPlayer(Specials(L))
                        If I > 0 Then
                            Select Case pList(I).ShipRestrictions
                                Case SHIPS_ALLOWED.CRUISERS
                                    S = S + pList(I).SSName + "[Cruiser|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.CAPITALS
                                    S = S + pList(I).SSName + "[Capital|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.BANNED
                                    S = S + pList(I).SSName + "[Banned|Team " + CStr(pList(I).Frequency) + "]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!status"
                    Select Case pList(Sender).ShipRestrictions
                        Case SHIPS_ALLOWED.FIGHTERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters only"
                        Case SHIPS_ALLOWED.CRUISERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Cruisers only"
                        Case SHIPS_ALLOWED.CAPITALS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Capital Ships only"
                        Case SHIPS_ALLOWED.BANNED
                            PrivateMessage Sender, "Unrestricted ships: You are banned from this game"
                    End Select
                
                Case "!enable"
                    If LaserRef_Enabled = True Then
                        PrivateMessage Sender, "LaserRef is already enabled"
                    Else
                        PrivateMessage Sender, "Loading game.."
                        PublicMessage "*arena LaserRef enabled by " + pList(Sender).SSName
                        LaserRef_Enabled = True
                    End If
                
                Case "!disable"
                    If LaserRef_Enabled = False Then
                        PrivateMessage Sender, "LaserRef is already disabled"
                    Else
                        PrivateMessage Sender, "Unloading game.."
                        PublicMessage "*arena LaserRef disabled by " + pList(Sender).SSName
                        LaserRef_Enabled = False
                    End If
                
                Case Else
                    PrivateMessage Sender, "(LaserRef) Access level: Simple - Send !help for commands"
            End Select
        
        Case ACCESS_LEVELS.ACCOUNT_ACCESS    'ACCOUNT OPERATORS
            If Left(Message, 7) = "!set 0 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " set to fighter for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a fighter. Use ships (1 to 4)  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 1 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " becomes a cruiser for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a cruiser. Use ships (1 to 7)  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 2 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " upgraded to capital ship for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a capital ship. Use any ship  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 9) = "!setop 0 " Then
                I = FindPlayer(Mid(Message, 10))
                If I > 0 Then
                    PrivateMessage I, "You have been removed from 'Op status  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            Select Case Message
                Case "!help"
                    PrivateMessage Sender, "!listops - List online 'Ops"
                    PrivateMessage Sender, "!list - List special ships"
                    PrivateMessage Sender, "!status - Display your ship's power level"
                    
                    PrivateMessage Sender, "!enable - Engage LaserRef"
                    PrivateMessage Sender, "!disable - Disengage LaserRef"
                    
                    PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-capital> <name> - Set player ship"
                    
                    PrivateMessage Sender, "!setop <0-strip,1-simple> <name> - Set simple operator status"
                    
                Case "!listops"
                    For L = 1 To TotalOps
                        I = FindPlayer(OpList(L))
                        If I > 0 Then
                            Select Case pList(I).BotAccess
                                Case ACCESS_LEVELS.SIMPLE_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Simple]"
                                Case ACCESS_LEVELS.ACCOUNT_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Account]"
                                Case ACCESS_LEVELS.SUPER_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Super]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!list"
                    For L = 1 To TotalSpecials
                        I = FindPlayer(Specials(L))
                        If I > 0 Then
                            Select Case pList(I).ShipRestrictions
                                Case SHIPS_ALLOWED.CRUISERS
                                    S = S + pList(I).SSName + "[Cruiser|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.CAPITALS
                                    S = S + pList(I).SSName + "[Capital|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.BANNED
                                    S = S + pList(I).SSName + "[Banned|Team " + CStr(pList(I).Frequency) + "]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!status"
                    Select Case pList(Sender).ShipRestrictions
                        Case SHIPS_ALLOWED.FIGHTERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters only"
                        Case SHIPS_ALLOWED.CRUISERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Cruisers only"
                        Case SHIPS_ALLOWED.CAPITALS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Capital Ships only"
                        Case SHIPS_ALLOWED.BANNED
                            PrivateMessage Sender, "Unrestricted ships: You are banned from this game"
                    End Select
                
                Case Else
                    PrivateMessage Sender, "(LaserRef) Access level: Account - Send !help for commands"
            End Select
        
        Case ACCESS_LEVELS.SUPER_ACCESS    'SUPER OPERATORS
            If Left(Message, 7) = "!set 0 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " set to fighter for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a fighter. Use ships (1 to 4)  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 1 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " becomes a cruiser for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a cruiser. Use ships (1 to 7)  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            If Left(Message, 7) = "!set 2 " Then
                I = FindPlayer(Mid(Message, 8))
                If I > 0 Then
                    PublicMessage "*arena " + pList(I).SSName + " upgraded to capital ship for team " + CStr(pList(I).Frequency)
                    PrivateMessage I, "You have become a capital ship. Use any ship  -" + pList(Sender).SSName
                Else
                    PrivateMessage Sender, pList(I).SSName + " not online"
                End If
                Exit Sub
            End If
            
            Select Case Message
                Case "!help"
                    PrivateMessage Sender, "!listops - List online 'Ops"
                    PrivateMessage Sender, "!list - List special ships"
                    PrivateMessage Sender, "!status - Display your ship's power level"
                    
                    PrivateMessage Sender, "!enable - Engage LaserRef"
                    PrivateMessage Sender, "!disable - Disengage LaserRef"
                    
                    PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-capital> <name> - Set player ship"
                    
                    PrivateMessage Sender, "!setop <0-strip,1-simple,2-account,3=super> <name> - Set operator status"
                    
                Case "!listops"
                    For L = 1 To TotalOps
                        I = FindPlayer(OpList(L))
                        If I > 0 Then
                            Select Case pList(I).BotAccess
                                Case ACCESS_LEVELS.SIMPLE_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Simple]"
                                Case ACCESS_LEVELS.ACCOUNT_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Account]"
                                Case ACCESS_LEVELS.SUPER_ACCESS
                                    S = S + pList(I).SSName + "[" + CStr(pList(I).BotAccess) + ":Super]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!list"
                    For L = 1 To TotalSpecials
                        I = FindPlayer(Specials(L))
                        If I > 0 Then
                            Select Case pList(I).ShipRestrictions
                                Case SHIPS_ALLOWED.CRUISERS
                                    S = S + pList(I).SSName + "[Cruiser|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.CAPITALS
                                    S = S + pList(I).SSName + "[Capital|Team " + CStr(pList(I).Frequency) + "]"
                                Case SHIPS_ALLOWED.BANNED
                                    S = S + pList(I).SSName + "[Banned|Team " + CStr(pList(I).Frequency) + "]"
                            End Select
                        End If
                    Next
                    
                    For L = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, L, 40)
                    Next
                    
                Case "!status"
                    Select Case pList(Sender).ShipRestrictions
                        Case SHIPS_ALLOWED.FIGHTERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters only"
                        Case SHIPS_ALLOWED.CRUISERS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Cruisers only"
                        Case SHIPS_ALLOWED.CAPITALS
                            PrivateMessage Sender, "Unrestricted ships: Fighters-Capital Ships only"
                        Case SHIPS_ALLOWED.BANNED
                            PrivateMessage Sender, "Unrestricted ships: You are banned from this game"
                    End Select
                
                Case Else
                    PrivateMessage Sender, "(LaserRef) Access level: Super - Send !help for commands"
            End Select
    
    End Select
End Sub

