Attribute VB_Name = "Players"
Option Explicit

'Constants

Public Enum ALLOW
    OP_PUBLIC = 0
    OP_SIMPLE = 1
    OP_ACCOUNT = 2
    OP_SUPER = 3

    SHIPS_FIGHTERS = 0
    SHIPS_CRUISERS = 1
    SHIPS_CAPITALS = 2
End Enum

Public Const MAX_PLAYERS = 255
Public Const MAX_OPERATORS = 255

'Types

Public Type PlayerEntry
    SSName                  As String
    Frequency               As Integer
    ShipType                As Byte
    
    OpID                    As Byte
    ShipRestrictions        As ALLOW
End Type

Public Type OperatorEntry
    UserName                As String
    OperatorStatus          As ALLOW
    OperatorOnline          As Integer
End Type

'Databases

Public pList(0 To MAX_PLAYERS) As PlayerEntry

Public OpList(0 To MAX_OPERATORS) As OperatorEntry
Public TotalOps             As Integer

'Privates

Private I                   As Integer
Private I2                  As Integer
Private L                   As Long
Private S                   As String

'Publics

Public LaserRef_Enabled     As Boolean

'Database access

Public Function FindPlayer(UserName As String) As Integer
    For L = 0 To MAX_PLAYERS
        If UserName = pList(L).SSName Then FindPlayer = L: Exit Function
    Next
End Function

Public Function FindOperator(UserName As String) As Byte
    For I = 1 To TotalOps
        If OpList(I).UserName = UserName Then FindOperator = CByte(I): Exit Function
    Next
End Function

Public Sub AddUser(UserName As String, UserID As Integer, Freq As Integer, ShipType As Byte)
    pList(UserID).SSName = UserName
    pList(UserID).Frequency = Freq
    pList(UserID).ShipType = ShipType
    pList(UserID).ShipRestrictions = SHIPS_FIGHTERS
    
    pList(UserID).OpID = FindOperator(UserName)
    OpList(pList(UserID).OpID).OperatorOnline = UserID
    
    MainFrm.ChatUsers.AddItem UserName
    UpdateTitle UserName + " entering game.."
End Sub

Public Sub DelUser(UserID As Integer)
    For I = 0 To MainFrm.ChatUsers.ListCount - 1
        If MainFrm.ChatUsers.List(I) = pList(UserID).SSName Then
            MainFrm.ChatUsers.RemoveItem I
            OpList(pList(UserID).OpID).OperatorOnline = 0
            UpdateTitle pList(UserID).SSName + " leaving game.."
            Exit Sub
        End If
    Next
End Sub

Public Sub AddOp(UserName As String, AccessLevel As ALLOW)
    DelOp UserName
    If AccessLevel = OP_PUBLIC Then Exit Sub
    
    TotalOps = TotalOps + 1
    I = FindPlayer(UserName)
    If I > 0 Then pList(I).OpID = TotalOps
    OpList(TotalOps).UserName = UserName
    OpList(TotalOps).OperatorStatus = AccessLevel
    If I > 0 Then OpList(TotalOps).OperatorOnline = I
End Sub

Public Sub DelOp(UserName As String)
    For I2 = 1 To TotalOps
        If OpList(I2).UserName = UserName Then GoTo FoundOne
    Next
    Exit Sub

FoundOne:
    I = FindPlayer(UserName): If I > 0 Then pList(I).OpID = 0
    For I = I2 To TotalOps
        OpList(I) = OpList(I + 1)
    Next
    TotalOps = TotalOps - 1
End Sub

'Handlers

Public Sub HandleShipChange(Sender As Integer)
    If LaserRef_Enabled = False Then Exit Sub
    If pList(Sender).ShipType = 8 Then Exit Sub

    With pList(Sender)
        Select Case .ShipRestrictions
            Case ALLOW.SHIPS_FIGHTERS
                If .ShipType > 3 Then
                    PrivateMessage Sender, "*setship " + CStr(Int(Rnd * 3) + 1)
                End If
            Case ALLOW.SHIPS_CRUISERS
                If .ShipType > 6 Then
                    PrivateMessage Sender, "*setship " + CStr(Int(Rnd * 6) + 1)
                End If
        End Select
    End With
End Sub

Public Sub HandleCommand(Sender As Integer, Message As String)
    If Sender = MyID Then Exit Sub

    If pList(Sender).OpID = 0 Then
        Select Case Message
            Case "!1"
                AddOp pList(Sender).SSName, OP_SIMPLE
            Case "!2"
                AddOp pList(Sender).SSName, OP_ACCOUNT
            Case "!3"
                AddOp pList(Sender).SSName, OP_SUPER
            Case "!help"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "(Public access:LaserRef On) Command list:"
                Else
                    PrivateMessage Sender, "(Public access:LaserRef Off) Command list:"
                End If
                PrivateMessage Sender, "!listops - List online operators"
                PrivateMessage Sender, "!list - List cruisers and capital ships"
                PrivateMessage Sender, "!allow - Display the ships you may use"
            Case "!allow"
                Select Case pList(Sender).ShipRestrictions
                    Case ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, "You are a fighter.  Use ships 1-4"
                    Case ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, "You are a cruiser.  Use ships 1-7"
                    Case ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, "You are a capital ship.  Use ships 1-8"
                End Select
            Case "!list"
                S = ""
                For I = 0 To MAX_PLAYERS
                    Select Case pList(I).ShipRestrictions
                        Case ALLOW.SHIPS_CRUISERS
                            S = S + "Team " + CStr(pList(I).Frequency) + " cruiser: " + pList(I).SSName + ","
                        Case ALLOW.SHIPS_CAPITALS
                            S = S + "Team " + CStr(pList(I).Frequency) + " capital ship: " + pList(I).SSName + ","
                    End Select
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No online cruisers or capital ships"
                End If
            Case "!listops"
                S = ""
                For I = 1 To TotalOps
                    If OpList(I).OperatorOnline > 0 Then
                        S = S + pList(OpList(I).OperatorOnline).SSName + ","
                    End If
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No online operators"
                End If
        End Select
        Exit Sub
    End If
    
    If OpList(pList(Sender).OpID).OperatorStatus = OP_SIMPLE Then
        If Left(Message, 5) = "!set " Then
            I = FindPlayer(TrimZero(Mid(Message, 8)))
            If I > 0 Then
                Select Case CInt(Val(Mid(Message, 6, 1)))
                    Case ALLOW.SHIPS_FIGHTERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, pList(I).SSName + " -> Fighter"
                        PrivateMessage I, "You are now a fighter. You may use ships 1-4  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CRUISERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, pList(I).SSName + " -> Cruiser"
                        PrivateMessage I, "You are now a cruiser. You may use ships 1-7  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CAPITALS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, pList(I).SSName + " -> Capital ship"
                        PrivateMessage I, "You are now a capital ship. You may use ships 1-8  -" + pList(Sender).SSName
                    Case Else
                        PrivateMessage Sender, "Format: !set <0-fighter,1-cruiser,2-cap> <player name>"
                End Select
            Else
                PrivateMessage Sender, TrimZero(Mid(Message, 8)) + " not online"
            End If
            Exit Sub
        End If
        
        Select Case Message
            Case "!help"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "(Simple access:LaserRef On) Command list:"
                Else
                    PrivateMessage Sender, "(Simple access:LaserRef Off) Command list:"
                End If
                PrivateMessage Sender, "!listops - List all operators"
                PrivateMessage Sender, "!list - List cruisers and capital ships"
                PrivateMessage Sender, "!allow - Display the ships you may use"
                PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-cap> <player name> - Create a new cruiser or capital ship"
                PrivateMessage Sender, "!enable/disable - Engage or disengage ship-checking"
            Case "!enable"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "LaserRef is already enabled"
                Else
                    LaserRef_Enabled = True
                    PublicMessage "*arena LaserRef enabled by " + pList(Sender).SSName
                End If
            Case "!disable"
                If LaserRef_Enabled = False Then
                    PrivateMessage Sender, "LaserRef is already disabled"
                Else
                    LaserRef_Enabled = False
                    PublicMessage "*arena LaserRef disabled by " + pList(Sender).SSName
                End If
            Case "!allow"
                Select Case pList(Sender).ShipRestrictions
                    Case ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, "You are a fighter.  Use ships 1-4"
                    Case ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, "You are a cruiser.  Use ships 1-7"
                    Case ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, "You are a capital ship.  Use ships 1-8"
                End Select
            Case "!list"
                S = ""
                For I = 0 To MAX_PLAYERS
                    Select Case pList(I).ShipRestrictions
                        Case ALLOW.SHIPS_CRUISERS
                            S = S + "Team " + CStr(pList(I).Frequency) + " cruiser: " + pList(I).SSName + ","
                        Case ALLOW.SHIPS_CAPITALS
                            S = S + "Team " + CStr(pList(I).Frequency) + " capital ship: " + pList(I).SSName + ","
                    End Select
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No online cruisers or capital ships"
                End If
            Case "!listops"
                S = ""
                For I = 1 To TotalOps
                    S = S + pList(OpList(I).OperatorOnline).SSName + ","
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No operators"
                End If
        End Select
        Exit Sub
    End If
    
    If OpList(pList(Sender).OpID).OperatorStatus = OP_ACCOUNT Then
        If Left(Message, 5) = "!set " Then
            I = FindPlayer(TrimZero(Mid(Message, 8)))
            If I > 0 Then
                Select Case CInt(Val(Mid(Message, 6, 1)))
                    Case ALLOW.SHIPS_FIGHTERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, pList(I).SSName + " -> Fighter"
                        PrivateMessage I, "You are now a fighter. You may use ships 1-4  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CRUISERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, pList(I).SSName + " -> Cruiser"
                        PrivateMessage I, "You are now a cruiser. You may use ships 1-7  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CAPITALS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, pList(I).SSName + " -> Capital ship"
                        PrivateMessage I, "You are now a capital ship. You may use ships 1-8  -" + pList(Sender).SSName
                    Case Else
                        PrivateMessage Sender, "Format: !set <0-fighter,1-cruiser,2-cap> <player name>"
                End Select
            Else
                PrivateMessage Sender, TrimZero(Mid(Message, 8)) + " not online"
            End If
            Exit Sub
        End If
        
        If Left(Message, 11) = "!setaccess " Then
            Select Case CInt(Val(Mid(Message, 12, 1)))
                Case ALLOW.OP_PUBLIC
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_PUBLIC
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " stripped of operator status"
                Case ALLOW.OP_SIMPLE
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_SIMPLE
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " granted simple bot access"
                Case Else
                    PrivateMessage Sender, "Format: !setaccess <0-public,1-simple> <player name>"
            End Select
            Exit Sub
        End If
        
        Select Case Message
            Case "!help"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "(Account access:LaserRef On) Command list:"
                Else
                    PrivateMessage Sender, "(Account access:LaserRef Off) Command list:"
                End If
                PrivateMessage Sender, "!listops - List all operators"
                PrivateMessage Sender, "!list - List cruisers and capital ships"
                PrivateMessage Sender, "!allow - Display the ships you may use"
                PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-cap> <player name> - Create a new cruiser or capital ship"
                PrivateMessage Sender, "!setaccess <0-public,1-simple> <player name> - Create a new operator"
                PrivateMessage Sender, "!enable/disable - Engage or disengage ship-checking"
            Case "!enable"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "LaserRef is already enabled"
                Else
                    LaserRef_Enabled = True
                    PublicMessage "*arena LaserRef enabled by " + pList(Sender).SSName
                End If
            Case "!disable"
                If LaserRef_Enabled = False Then
                    PrivateMessage Sender, "LaserRef is already disabled"
                Else
                    LaserRef_Enabled = False
                    PublicMessage "*arena LaserRef disabled by " + pList(Sender).SSName
                End If
            Case "!allow"
                Select Case pList(Sender).ShipRestrictions
                    Case ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, "You are a fighter.  Use ships 1-4"
                    Case ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, "You are a cruiser.  Use ships 1-7"
                    Case ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, "You are a capital ship.  Use ships 1-8"
                End Select
            Case "!list"
                S = ""
                For I = 0 To MAX_PLAYERS
                    Select Case pList(I).ShipRestrictions
                        Case ALLOW.SHIPS_CRUISERS
                            S = S + "Team " + CStr(pList(I).Frequency) + " cruiser: " + pList(I).SSName + ","
                        Case ALLOW.SHIPS_CAPITALS
                            S = S + "Team " + CStr(pList(I).Frequency) + " capital ship: " + pList(I).SSName + ","
                    End Select
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No online cruisers or capital ships"
                End If
            Case "!listops"
                S = ""
                For I = 1 To TotalOps
                    S = S + pList(OpList(I).OperatorOnline).SSName + ","
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No operators"
                End If
        End Select
        Exit Sub
    End If
    
    If OpList(pList(Sender).OpID).OperatorStatus = OP_SUPER Then
        If Left(Message, 5) = "!set " Then
            I = FindPlayer(TrimZero(Mid(Message, 8)))
            If I > 0 Then
                Select Case CInt(Val(Mid(Message, 6, 1)))
                    Case ALLOW.SHIPS_FIGHTERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, pList(I).SSName + " -> Fighter"
                        PrivateMessage I, "You are now a fighter. You may use ships 1-4  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CRUISERS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, pList(I).SSName + " -> Cruiser"
                        PrivateMessage I, "You are now a cruiser. You may use ships 1-7  -" + pList(Sender).SSName
                    Case ALLOW.SHIPS_CAPITALS
                        pList(I).ShipRestrictions = ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, pList(I).SSName + " -> Capital ship"
                        PrivateMessage I, "You are now a capital ship. You may use ships 1-8  -" + pList(Sender).SSName
                    Case Else
                        PrivateMessage Sender, "Format: !set <0-fighter,1-cruiser,2-cap> <player name>"
                End Select
            Else
                PrivateMessage Sender, TrimZero(Mid(Message, 8)) + " not online"
            End If
            Exit Sub
        End If
        
        If Left(Message, 11) = "!setaccess " Then
            Select Case CInt(Val(Mid(Message, 12, 1)))
                Case ALLOW.OP_PUBLIC
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_PUBLIC
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " stripped of operator status"
                Case ALLOW.OP_SIMPLE
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_SIMPLE
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " granted simple bot access"
                Case ALLOW.OP_ACCOUNT
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_ACCOUNT
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " granted account bot access"
                Case ALLOW.OP_SUPER
                    AddOp TrimZero(Mid(Message, 14)), ALLOW.OP_SUPER
                    PrivateMessage Sender, TrimZero(Mid(Message, 14)) + " granted super bot access"
                Case Else
                    PrivateMessage Sender, "Format: !setaccess <0-public,1-simple,2-account,3-super> <player name>"
            End Select
            Exit Sub
        End If
        
        If Left(Message, 3) = "!go" Then
            LeaveArena
            EnterArena 8, TrimZero(Trim(Mid(Message, 4)))
            Exit Sub
        End If
        
        Select Case Message
            Case "!help"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "(Super access:LaserRef On) Command list:"
                Else
                    PrivateMessage Sender, "(Super access:LaserRef Off) Command list:"
                End If
                PrivateMessage Sender, "!listops - List all operators"
                PrivateMessage Sender, "!list - List cruisers and capital ships"
                PrivateMessage Sender, "!allow - Display the ships you may use"
                PrivateMessage Sender, "!set <0-fighter,1-cruiser,2-cap> <player name> - Create a new cruiser or capital ship"
                PrivateMessage Sender, "!setaccess <0-public,1-simple,2-account,3-super> <player name> - Create a new operator"
                PrivateMessage Sender, "!enable/disable - Engage or disengage ship-checking"
                PrivateMessage Sender, "!go <arena name> - Move bot to specified arena"
            Case "!enable"
                If LaserRef_Enabled = True Then
                    PrivateMessage Sender, "LaserRef is already enabled"
                Else
                    LaserRef_Enabled = True
                    PublicMessage "*arena LaserRef enabled by " + pList(Sender).SSName
                End If
            Case "!disable"
                If LaserRef_Enabled = False Then
                    PrivateMessage Sender, "LaserRef is already disabled"
                Else
                    LaserRef_Enabled = False
                    PublicMessage "*arena LaserRef disabled by " + pList(Sender).SSName
                End If
            Case "!allow"
                Select Case pList(Sender).ShipRestrictions
                    Case ALLOW.SHIPS_FIGHTERS
                        PrivateMessage Sender, "You are a fighter.  Use ships 1-4"
                    Case ALLOW.SHIPS_CRUISERS
                        PrivateMessage Sender, "You are a cruiser.  Use ships 1-7"
                    Case ALLOW.SHIPS_CAPITALS
                        PrivateMessage Sender, "You are a capital ship.  Use ships 1-8"
                End Select
            Case "!list"
                S = ""
                For I = 0 To MAX_PLAYERS
                    Select Case pList(I).ShipRestrictions
                        Case ALLOW.SHIPS_CRUISERS
                            S = S + "Team " + CStr(pList(I).Frequency) + " cruiser: " + pList(I).SSName + ","
                        Case ALLOW.SHIPS_CAPITALS
                            S = S + "Team " + CStr(pList(I).Frequency) + " capital ship: " + pList(I).SSName + ","
                    End Select
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No online cruisers or capital ships"
                End If
            Case "!listops"
                S = ""
                For I = 1 To TotalOps
                    S = S + pList(OpList(I).OperatorOnline).SSName + ","
                Next
                If Len(S) > 0 Then
                    ClipString S
                    For I = 1 To Len(S) Step 40
                        PrivateMessage Sender, Mid(S, I, 40)
                    Next
                Else
                    PrivateMessage Sender, "No operators"
                End If
        End Select
        Exit Sub
    End If
End Sub
