Attribute VB_Name = "GUI"
Option Explicit

Public Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Public Enum MSG_CLASS
    MSG_PUBLIC = 0
    MSG_PRIVATE = 1
    MSG_REMOTE_PRIVATE = 2
    MSG_TEAM = 3
    MSG_TEAM_PRIVATE = 4
    MSG_CHANNEL = 5
    MSG_MYCHANNEL = 6
    MSG_UNKNOWN = 7
    MSG_ARENA = 8
    MSG_SERVER = 9
    MSG_SPECIAL = 10
End Enum

Public Enum STATE
    LOGIN_WINDOW = 1
    CHAT_WINDOW = 2
    ARENA_LIST_WINDOW = 3
    STATUS_WINDOW = 4
End Enum

Public WINDOW_STATE As STATE

Private S As String * 255
Private L As Long

'INI read/write

Public Function GetProfileString(Section As String, Key As String) As String
    L = GetPrivateProfileString(Section, Key, "", S, 255, App.Path + "\SSChat.INI")
    GetProfileString = Left(S, L)
End Function

Public Sub SetProfileString(Section As String, Key As String, Value As String)
    WritePrivateProfileString Section, Key, Value, App.Path + "\SSChat.INI"
End Sub

'Mainfrm STATES

Public Sub SetState(NEW_STATE As STATE)
    WINDOW_STATE = NEW_STATE

    Select Case NEW_STATE
        Case STATE.LOGIN_WINDOW
            UpdateTitle "Login screen"
        
            MainFrm.CHAT.Visible = False
            MainFrm.ARENA.Visible = False
            MainFrm.STATUS.Visible = False
            MainFrm.LOGIN.Visible = True

            MainFrm.ChatText = ""

            DebugDialog.Visible = False
        Case STATE.STATUS_WINDOW
            UpdateTitle "Download status"
        
            MainFrm.CHAT.Visible = False
            MainFrm.ARENA.Visible = False
            MainFrm.LOGIN.Visible = False
            MainFrm.STATUS.Visible = True

            MainFrm.StatusText = ""

            If MainFrm.LoginSettings.List(0) = "1" Then DebugDialog.Visible = True
        Case STATE.ARENA_LIST_WINDOW
            UpdateTitle "Select an arena"
        
            MainFrm.ARENA.Visible = True

            MainFrm.ArenaList.Clear
        Case STATE.CHAT_WINDOW
            UpdateTitle "Connecting..."
        
            MainFrm.ARENA.Visible = False
            MainFrm.STATUS.Visible = False
            MainFrm.LOGIN.Visible = False
            MainFrm.CHAT.Visible = True

            If MainFrm.LoginSettings.List(0) = "1" Then DebugDialog.Visible = True
    End Select
End Sub

'CONNECT/DISCONNECT/CLEANUP

Public Sub Connect(IP As Long, Port As Integer, REMOTE_TYPE As SERVER_FORMAT)
    ResetSession

    MainFrm.SSL.Enabled = True
    Connected = True

    With UDPMySock
        .Remote.sin_addr = IP
        .Remote.sin_port = htons(Port)
        .Remote.sin_family = 2

        UDPSendNE .Remote, Make01Key

        SERVER_TYPE = REMOTE_TYPE
    End With
End Sub

Public Sub SendLogin(User As String, Password As String, MachineID As Long, TimeZoneBias As Integer, PermissionID As Integer, NewUser As Byte)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(9) + Chr(NewUser) + FillZero(User, 32) + FillZero(Password, 32) + GetString(MachineID) + Chr(3) + GetString2(TimeZoneBias) + GetString2(PermissionID) + GetString2(&H86) + GetString(&H1BC) + GetString(&H22B) + GetString(MachineID) + String(12, Chr(0))
End Sub

Public Sub SendSync(NumberOfAttempts As Long)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(5) + GetString(GetTickCount \ 10) + GetString(3) + GetString(NumberOfAttempts)
End Sub

Public Sub LeaveServer()
    UDPSendNE UDPMySock.Remote, Chr(0) + Chr(7)

    Reset_Virtual_Connection
End Sub

Public Sub Reset_Virtual_Connection()
    MainFrm.Periodic.Enabled = False
    MainFrm.SSL.Enabled = False
    Connected = False
    SERVER_TYPE = GameServer

    SetState LOGIN_WINDOW
End Sub

Public Sub ResetSession()
    ClearACKs
    ClearSecures
    ResetKey
End Sub

'Mainfrm.LOGIN

'Mainfrm.STATUS

Public Sub AddStatus(ByVal mStr As String)
    With MainFrm.StatusText
        If .Text <> "" Then mStr = vbNewLine + mStr
        .Text = Right(.Text, 10000) + mStr
        .SelStart = 15000
    End With
End Sub

'Mainfrm.ARENA

Public Sub EnterArena(ShipType As Byte, ArenaName As String)
    If ArenaName = "" Then
        UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(1) + Chr(ShipType) + Chr(1) + GetString2(0) + GetString2(4) + Chr(3) + GetString2(&HFFFF) + String(16, Chr(0))
    Else
        UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(1) + Chr(ShipType) + Chr(1) + GetString2(0) + GetString2(4) + Chr(3) + GetString2(&HFFFD) + FillZero(ArenaName, 16)
    End If
End Sub

Public Sub LeaveArena()
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(2)

    MainFrm.ChatUsers.Clear

    SetState ARENA_LIST_WINDOW
End Sub

'Mainfrm.CHAT

Public Sub PrivateMessage(PIndex As Integer, Message As String)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(6) + GetString2(5) + GetString2(PIndex) + Message + Chr(0)
    ChatMessage MSG_PRIVATE, Message, pList(MyID).SSName
End Sub

Public Sub PublicMessage(Message As String)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(6) + GetString2(2) + GetString2(0) + Message + Chr(0)
    ChatMessage MSG_PUBLIC, Message, pList(MyID).SSName
End Sub

Public Sub TeamMessage(Message As String)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(6) + GetString2(3) + GetString2(0) + Message + Chr(0)
    ChatMessage MSG_TEAM, Message, pList(MyID).SSName
End Sub

Public Sub ChannelMessage(Message As String)
    UDPSend UDPMySock.Remote, Chr(0) + Chr(3) + NextSID + Chr(6) + GetString2(9) + GetString2(0) + Message + Chr(0)
    ChatMessage MSG_MYCHANNEL, Message, pList(MyID).SSName
End Sub

Public Sub ChatMessage(ByVal MsgType As MSG_CLASS, ByVal Message As String, Optional ByVal UserName As String)
    Dim MessageColor As Long, NameColor As Long

    Select Case MsgType
        Case MSG_CLASS.MSG_PUBLIC
            MessageColor = RGB(160, 160, 200)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_PRIVATE
            MessageColor = RGB(0, 200, 0)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_REMOTE_PRIVATE
            MessageColor = RGB(0, 180, 0)
            NameColor = MessageColor
            UserName = "(" + UserName + ")> "
        Case MSG_CLASS.MSG_TEAM
            MessageColor = RGB(255, 200, 0)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_TEAM_PRIVATE
            MessageColor = RGB(160, 160, 160)
            NameColor = RGB(0, 200, 0)
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_CHANNEL
            MessageColor = RGB(200, 0, 0)
        Case MSG_CLASS.MSG_MYCHANNEL
            MessageColor = RGB(200, 0, 0)
            NameColor = RGB(200, 0, 0)
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_UNKNOWN
            MessageColor = RGB(200, 0, 200)
            NameColor = MessageColor
            UserName = UserName + "(Unknown Chat Type)> "
        Case MSG_CLASS.MSG_ARENA
            MessageColor = RGB(0, 230, 0)
        Case MSG_CLASS.MSG_SERVER
            MessageColor = RGB(210, 210, 210)
        Case MSG_CLASS.MSG_SPECIAL
            MessageColor = RGB(255, 0, 255)
            Message = "--" + Message
    End Select

    With MainFrm.ChatText
        .SelStart = Len(.Text)
        .SelFontName = "MS Sans Serif"
        .SelFontSize = 10
        .SelBold = True
        .SelItalic = False
        .SelUnderline = False

        .SelText = vbCrLf

        If MsgType < MSG_CLASS.MSG_ARENA Then
            .SelColor = NameColor
            .SelText = UserName
        End If

        .SelColor = MessageColor
        .SelText = Message

        .SelStart = Len(.Text)
    End With
End Sub
