Attribute VB_Name = "DrawChat"
Option Explicit

Public Enum MSG_CLASS
    MSG_PUBLIC = 0
    MSG_PRIVATE = 1
    MSG_REMOTE_PRIVATE = 2
    MSG_TEAM = 3
    MSG_TEAM_PRIVATE = 4
    MSG_CHANNEL = 5
    MSG_MYCHANNEL = 6
    MSG_UNKNOWN = 7
    MSG_ARENA = 8
    MSG_SERVER = 9
    MSG_SPECIAL = 10
End Enum

Public Sub AddMessage(ByVal MsgType As Integer, ByVal Message As String, Optional ByVal UserName As String)
    Dim MessageColor As Long, NameColor As Long
    
    Select Case MsgType
        Case MSG_CLASS.MSG_PUBLIC
            MessageColor = RGB(160, 160, 200)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_PRIVATE
            MessageColor = RGB(0, 200, 0)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_REMOTE_PRIVATE
            MessageColor = RGB(0, 180, 0)
            NameColor = MessageColor
            UserName = "(" + UserName + ")> "
        Case MSG_CLASS.MSG_TEAM
            MessageColor = RGB(255, 200, 0)
            NameColor = MessageColor
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_TEAM_PRIVATE
            MessageColor = RGB(160, 160, 160)
            NameColor = RGB(0, 200, 0)
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_CHANNEL
            MessageColor = RGB(200, 0, 0)
        Case MSG_CLASS.MSG_MYCHANNEL
            MessageColor = RGB(200, 0, 0)
            NameColor = RGB(200, 0, 0)
            UserName = UserName + "> "
        Case MSG_CLASS.MSG_UNKNOWN
            MessageColor = RGB(200, 0, 200)
            NameColor = MessageColor
            UserName = UserName + "(Unknown Chat Type)> "
        Case MSG_CLASS.MSG_ARENA
            MessageColor = RGB(0, 230, 0)
        Case MSG_CLASS.MSG_SERVER
            MessageColor = RGB(210, 210, 210)
        Case MSG_CLASS.MSG_SPECIAL
            MessageColor = RGB(255, 0, 255)
            Message = "--" + Message
    End Select
    
    With MainFrm.sOut
        .SelStart = Len(.Text)
        .SelFontName = "MS Sans Serif"
        .SelFontSize = 10
        .SelBold = True
        .SelItalic = False
        .SelUnderline = False
        
        .SelText = vbCrLf
        
        If MsgType < MSG_CLASS.MSG_ARENA Then
            .SelColor = NameColor
            .SelText = UserName
        End If
    
        .SelColor = MessageColor
        .SelText = Message
    
        .SelStart = Len(.Text)
    End With
End Sub
