VERSION 5.00
Object = "{669D364F-0E48-11D4-89BE-D0214EC10000}#484.0#0"; "JgSocket.ocx"
Begin VB.Form FormMain 
   Caption         =   "SS Client Filter"
   ClientHeight    =   5325
   ClientLeft      =   900
   ClientTop       =   2760
   ClientWidth     =   9120
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   5325
   ScaleWidth      =   9120
   Begin JgSocket.jgSock SockClient 
      Left            =   2790
      Top             =   960
      _ExtentX        =   953
      _ExtentY        =   953
      SocketType      =   3
      LocalPort       =   0
      RemoteHost      =   ""
      RemoteIP        =   ""
      RemotePort      =   0
      Timeout         =   10
      Linger          =   0   'False
      DataSize        =   2048
      LineMode        =   0   'False
      EOLChar         =   10
      BindConnect     =   0   'False
      LocalService    =   ""
      RemoteService   =   ""
      IPSend          =   0   'False
      IPRecv          =   0   'False
      Object.Tag             =   ""
   End
   Begin JgSocket.jgSock SockServer 
      Left            =   1785
      Top             =   1020
      _ExtentX        =   953
      _ExtentY        =   953
      SocketType      =   3
      LocalPort       =   0
      RemoteHost      =   ""
      RemoteIP        =   ""
      RemotePort      =   0
      Timeout         =   10
      Linger          =   0   'False
      DataSize        =   2048
      LineMode        =   0   'False
      EOLChar         =   10
      BindConnect     =   0   'False
      LocalService    =   ""
      RemoteService   =   ""
      IPSend          =   0   'False
      IPRecv          =   0   'False
      Object.Tag             =   ""
   End
   Begin VB.TextBox Text1 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   900
      Left            =   0
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   0
      Width           =   930
   End
End
Attribute VB_Name = "FormMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private ServerIP As String
Private ServerPort As Integer
Private FilterPort As Integer
Private DebugMode As Boolean
Private SwIni As Integer
Private Log As String

Private a As String
Private b As Integer

Private Sub Form_Load()
    'Dim str1 As String
    'str1 = Space(2000000)
    'Text1 = Space(80000)

    On Error Resume Next
    '
    FormMain.Left = 0
    FormMain.Top = 0
    '--------------------------------------------------------------------
    'SSClientFilter.ini structure:
    '  [Filter]
    '  Port=<Filter local port>   -->(Local port to listen to the client)
    '
    '  [Game server]
    '  IP=<Game server IP>        -->(Address of game server)
    '  Port=<Game server port>    -->(Port of game server)
    '
    '  [Debug]
    '  DebugMode=<0|1>            -->(0=Debug OFF, 1=Debug ON)
    '--------------------------------------------------------------------
    '
    'SSClientFilter.ini
    If Dir(App.Path + "\SSClientFilter.ini") = "" Then
        MsgBox "Error. SSClientFilter.ini not found."
        End
    End If
    '
    'Filter Port
    FilterPort = Val(GetProfileString("Filter", "Port"))
    If Err Or FilterPort = 0 Then
        MsgBox "Error in SSClientFilter.ini. [Local]Port", vbExclamation
        End
    End If
    '
    'Game server IP
    ServerIP = GetProfileString("Game server", "IP")
    If Err Or ServerIP = "" Then
        MsgBox "Error in SSClientFilter.ini. [Game server]IP", vbExclamation
        End
    End If
    '
    'Game server Port
    ServerPort = Val(GetProfileString("Game server", "Port"))
    If Err Or ServerPort = 0 Then
        MsgBox "Error in SSClientFilter.ini. [Game server]Port", vbExclamation
        End
    End If
    '
    'Debug mode
    DebugMode = GetProfileString("Debug", "Mode")
    If Err Then
        MsgBox "Error in SSClientFilter.ini. [Debug]Mode", vbExclamation
        End
    End If
End Sub

Private Sub Form_Activate()
    On Error Resume Next
    '
    If SwIni = 0 Then
        SwIni = 1
        '
        If Dir("LOG1.TXT") <> "" Then Kill "LOG1.TXT"
        Open "LOG1.TXT" For Binary As #1
        '
        SockServer.Klose
        SockServer.SocketType = SOCK_IP
        SockServer.IPSend = False 'Force use of SendTo for SOCK_IP (use SOCK_IP as SOCK_UDP)
        SockServer.IPRecv = False 'Force use of RecvFrom for SOCK_IP   ''
        SockServer.DataSize = 522
        SockServer.RemoteIP = ServerIP
        SockServer.RemotePort = ServerPort
        SockServer.UDPClient
        If Err Then
            MsgBox "Error in server socket. Error: " & Err.Number & " - " & Err.Description, vbExclamation
            End
        Else
            DisplayMsg "Server socket ready for: " & SockServer.RemoteIP & ":" & SockServer.RemotePort
            AddLogMsg "Server socket ready for: " & SockServer.RemoteIP & ":" & SockServer.RemotePort
        End If
        '
        SockClient.Klose
        SockClient.SocketType = SOCK_IP
        SockClient.IPSend = False 'Force use of SendTo for SOCK_IP (use SOCK_IP as SOCK_UDP)
        SockClient.IPRecv = False 'Force use of RecvFrom for SOCK_IP   ''
        SockClient.DataSize = 522
        SockClient.LocalPort = FilterPort
        SockClient.UDPServer
        If Err Then
            MsgBox "Error in client socket. Error: " & Err.Number & " - " & Err.Description, vbExclamation
            End
        Else
            DisplayMsg "Client socket listening on port: " & SockClient.LocalPort
            AddLogMsg "Client socket listening on port: " & SockClient.LocalPort
        End If
        '
        If DebugMode = True Then
            DisplayMsg "Debug ON" & vbCrLf
            AddLogMsg "Debug ON" & vbCrLf
        Else
            DisplayMsg "Debug OFF" & vbCrLf
            AddLogMsg "Debug OFF" & vbCrLf
        End If
        '
    End If
End Sub

Private Sub Form_Resize()
    If FormMain.WindowState <> vbMinimized Then
        Text1.Width = FormMain.Width - (8 * Screen.TwipsPerPixelX)
        Text1.Height = FormMain.Height - (27 * Screen.TwipsPerPixelY)
    End If
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    On Error Resume Next
    SockClient.Klose
    SockServer.Klose
    Close #1
End Sub

Private Sub SockClient_Receive(ReceiveData As String)
    Dim UnEncryptedPacket As String
    Dim Msg As String
    Dim File As String
    Dim StrAux As String
    '
    'On Error Resume Next
    '
    SockClient.RecvBlock = True
    '
    b = SockClient.RemotePort
    '
    'Trapping C2S traffic
    '
    'If DebugMode = True Then UnEncryptedPacket = Decrypt(ReceiveData)
    '
    Select Case Left(ReceiveData, 2)
        Case Chr(0) & Chr(1)
            DisplayMsg "BEGIN SESSION"
            AddLogMsg "BEGIN SESSION"
            DisplayMsg "Client connected. " & SockClient.RemoteIP & ":" & SockClient.RemotePort
            'AddLogMsg "Client connected. " & SockClient.remoteip & ":" & SockClient.RemotePort
            DisplayMsg "C2S. 01 key received." & vbCrLf
            FirstKey = StringToLong(Mid(ReceiveData, 3, 4))
            'AddLogMsg "C2S. 01 key received."
        Case Chr(0) & Chr(3)
            UnEncryptedPacket = Decrypt(ReceiveData)
            If Mid(UnEncryptedPacket, 7, 1) = Chr(6) _
            And StringToInt(Mid(UnEncryptedPacket, 8, 2)) = 2 _
            And StringToInt(Mid(UnEncryptedPacket, 10, 2)) = 0 Then 'Public msg (C2S)
                'Filter built-in commands
                Msg = TrimZero(Mid(UnEncryptedPacket, 12))
                Select Case Left(LCase(Msg), 4)
                    Case "*don" 'Debug ON
                        DebugMode = True
                        DisplayMsg vbCrLf & "Debug ON" & vbCrLf
                        AddLogMsg vbCrLf & "Debug ON" & vbCrLf
                    Case "*dof" 'Debug OFF
                        DebugMode = False
                        DisplayMsg vbCrLf & "Debug OFF" & vbCrLf
                        AddLogMsg vbCrLf & "Debug OFF" & vbCrLf
                    Case "*cls" 'Clear log
                        'Text1 = ""
                        Log = ""
                    Case "*sa." 'Save log to file on disk
                        File = Mid(Msg, 5)
                        If Dir(File) <> "" Then Kill File
                        Open File For Binary As #1
                        If Err Then
                            DisplayMsg "Cant open file for output: " & File
                            AddLogMsg "Cant open file for output: " & File
                        Else
                            DisplayMsg "Log file saved: " & File
                            AddLogMsg "Log file saved: " & File
                            'StrAux = Text1
                            'Put #1, , StrAux
                            Put #1, , Log
                            Close #1
                        End If
                End Select
            End If
        Case Chr(0) & Chr(7)
            DisplayMsg "Disconnected by user."
            AddLogMsg "Disconnected by user."
            DisplayMsg "END SESSION" & vbCrLf
            AddLogMsg "END SESSION" & vbCrLf
    End Select
    '
'    If Asc(ReceiveData) = 3 And Len(ReceiveData) = 20 Then
'        ReceiveData = Left(ReceiveData, 18) & Chr(&HC4) & Chr(&H9) & Mid(ReceiveData, 21)
'    End If
'    '
    'Forward C2S traffic
    SockServer.RemotePort = ServerPort
    SockServer.Send ReceiveData
    If Err Then
        DisplayMsg "YYYYError in F2S SendTo. Error: " & Err.Number & " - " & Err.Description
        AddLogMsg "Error in F2S SendTo. Error: " & Err.Number & " - " & Err.Description
    End If
    '
    If DebugMode = True Then
        If UnEncryptedPacket = "" Then UnEncryptedPacket = Decrypt(ReceiveData)
        If Len(UnEncryptedPacket) > 0 Then AddDebug "C2S", UnEncryptedPacket
    End If
    '
    SockClient.RecvBlock = False
End Sub

Private Sub SockClient_Exception(ErrorCode As Integer, ErrorDesc As String)
    SockClient.Klose
    DisplayMsg "HHHError in C2F socket. Error: " & ErrorCode & " - " & ErrorDesc
    AddLogMsg "Error in C2F socket. Error: " & ErrorCode & " - " & ErrorDesc
    DisplayMsg "END SESSION" & vbCrLf
    AddLogMsg "END SESSION" & vbCrLf
End Sub
    
Private Sub SockServer_Receive(ReceiveData As String)
    Dim UnEncryptedPacket As String
    '
    'On Error Resume Next
    '
    SockServer.RecvBlock = True
    '
    'Trapping S2C traffic
    '
    Select Case Left(ReceiveData, 2)
        Case Chr(0) & Chr(2)
            DisplayMsg "Server connected. " & SockServer.RemoteIP & ":" & SockServer.RemotePort
            'AddLogMsg "Server connected. " & SockServer.remoteip & ":" & SockServer.RemotePort
            DisplayMsg "S2C. 02 key received." & vbCrLf
            'AddLogMsg "S2C. 02 key received."
            SSTable.SSKey = StringToLong(Mid(ReceiveData, 3, 4))
            If SSTable.SSKey <> FirstKey Then SSInit SSTable
        Case Chr(0) & Chr(7)
            DisplayMsg "Disconnected by server."
            AddLogMsg "Disconnected by server."
            DisplayMsg "END SESSION" & vbCrLf
            AddLogMsg "END SESSION" & vbCrLf
    End Select
    '
    'Forward S2C traffic
    SockClient.RemotePort = b
    SockClient.Send ReceiveData
    If Err Then
        DisplayMsg "XXXError in F2C SendTo. Error: " & Err.Number & " - " & Err.Description & " " & SockClient.RemoteIP & " " & SockClient.RemotePort
        AddLogMsg "Error in F2C SendTo. Error: " & Err.Number & " - " & Err.Description
    End If
    '
    If DebugMode = True Then
        UnEncryptedPacket = Decrypt(ReceiveData)
        If Len(UnEncryptedPacket) > 0 Then AddDebug "S2C", UnEncryptedPacket
    End If
    '
    SockServer.RecvBlock = False
End Sub

Private Sub SockServer_Exception(ErrorCode As Integer, ErrorDesc As String)
    SockServer.Klose
    DisplayMsg "Error in F2S socket. Error: " & ErrorCode & " - " & ErrorDesc
    AddLogMsg "Error in F2S socket. Error: " & ErrorCode & " - " & ErrorDesc
    DisplayMsg "END SESSION" & vbCrLf
    AddLogMsg "END SESSION" & vbCrLf
End Sub

Private Sub DisplayMsg(Msg As String)
    'Exit Sub
    Text1 = Text1 & vbCrLf & Msg
    Text1.SelStart = Len(Text1)
    Text1.Refresh
End Sub

Private Sub AddLogMsg(Msg As String)
    'Log = Log & vbCrLf & Msg
    'Put #1, , vbCrLf & Msg
End Sub

Private Sub AddDebug(Direction As String, Packet As String)
    Dim n As Integer
    Dim Line1 As String
    Dim HexData As String
    Dim AsciiData As String
    Dim NumLine As Integer
    '
    On Error Resume Next
    '
    Select Case Direction
        Case "C2S"
            Log = "SendTo: " & Len(Packet) & " by (" & Hex(Len(Packet)) & "h) " & _
                  Fill00(Hex(Asc(Mid(Packet, 1, 1)))) & " " & Fill00(Hex(Asc(Mid(Packet, 2, 1)))) & vbCrLf
            'AddLogMsg vbCrLf & "SendTo(C2S): " & Len(Packet) & " by (" & Hex(Len(Packet)) & "h) " & _
            '          Fill00(Hex(Asc(Mid(Packet, 1, 1)))) & " " & Fill00(Hex(Asc(Mid(Packet, 2, 1))))
        Case "S2C"
            Log = "RecvFrom: " & Len(Packet) & " by (" & Hex(Len(Packet)) & "h) " & _
                  Fill00(Hex(Asc(Mid(Packet, 1, 1)))) & " " & Fill00(Hex(Asc(Mid(Packet, 2, 1)))) & vbCrLf
            'AddLogMsg vbCrLf & "RecvFrom(S2C): " & Len(Packet) & " by (" & Hex(Len(Packet)) & "h) " & _
            '          Fill00(Hex(Asc(Mid(Packet, 1, 1)))) & " " & Fill00(Hex(Asc(Mid(Packet, 2, 1))))
    End Select
    '
    Log = Log & "       0  1  2  3  4  5  6  7- 8  9  A  B  C  D  E  F  0123456789ABCDEF" & vbCrLf
    'AddLogMsg "       0  1  2  3  4  5  6  7- 8  9  A  B  C  D  E  F  0123456789ABCDEF"
    Do
        Line1 = Left(Packet, 16): If Len(Line1) = 0 Then Exit Do
        '
        HexData = ""
        AsciiData = ""
        For n = 1 To Len(Line1)
            If n = 9 Then
                HexData = HexData & "-" & Fill00(Hex(Asc(Mid(Line1, n, 1))))
            Else
                HexData = HexData & " " & Fill00(Hex(Asc(Mid(Line1, n, 1))))
            End If
            AsciiData = AsciiData & TranslateToAscii(Mid(Line1, n, 1))
        Next
        Log = Log & Fill0000(Hex(NumLine * 16)) & " " & HexData & Space(50 - Len(HexData)) & AsciiData & vbCrLf
        'AddLogMsg Fill0000(Hex(NumLine * 16)) & " " & HexData & Space(50 - Len(HexData)) & AsciiData
        '
        Packet = Mid(Packet, 17)
        NumLine = NumLine + 1
    Loop
    '
    Log = Log & vbCrLf
    Put #1, , Log
End Sub

Private Function Fill00(Str1 As String) As String
    If Len(Str1) = 1 Then
        Fill00 = "0" & Str1
    Else
        Fill00 = Str1
    End If
End Function

Private Function Fill0000(Str1 As String) As String
    If Len(Str1) < 4 Then
        Fill0000 = String(4 - Len(Str1), "0") & Str1
    Else
        Fill0000 = Str1
    End If
End Function

Private Function TranslateToAscii(Char As String) As String
    If Char < Chr(32) Or Char > Chr(127) Then
        TranslateToAscii = "."
    Else
        TranslateToAscii = Char
    End If
End Function

