Attribute VB_Name = "VirtualList"
Option Explicit

Private MsgList(1 To 5000) As SSMsg
Private TotalMsgs As Integer

Private Const cPrivate = 1              'Message-types
Private Const cPublic = 2
Private Const cTeam = 3
Private Const cTeamSpec = 4
Private Const cChat = 6
Private Const cTeamPrivate = 63         'End of message-types

Public LastTotal As Integer

Public Sub DrawMsg(MsgIndex As Integer, TotalShown As Integer)
    Dim L As Long
    
    Select Case MsgList(MsgIndex).Class
        Case cPrivate: L = RGB(0, 255, 0)
        Case cPublic: L = RGB(0, 255, 255)
        Case cTeam: L = RGB(255, 255, 0)
        Case cTeamSpec: L = RGB(255, 255, 0)
        Case cChat: L = RGB(255, 0, 0)
        Case cTeamPrivate: L = RGB(0, 255, 255)
        Case Else: L = RGB(200, 200, 200)
    End Select
    SetTextColor MainFrm.ChatList.hdc, L
    TextOut MainFrm.ChatList.hdc, 0, (TotalShown - MsgIndex - 1) * 12, MsgList(MsgIndex).RawText, Len(MsgList(MsgIndex).RawText)
End Sub

Public Sub ClearMsg(MsgIndex As Integer, TotalShown As Integer)
    SetTextColor MainFrm.ChatList.hdc, RGB(0, 0, 0)
    TextOut MainFrm.ChatList.hdc, 0, (TotalShown - MsgIndex - 1) * 12, MsgList(MsgIndex).RawText, Len(MsgList(MsgIndex).RawText)
End Sub

Public Sub ReDraw()
    MainFrm.ChatList.Refresh
End Sub

Public Sub AddMsg(msg As SSMsg)
    Dim I As Integer, o As String, C As Integer
    C = CInt(MainFrm.ChatList.Width / 72)

    o = Trim(msg.RawText)
    If Len(o) > C Then
        For I = 1 To Len(o) Step C
            msg.RawText = Mid(o, I, C)
            AddMsg msg
        Next
        Exit Sub
    End If
    msg.RawText = o
    
    C = CInt(MainFrm.ChatList.Height / 188) + 1
    For I = 1 To C
        ClearMsg I, C
    Next
    If TotalMsgs < 5000 Then TotalMsgs = TotalMsgs + 1
    For I = TotalMsgs To 2 Step -1
        MsgList(I) = MsgList(I - 1)
    Next
    MsgList(1) = msg
    For I = 1 To C
        DrawMsg I, C
    Next
    ReDraw
    
    LastTotal = C
End Sub

Public Sub ResizeMsgs()
    Dim I As Integer, C As Integer
    
    C = CInt(MainFrm.ChatList.Height / 188) + 1
    If C = LastTotal Then Exit Sub
    
    For I = 1 To LastTotal
        ClearMsg I, LastTotal
    Next
    For I = 1 To C
        DrawMsg I, C
    Next
    ReDraw

    LastTotal = C
End Sub

Public Sub DeleteAllMsgs()
    Dim I As Integer

    For I = 1 To TotalMsgs
        ClearMsg I, LastTotal
    Next

    TotalMsgs = 0
End Sub
