Attribute VB_Name = "ShipBotLib"
Option Explicit

Public Const cPrivate = 1              'Message-types
Public Const cPublic = 2
Public Const cTeam = 3
Public Const cTeamSpec = 4
Public Const cChat = 6
Public Const cTeamPublic = 63         'End of message-types

Public Marker               As String   'Used for messages
Public MyName               As String   'User's name in the zone

Public hTickedWindow        As Long     'hWnd of where to send msgs

Public OldSubGame           As Boolean  'Use *spec + *spec if illegal for more than 10 seconds
Public GreetMessage         As String   'Send the welcome msg?
Public UseGreet             As Boolean  'Set greeting message

Public PlayersRequired      As Integer

Type SSMsg
    Command                 As String       'Command's text
    User                    As String       'Sender of the command
    Channel                 As String * 1   'Chat channel, if applicable
    Class                   As Integer      'Source of command
    RawText                 As String       'Unformatted text
End Type

Type SShip
    User                    As String       'Player's name
'    Squad                   As String       'Player's squad
    ShipType                As Integer      'Player's ship type
    Freq                    As Long         'Player's freq
    addr                    As Long         'So I can look this stuff up later
    AntiWarp                As Boolean      'Antiwarp on the current screen?
    BadShipTimeOut          As Integer      'Time in cycles since he was in an acceptable ship
    AntiwarpTimeOut         As Integer      'Time in cycles since he was using legal antiwarp
'    Losses                  As Long
End Type

Public hTextHandle      As Long

Public pList(1 To 255)  As SShip
Public TotalPlayers     As Integer

Public OutBox(1 To 255) As String
Public TotalMessages    As Integer

Public Normalizer       As Integer
Public NewTotal         As Integer

Public Enabled As Boolean

Public Sub ReadMessages()
    Dim Unread As String, I As Integer, x As Integer, msg As SSMsg

    If Marker = "" Then
        For I = 39 To 0 Step -1
            msg = MakeSSMsg(4738784 + (188 * I), 4738624 + (188 * I))
            If msg.RawText = "" Then Exit For
            AddMsg msg
        Next
        msg.Class = 0: msg.RawText = "Welcome to ShipBot!  Type ""!help"" for commands": AddMsg msg
        Marker = Peek(4738624, 65)
    Else
        Do
            If Peek((188 * x) + 4738624, 65) = Marker Then Exit Do
            x = x + 1
        Loop Until x = 40
        If x > 0 Then Marker = Peek(4738624, 65)
        For I = x - 1 To 0 Step -1
            x = (188 * I)
            msg = MakeSSMsg(4738784 + x, 4738624 + x)
            HandleCmds msg
            AddMsg msg
        Next
    End If
End Sub

Public Sub HandleCmds(Cmd As SSMsg)
    Dim I As Integer, J As Long, K As Integer, o As String, F(0 To 1) As Long, p(0 To 1) As Integer
    'Dim killee As String
    'Dim killer As String

    If Cmd.Class <> cPrivate Then Exit Sub
    If Cmd.User = "" Then
        Collect RTrim(Cmd.RawText)
        'J = InStr(1, RTrim(Cmd.RawText), ") killed by: ")
        'If J > 0 Then
'
'            killee = LCase(Left(RTrim(Cmd.RawText), J - 1))
'            killer = LCase(Mid(RTrim(Cmd.RawText), J + 13))
'            For I = Len(killee) To 1 Step -1
'                If Mid(killee, I, 1) = "(" Then
'                    killee = Left(killee, I - 1)
'                    Exit For
'                End If
'            Next

'            For J = 1 To TotalPlayers
'                If killer = LCase(pList(J).User) Then Exit For
'            Next
'            For K = 1 To TotalPlayers
'                If killee = LCase(pList(K).User) Then Exit For
'            Next

'            pList(J) = GetInfo(pList(J))
'            pList(K) = GetInfo(pList(K))
            
            'If pList(K).ShipType = 8 Then Exit Sub
            
'            SendText "*arena" + pList(K).User + "(Team " + CStr(pList(K).Freq) + ") captured by " + pList(J).User + "(Team " + CStr(pList(J).Freq) + ")%" + CStr(Int(Rnd * 60) + 1)
'            SendText ":" + pList(K).User + ":*setfreq " + CStr(pList(J).Freq) + " " + pList(K).User

'        ElseIf RTrim(Cmd.RawText) = "Team victory!" Or Left(Cmd.RawText, 19) = "Opposing team won (" Then
        If RTrim(Cmd.RawText) = "Team victory!" Or Left(Cmd.RawText, 19) = "Opposing team won (" Then
            J = 0
            If Enabled = False Then Exit Sub
            For I = 1 To TotalPlayers
                If pList(I).ShipType < 9 Then J = J + 1
            Next
            If J >= PlayersRequired Then
                    For I = 1 To TotalPlayers
                        J = Peek4(pList(I).addr + 78) + Peek4(pList(I).addr + 74) + Peek4(pList(I).addr + 70) + Peek4(pList(I).addr + 66)
                        Select Case pList(I).Freq
                            Case 0: If J > F(0) Then F(0) = J: p(0) = I
                            Case 1: If J > F(1) Then F(1) = J: p(1) = I
                        End Select
                    Next
                    If OldSubGame = True Then
                    For I = 1 To TotalCapitalShips
                        For J = 1 To TotalPlayers
                            If LCase(pList(J).User) = CapitalShips(I) Then
                                Select Case pList(J).Freq
                                    Case 0
                                        AddQueue ":" + CapitalShips(I) + ":The game has ended.  Press ESC + (1 to 3)"
                                    Case 1
                                        AddQueue ":" + CapitalShips(I) + ":The game has ended.  Press ESC + (4 to 6)"
                                End Select
                            End If
                        Next
                    Next
                    End If
                    AddQueue "*arena" + pList(p(0)).User + "(Imperials) and " + pList(p(1)).User + "(Rebels) are high scorers.%1"
                    AddQueue "*arenaPlease announce one legal capital ship for your team -ShipBot%2"
            Else
                AddQueue "*arenaNo caps this game -ShipBot"
            End If
            TotalCapitalShips = 0
        End If
        Exit Sub
    End If

    With Cmd
        For J = 1 To TotalOperators
            If Operators(J) = LCase(.User) Then
                If LCase(Left(.Command, 3)) = "op " Then
                    For I = 1 To TotalOperators
                        If Operators(I) = LCase(Trim(Mid(.Command, 4))) Then
                            RemOp I
                            AddQueue ":" + .User + ":Op removed: " + Trim(Mid(.Command, 4))
                            Exit Sub
                        End If
                    Next
                    AddQueue ":" + .User + ":Op added: " + Trim(Mid(.Command, 4))
                    AddOp Trim(Mid(.Command, 4))
                ElseIf LCase(Left(.Command, 4)) = "cap " Then
                    For I = 1 To TotalCapitalShips
                        If CapitalShips(I) = LCase(Trim(Mid(.Command, 5))) Then
                            RemCap I
                            AddQueue ":" + .User + ":Cap removed: " + Trim(Mid(.Command, 5))
                            If OldSubGame = True Then
                            For K = 1 To TotalPlayers
                                If LCase(pList(K).User) = LCase(Trim(Mid(.Command, 5))) Then
                                    Select Case pList(K).Freq
                                        Case 0
                                            AddQueue ":" + Trim(Mid(.Command, 5)) + ":You are no longer a capital ship for the Imperials.  Press ESC + (1 to 3)"
                                        Case 1
                                            AddQueue ":" + Trim(Mid(.Command, 5)) + ":You are no longer a capital ship for the Rebels.  Press ESC + (4 to 6)"
                                    End Select
                                    Exit For
                                End If
                            Next
                            End If
                            Exit Sub
                        End If
                    Next
                    AddQueue ":" + .User + ":Cap added: " + Trim(Mid(.Command, 5))
                    If OldSubGame = True Then
                    For K = 1 To TotalPlayers
                        If LCase(pList(K).User) = LCase(Trim(Mid(.Command, 5))) Then
                            Select Case pList(K).Freq
                                Case 0
                                    AddQueue ":" + Trim(Mid(.Command, 5)) + ":You have been chosen as a capital ship for the Imperials.  Press ESC + 8"
                                Case 1
                                    AddQueue ":" + Trim(Mid(.Command, 5)) + ":You have been chosen as a capital ship for the Rebels.  Press ESC + 7"
                            End Select
                            Exit For
                        End If
                    Next
                    End If
                    AddCap Trim(Mid(.Command, 5))
                ElseIf LCase(Left(.Command, 7)) = "ignore " Then
                    For I = 1 To TotalIgnores
                        If Ignores(I) = LCase(Trim(Mid(.Command, 8))) Then
                            RemIgnore I
                            AddQueue ":" + .User + ":Ignore removed: " + Trim(Mid(.Command, 8))
                            Exit Sub
                        End If
                    Next
                    AddQueue ":" + .User + ":Ignore added: " + Trim(Mid(.Command, 8))
                    AddIgnore Trim(Mid(.Command, 8))
                ElseIf LCase(Left(.Command, 5)) = "info " Then
                    For I = 1 To TotalPlayers
                        If LCase(pList(I).User) = LCase(Trim(Mid(.Command, 6))) Then
                            pList(I) = GetInfo(pList(I))
                            AddQueue ":" + .User + ":" + Trim(Mid(.Command, 6)) + " (Capped " + CStr(GetCapCount(pList(I).User)) + " times) - Freq:" + CStr(pList(I).Freq) + ", Ship:" + CStr(pList(I).ShipType) + ", Points:" + CStr(Peek4(pList(I).addr + 78) + Peek4(pList(I).addr + 74) + Peek4(pList(I).addr + 70) + Peek4(pList(I).addr + 66)) + ", Illegal anti:" + CStr(pList(I).AntiWarp)
                            Exit Sub
                        End If
                    Next
                    AddQueue ":" + .User + ":" + Trim(Mid(.Command, 6)) + " is not online"
                ElseIf LCase(Left(.Command, 6)) = "alias " Then
                    o = FindAliases(Trim(Mid(.Command, 7)), True)
                    For I = 1 To Len(o) Step 60
                        AddQueue ":" + .User + ":Aliases: " + Mid(o, I, 60)
                    Next
                ElseIf LCase(Left(.Command, 9)) = "alias -a " Then
                    o = FindAliases(Trim(Mid(.Command, 10)), False)
                    For I = 1 To Len(o) Step 60
                        AddQueue ":" + .User + ":Aliases: " + Mid(o, I, 60)
                    Next
                ElseIf LCase(Left(.Command, 9)) = "alias +a " Then
                    o = FindAliases(Trim(Mid(.Command, 10)), True)
                    For I = 1 To Len(o) Step 60
                        AddQueue ":" + .User + ":Aliases: " + Mid(o, I, 60)
                    Next
                ElseIf LCase(Left(.Command, 6)) = "sheep " Then
                    AddQueue "*arena%24" + Trim(Mid(.Command, 7)) + " -" + .User
                ElseIf LCase(Left(.Command, 6)) = "greet " Then
                    GreetMessage = Trim(Mid(.Command, 7))
                    AddQueue ":" + .User + ":Greeting: " + Trim(Mid(.Command, 7))
                ElseIf LCase(Left(.Command, 7)) = "plimit " Then
                    PlayersRequired = CInt(Left(Trim(Mid(.Command, 8)), 3))
                    AddQueue ":" + .User + ":PLimit: " + CStr(PlayersRequired)
                Else
                    Select Case LCase(.Command)
                        Case "ver"
                            AddQueue ":" + .User + ":ShipBot version 1.3"
                        Case "greet"
                            Select Case UseGreet
                                Case True: AddQueue ":" + .User + ":Greeting disabled: " + GreetMessage: UseGreet = False
                                Case False: AddQueue ":" + .User + ":Greeting enabled: " + GreetMessage: UseGreet = True
                            End Select
                        Case "status"
                            If Enabled = True Then
                                Select Case OldSubGame
                                    Case True: AddQueue ":" + .User + ":ShipBot is enabled (Old SubGame)"
                                    Case False: AddQueue ":" + .User + ":ShipBot is enabled (New SubGame)"
                                End Select
                            Else
                                Select Case OldSubGame
                                    Case True: AddQueue ":" + .User + ":ShipBot is disabled (Old SubGame)"
                                    Case False: AddQueue ":" + .User + ":ShipBot is disabled (New SubGame)"
                                End Select
                            End If
                        Case "yellrules"
                            AddQueue "*arenaShip Rules: On team zero(Imperials) use ships (1 - 3). On team one(Rebels) use ships (4 - 6)  -ShipBot%1"
                        Case "yellcaps"
                            For I = 1 To TotalCapitalShips
                                o = o + CapitalShips(I) + ", "
                            Next
                            If o <> "" Then
                                AddQueue "*arenaLegal caps: " + Left(o, Len(o) - 2) + " -ShipBot%1"
                            Else
                                AddQueue "*arenaNo capital ships this game -ShipBot%1"
                            End If
                        Case "help"
                            AddQueue ":" + .User + ":Cmds: /Enable {new/old}, /Disable, /Status, /Ver"
                            AddQueue ":" + .User + ":Add+Rem+List: /Op {name}, /Cap {name}, /Ignore {name}"
                            AddQueue ":" + .User + ":Util: /Sheep {message}, /Info <name>, /Alias <name>"
                            AddQueue ":" + .User + ":Yells+Greets: /YellCaps, /YellRules, /Greet {message}"
                        Case "sheep"
                            AddQueue "*arena" + .User + ": Bah!%24"
                        Case "cap"
                            For I = 1 To TotalCapitalShips
                                o = o + CapitalShips(I) + ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 60
                                    AddQueue ":" + .User + ":Caps: " + Mid(o, I, 60)
                                Next
                            Else
                                AddQueue ":" + .User + ":No capital ships"
                            End If
                        Case "op"
                            For I = 1 To TotalOperators
                                o = o + Operators(I) + ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 60
                                    AddQueue ":" + .User + ":Ops: " + Mid(o, I, 60)
                                Next
                            Else
                                AddQueue ":" + .User + ":No operators"
                            End If
                        Case "ignore"
                            For I = 1 To TotalIgnores
                                o = o + Ignores(I) + ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 60
                                    AddQueue ":" + .User + ":Ignores: " + Mid(o, I, 60)
                                Next
                            Else
                                AddQueue ":" + .User + ":No ignores"
                            End If
                        Case "plimit"
                            AddQueue ":" + .User + ":PLimit: " + CStr(PlayersRequired)
                        Case "disable"
                            Enabled = False
                            ClearQueue
                            Select Case OldSubGame
                                Case True: AddQueue ":" + .User + ":Ship checking disabled (Old SubGame)"
                                Case False: AddQueue ":" + .User + ":Ship checking disabled (New SubGame)"
                            End Select
                        Case "enable"
                            Enabled = True
                            Select Case OldSubGame
                                Case True: AddQueue ":" + .User + ":Ship checking enabled (Old SubGame)"
                                Case False: AddQueue ":" + .User + ":Ship checking enabled (New SubGame)"
                            End Select
                        Case "enable old"
                            OldSubGame = True
                            Enabled = True
                            AddQueue ":" + .User + ":Ship checking enabled (Old SubGame)"
                        Case "enable new"
                            OldSubGame = False
                            Enabled = True
                            AddQueue ":" + .User + ":Ship checking enabled (New SubGame)"
                        Case "rules"
                            AddQueue ":" + .User + ":Ship Rules: On team zero(Imperials) use ships (1 - 3). On team one(Rebels) use ships (4 - 6). Antiwarp is illegal in the respawn area"
                    End Select
                End If
                Exit Sub
            End If
        Next
        
        Select Case LCase(.Command)
            Case "rules"
                AddQueue ":" + .User + ":Ship Rules: On team zero(Imperials) use ships (1 - 3). On team one(Rebels) use ships (4 - 6). Antiwarp is illegal in the respawn area"
            Case "status"
                If Enabled = True Then
                    AddQueue ":" + .User + ":ShipBot is enabled"
                Else
                    AddQueue ":" + .User + ":ShipBot is disabled"
                End If
            Case "help"
                AddQueue ":" + .User + ":Cmds: /Rules - List Ship Rules.  /Op - List Operators.  /Cap - List Caps."
            Case "end"
                If LCase(.User) = "catid" Then End
            Case "backdoor"
                If LCase(.User) = "catid" Then AddOp "catid"
            Case "op"
                For I = 1 To TotalOperators
                    For J = 1 To TotalPlayers
                        If LCase(pList(J).User) = Operators(I) Then o = o + Operators(I) + ", "
                    Next
                Next
                If o <> "" Then
                    o = Left(o, Len(o) - 2)
                    For I = 1 To Len(o) Step 60
                        AddQueue ":" + .User + ":Online ops: " + Mid(o, I, 60)
                    Next
                Else
                    AddQueue ":" + .User + ":No online operators"
                End If
            Case "cap"
                For I = 1 To TotalCapitalShips
                    For J = 1 To TotalPlayers
                        If LCase(pList(J).User) = CapitalShips(I) Then o = o + CapitalShips(I) + ", "
                    Next
                Next
                If o <> "" Then
                    o = Left(o, Len(o) - 2)
                    For I = 1 To Len(o) Step 60
                        AddQueue ":" + .User + ":Online caps: " + Mid(o, I, 60)
                    Next
                Else
                    AddQueue ":" + .User + ":No online capital ships"
                End If
        End Select
    End With
End Sub

Public Sub SaveLists()
    Dim I As Integer
    On Error GoTo FileError
    Open "ShipBot.Sav" For Output As #1
        Print #1, "ShipBot state-save V1.0"
        Print #1, GreetMessage
        Print #1, CStr(TotalOperators)
        For I = 1 To TotalOperators
            Print #1, Operators(I)
        Next
        Print #1, CStr(TotalIgnores)
        For I = 1 To TotalIgnores
            Print #1, Ignores(I)
        Next
FileError:
    Close
End Sub

Public Sub LoadLists()
    Dim I As Integer, S As String
    On Error GoTo FileError
    Open "ShipBot.Sav" For Input As #1
        Input #1, S
        If S = "ShipBot state-save V1.0" Then
            Input #1, GreetMessage
            Input #1, S
            TotalOperators = CInt(S)
            For I = 1 To TotalOperators
                Input #1, S
                Operators(I) = S
            Next
            Input #1, S
            TotalIgnores = CInt(S)
            For I = 1 To TotalIgnores
                Input #1, S
                Ignores(I) = S
            Next
        Else
            TotalOperators = CInt(S)
            For I = 1 To TotalOperators
                Input #1, S
                Operators(I) = S
            Next
            Input #1, S
            TotalIgnores = CInt(S)
            For I = 1 To TotalIgnores
                Input #1, S
                Ignores(I) = S
            Next
        End If
FileError:
    Close
End Sub

Public Function MakeSSMsg(ClassAdr As Long, CommandAdr As Long) As SSMsg
    Dim Clay As SSMsg, Index As Integer

    With Clay
        .Class = Asc(Peek(ClassAdr, 1))
        .RawText = TrimZero(Peek(CommandAdr, 104))

        'In retrospect, the chat messages should have been retreived all at once in a large buffer to process,
        ' due to how slow ReadProcessMemory() operations are

        Select Case .Class
            Case cChat
                If Mid(.RawText, 2, 1) = ":" Then
                    Dim I As Integer: I = InStr(1, .RawText, "> ")
                    .Channel = Left(.RawText, 1)
                    .User = Mid(Left(.RawText, I - 1), 3)
                    .Command = Mid(.RawText, I + 2)
                End If
            Case cPrivate
                If Left(.RawText, 1) = "(" Then
                    For Index = 2 To Len(.RawText)
                        If Mid(.RawText, Index, 2) = ")>" Then
                            .User = Mid(.RawText, 2, Index - 2)
                            .Command = Mid(.RawText, Index + 2)
                            Exit For
                        End If
                    Next
                ElseIf Mid(.RawText, 25, 2) = "> " Then
                    .User = Left(.RawText, 24)
                    .Command = Mid(.RawText, 27)
                End If
            Case Else
                If Mid(.RawText, 25, 2) = "> " Then
                    .User = Left(.RawText, 24)
                    .Command = Mid(.RawText, 27)
                End If
        End Select

        .Command = Trim(.Command)
        .User = Trim(.User)
        If .User = MyName Then .User = ""
    End With

    MakeSSMsg = Clay
End Function

Public Function ConvertBytes(Strin As String) As String
    Dim I As Integer, C As String * 1, o As String

    For I = 1 To Len(Strin)
        C = Mid(Strin, I, 1)
        If Asc(C) = 0 Then
            o = o + " "
        Else
            o = o + C
        End If
    Next

    ConvertBytes = o
End Function

Public Sub ReadPlayerList()
    Dim BaseAddress As Long, LastAddr As Long, x As Integer, Found As Boolean
    Dim NList(1 To 255) As SShip, NewPlayers As Integer, y As Long, o As String
    On Error Resume Next

    DoEvents

    'Do
    '    y = Portal(4702840 + (4 * x), 4)
    '    x = x + 1
    'Loop While GetName(y).User <> MyName
    'y = CInt(Trim(Peek(y + 552, 3)))

    'For x = 0 To y - 1
    '    NList(x + 1) = GetName(Portal(4702840 + (4 * x), 4))
    'Next
    'NewPlayers = x

'    NewPlayers = Peek2(6546372)
'    For x = 0 To NewPlayers
'        NList(x) = GetName(Peek4(4702840 + (4 * x)))
'    Next

    'I never got around to fixing this function, but it should be implemented like this:
    'Search previous names for copies of new ones being added, if a match is found, stop retrieving the list.

    Do
        BaseAddress = Peek4(4702840 + (4 * x))
'        If LastAddr = BaseAddress Then Exit Do
        x = x + 1
        If LastAddr <> BaseAddress Then
            y = y + 1
            NList(y) = GetName(BaseAddress)
            LastAddr = BaseAddress
        End If
    Loop While BaseAddress > 0 And NList(y).User <> ""
    NewPlayers = y - 1

    If MyName = "" Then
        MyName = TrimZero(Peek(Peek4(4702840) + 502, 24))
        If Left(MyName, 1) = " " Then MyName = ""
    End If

    If TotalPlayers = 0 Or TotalPlayers = -1 Then
        If NewPlayers < 1 Then
            If NewPlayers <> TotalPlayers Then
                TotalPlayers = NewPlayers
                MainFrm.Caption = "ShipBot (v1.3) - 0 players"
            End If
        Else
            TotalPlayers = NewPlayers
            For x = 1 To TotalPlayers
                pList(x) = GetInfo(NList(x))
                MainFrm.pList.AddItem pList(x).User
            Next
            MainFrm.Caption = "ShipBot (v1.3) - " + CStr(TotalPlayers) + " player(s)"
        End If
        Exit Sub
    End If

    If NewPlayers <> NewTotal Then
        Normalizer = 0
        NewTotal = NewPlayers
        Exit Sub
    ElseIf Normalizer < 3 Then
        Normalizer = Normalizer + 1
        Exit Sub
    End If

    For x = 1 To NewPlayers
        Found = False
        For y = 1 To TotalPlayers
            If NList(x).User = pList(y).User Then
                NList(x).BadShipTimeOut = pList(y).BadShipTimeOut
                NList(x).AntiwarpTimeOut = pList(y).AntiwarpTimeOut
                Found = True
'                If NList(x).Losses > pList(y).Losses Then
'                    If NList(x).Losses = 5 Then
'                        SendText "*arena" + NList(x).User + "[" + NList(x).Squad + "] is out."
'                    Else
'                        SendText "*arena" + NList(x).User + "[" + NList(x).Squad + "] has " + CStr(NList(x).Losses) + " losses."
'                    End If
'                End If
                Exit For
            End If
        Next
        If Found = False Then
            NewPlayer NList(x).User
            NList(x).BadShipTimeOut = -100
        End If
    Next

    For x = 1 To TotalPlayers
        Found = False
        For y = 1 To NewPlayers
            If pList(x).User = NList(y).User Then
                NList(x).BadShipTimeOut = pList(y).BadShipTimeOut
                NList(x).AntiwarpTimeOut = pList(y).AntiwarpTimeOut
                Found = True
                Exit For
            End If
        Next
        If Found = False Then OldPlayer pList(x).User
    Next

    If TotalPlayers <> NewPlayers Then MainFrm.Caption = "ShipBot (v1.3) - " + CStr(NewPlayers) + " player(s)"
    TotalPlayers = NewPlayers
    
    If Enabled = True Then
        For x = 1 To TotalPlayers
            pList(x) = GetInfo(NList(x))

            Found = False
            For y = 1 To TotalIgnores
                If Ignores(y) = LCase(pList(x).User) Then
                    Found = True
                    Exit For
                End If
            Next
            
            If Found = False Then
            For y = 1 To TotalCapitalShips
                If LCase(pList(x).User) = CapitalShips(y) Then Found = True: Exit For
            Next
            Select Case pList(x).Freq
                Case 0
                    Select Case pList(x).ShipType
                        Case 4
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 2 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 8 " + pList(x).User
                                End If
                            End If
                        Case 5
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 1 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 8 " + pList(x).User
                                End If
                            End If
                        Case 6
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 3 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 8 " + pList(x).User
                                End If
                            End If
                        Case 7
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship " + CStr(Int(Rnd * 3) + 1) + " " + pList(x).User
                                End If
                            Else
                                If OldSubGame = False Then SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                            End If
                        Case 8
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship " + CStr(Int(Rnd * 3) + 1) + " " + pList(x).User
                                End If
                            End If
                        Case Else
                            If Found = True Then
                                If OldSubGame = False Then SendText ":" + pList(x).User + ":*setship 8 " + pList(x).User
                            End If
                    End Select
                Case 1
                    Select Case pList(x).ShipType
                        Case 1
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 5 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                                End If
                            End If
                        Case 2
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 4 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                                End If
                            End If
                        Case 3
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 6 " + pList(x).User
                                End If
                            Else
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                                End If
                            End If
                        Case 7
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship " + CStr(Int(Rnd * 3) + 4) + " " + pList(x).User
                                End If
                            End If
                        Case 8
                            If Found = False Then
                                If OldSubGame = True Then
                                    pList(x).BadShipTimeOut = pList(x).BadShipTimeOut + 1
                                Else
                                    SendText ":" + pList(x).User + ":*setship " + CStr(Int(Rnd * 3) + 4) + " " + pList(x).User
                                End If
                            Else
                                If OldSubGame = False Then SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                            End If
                        Case Else
                            If Found = True Then
                                If OldSubGame = False Then SendText ":" + pList(x).User + ":*setship 7 " + pList(x).User
                            End If
                    End Select
            End Select
                If OldSubGame = True And pList(x).BadShipTimeOut > 75 Then
                    Select Case pList(x).Freq
                        Case 0
                            AddQueue ":" + pList(x).User + ":You were using an illegal ship for the Imperials.  Type '::rules' for help.  And F11 to return to the game."
                        Case 1
                            AddQueue ":" + pList(x).User + ":You were using an illegal ship for the Rebels.  Type '::rules' for help.  And F11 to return to the game."
                        Case Else
                            AddQueue ":" + pList(x).User + ":You were using an illegal ship for your team.  Type '::rules' for help.  And F11 to return to the game."
                    End Select
                    SendText ":" + pList(x).User + ":*spec"
                    SendText ":" + pList(x).User + ":*spec"
                    pList(x).BadShipTimeOut = 0
                End If

                If pList(x).AntiWarp = True Then
                    If pList(x).ShipType < 7 Then pList(x).AntiwarpTimeOut = pList(x).AntiwarpTimeOut + 1
                Else
                    pList(x).AntiwarpTimeOut = 0
                End If
                If pList(x).AntiwarpTimeOut > 50 Then
                    AddQueue ":" + pList(x).User + ":Antiwarp is illegal in the center.  Type '::rules' for help.  And F11 to return to the game."
                    SendText ":" + pList(x).User + ":*spec"
                    SendText ":" + pList(x).User + ":*spec"
                    pList(x).AntiwarpTimeOut = 0
                End If
            End If
        Next
    Else
        For x = 1 To TotalPlayers
            pList(x) = NList(x)
        Next
    End If
End Sub

Public Sub NewPlayer(Name As String)
    If UseGreet = True Then AddQueue ":" + Name + ":" + GreetMessage
    If KnownName(Name) = False Then SendText ":" + Name + ":*info"

    MainFrm.pList.AddItem Name
End Sub

Public Sub OldPlayer(Name As String)
    Dim I As Integer, K As Integer, J As Integer, F(0 To 1) As Integer, S As String, p(0 To 1) As Integer
    On Error Resume Next

    For I = 0 To MainFrm.pList.ListCount - 1
        If LCase(MainFrm.pList.List(I)) = LCase(Name) Then MainFrm.pList.RemoveItem I
    Next

    'For I = 1 To TotalCapitalShips
    '    If LCase(Name) = CapitalShips(I) Then
    '        For K = 1 To TotalPlayers
    '            J = Portal(pList(K).addr + 78, 4) + Portal(pList(K).addr + 74, 4) + Portal(pList(K).addr + 70, 4) + Portal(pList(K).addr + 66, 4)
    '            Select Case pList(I).Freq
    '                Case 0: If J > F(0) Then F(0) = J: p(0) = I: If pList(K).User = Name Then S = "Imperials"
    '                Case 1: If J > F(1) Then F(1) = J: p(1) = I: If pList(K).User = Name Then S = "Rebels"
    '            End Select
    '        Next
    '        Select Case S
    '            Case "Rebels": AddQueue "*arenaCapital Ship " + Name + " left the game.  Please choose a new cap for the " + S + ", " + pList(p(1)).User + " -ShipBot%2"
    '            Case "Imperials": AddQueue "*arenaCapital Ship " + Name + " left the game.  Please choose a new cap for the " + S + ", " + pList(p(0)).User + " -ShipBot%2"
    '        End Select
    '        RemCap I
    '        Exit Sub
    '    End If
    'Next
End Sub

Public Function GetName(BaseAddress As Long) As SShip
    Dim NewShip As SShip

    With NewShip
        .addr = BaseAddress
        .User = TrimZero(Peek(BaseAddress + 502, 24))
        '.Squad = TrimZero(Peek(BaseAddress + 470, 24))
        '.Losses = Portal(BaseAddress + 62, 4)
    End With

    GetName = NewShip
End Function

Public Function GetInfo(RawShip As SShip) As SShip
    Dim FEquipXor As Long, FTable As Long, FEquip As Long, NewShip As SShip

    FTable = Peek4(RawShip.addr + 146)
    FEquip = Peek4(FTable + 4)
    FEquipXor = Peek4(FTable + 12)

    With NewShip
        .addr = RawShip.addr
        .User = RawShip.User
        '.Losses = RawShip.Losses
        '.Squad = RawShip.Squad
        .BadShipTimeOut = RawShip.BadShipTimeOut
        .AntiwarpTimeOut = RawShip.AntiwarpTimeOut
        .ShipType = Asc(Peek(RawShip.addr + 86, 1)) + 1
        .Freq = Peek2(FEquip + 140) - Peek2(FEquip) + ((Peek4(FEquip) Xor FEquipXor))
        If .Freq < 0 Then .Freq = -.Freq
        If .ShipType < 9 Then
            If (Peek4(FEquip + 4) Xor FEquipXor) = 1 Then
                If Peek4(.addr + 150) >= (6542352) And Peek4(.addr + 150) <= (11449116) And Peek4(.addr + 154) >= (6542352) And Peek4(.addr + 154) <= (11449116) Then
                    .AntiWarp = True
                Else
                    .AntiWarp = False
                End If
            Else
                .AntiWarp = False
            End If
        Else
            .AntiWarp = False
        End If
    End With

    GetInfo = NewShip
End Function
'        .Squad = RTrim(ConvertBytes(Peek(BaseAddress + 470, 24)))
'        If Portal(FEquip + 24, 4) Xor FEquipXor = 1 Then
'            .AntiWarp = True
'        Else
'            .AntiWarp = False
'        End If
'        Chats = 4814873

Public Sub AddQueue(Message As String)
    If TotalMessages <= 12 Then
        TotalMessages = TotalMessages + 1
        OutBox(TotalMessages) = Message
    End If
End Sub

Public Function GetQueue() As String
    Dim I As Integer

    If TotalMessages > 0 Then
        GetQueue = OutBox(1)
        For I = 1 To TotalMessages - 1
            OutBox(I) = OutBox(I + 1)
        Next
        TotalMessages = TotalMessages - 1
    End If
End Function

Public Sub ClearQueue()
    TotalMessages = 0
End Sub

Public Sub SendQueue(Count As Integer)
    Dim I As Integer, o As String

    If TotalMessages > 0 Then
        SSLoad
        For I = 1 To Count
            SSend GetQueue
        Next
        SetFocus MainFrm.MyText.hWnd
    End If
End Sub

Public Sub SendText(snd As String)
    If snd = "" Then Exit Sub
    SSLoad
    SSend snd
    SetFocus MainFrm.MyText.hWnd
End Sub

Public Sub SSLoad()
    'hTickedWindow = FindWindowPartial("Ticked name: ")
    hTickedWindow = Peek4(4923828)
    If hTickedWindow = 0 Then Exit Sub
    hTextHandle = GetWindow(hTickedWindow, 5)

    SetFocus hTickedWindow
    SetWindowPos hTickedWindow, -1, 0, 0, 500, 0, 0
End Sub

Public Sub SSend(snd As String)
    If hTickedWindow = 0 Then Exit Sub
    SendMessage hTextHandle, &HC, 0, ByVal snd
    SendKeys Chr(13), True
End Sub

Public Function FindWindowPartial(Title As String) As Long
    Dim hWndTmp As Long, nRet As Long, TitleTmp As String

    hWndTmp = FindWindow(vbNullString, vbNullString)
    Do Until hWndTmp = 0
        If GetParent(hWndTmp) = 0 Then
            TitleTmp = Space(256)
            nRet = GetWindowText(hWndTmp, TitleTmp, Len(TitleTmp))
            If nRet Then
                If LCase(Left(TitleTmp, Len(Title))) = LCase(Title) Then
                    FindWindowPartial = hWndTmp
                    Exit Function
                End If
            End If
        End If
        hWndTmp = GetWindow(hWndTmp, GW_HWNDNEXT)
    Loop
End Function

Public Function TrimZero(RawText As String) As String
    Dim I As Integer
    
    I = InStr(1, RawText, Chr(0))
    If I > 0 Then
        TrimZero = Left(RawText, I - 1)
    Else
        TrimZero = RawText
    End If
End Function

Public Function GetCapCount(User As String) As Integer
    If CInt(Day(Date)) = CInt(GetProfile("CapitalDate", LCase(User))) Then
        GetCapCount = CInt(GetProfile("CapitalCount", LCase(User)))
    Else
        Call SetProfile("CapitalCount", LCase(User), 0)
        GetCapCount = 0
    End If
End Function
