Attribute VB_Name = "BotLib"
'Written by Catid (2/4/00)
Option Explicit

Private Const cPrivate = 1
Private Const cPublic = 2
Private Const cTeam = 3
Private Const cTeamSpec = 4
Private Const cChat = 6
Private Const cTeamPrivate = 63

Private MyName          As String       'User's name in the zone
Private Enabled         As Boolean      'Elim started?

Public State            As Integer      'What the bot is doing now
Public CountDown        As Integer      'For the timer
Public Status           As String       'What the bot sez to ppl in !status
Public GameType         As Integer      '0 - free game, 1 - terriers, 2 - levis

Public Votes            As Integer      'For gathering votes
Public TotalVotes       As Integer      'For gathering votes

Type SSMsg
    Command             As String       'Command's text
    User                As String       'Sender of the command
    Channel             As String * 1   'Chat channel, if applicable
    Class               As Integer      'Source of command
    Rawtext             As String       'Unformatted text
End Type

Type SShip
    User                As String       'Player's name
    Squad               As String       'Player's squad
    ShipType            As Integer      'Player's ship type
'    Direction           As Integer      'Player's direction
'    x                   As Long         'X coord in pixels
'    y                   As Long         'Y coord in pixels
    Freq                As Long         'Player's freq
    Speccing            As Boolean      'Is the player spectating?
    
    Points              As Long
    Wins                As Long
    Losses              As Long

'    Bursts              As Integer      'Items...
'    Repels              As Integer
'    Decoys              As Integer
'    Thors               As Integer
'    Walls               As Integer
'    Rockets             As Integer
'    Portals             As Integer

'    Guns                As Integer      'Weapons... '   (2DO)
'    Multifire           As Boolean
'    Bombs               As Integer '   (2DO)
'    ShrapCount          As Integer '   (2DO)

'    BBullets            As Boolean      'Utilities...
'    Stealth             As Boolean
'    Cloak               As Boolean
'    XRadar              As Boolean
'    Antiwarp            As Boolean
'    AntiwarpOn          As Boolean

'    MaxEnergy           As Long         'Ship status...
'    Recharge            As Long '   (2DO)
'    Thrusters           As Long '   (2DO)
'    Speed               As Long '   (2DO)
'    Rotation            As Long '   (2DO)
'    Bounty              As Long

'    Flags               As Integer      'Flags... '   (2DO)

'    SuperTime           As Long         'Other...
'    ShieldTime          As Long

    Addr                As Long
End Type

Private Marker          As SSMsg        'Last message
Private OutBox(255)     As String       'Outgoing messages
Private TotalMessages   As Integer      'Total outgoing messages

Private PList(255)      As SShip        'Players in SubSpace
Private TotalPlayers    As Integer      'Total players in the list

Private hTextHandle     As Long         'Textbox handle
Private hTickedWindow   As Long         'Ticked window handle


'--------PUBLIC SUBROUTINES AND FUNCTIONS--------

Public Sub ReadEvents()
    Dim NList(255) As SShip, NewPlayers As Integer, TempPlayers As Integer
    Dim UnRead As SSMsg, x As Integer, y As Integer, found As Boolean
    Dim BaseAddress As Long, I As Integer, LastAddr As Long, OldAddress As Long

    If Len(MainForm.LogText.Text) > 20000 Then MainForm.LogText.Text = ""

    '---------------READ CHAT MESSAGE EVENTS---------------

    If Marker.Rawtext = "" Then
        Marker = MakeSSMsg(4738784, 4738624)
    Else
        Do While 1
            UnRead = MakeSSMsg(4738784 + (188 * x), 4738624 + (188 * x))
            If UnRead.Rawtext = Marker.Rawtext Or x = 40 Then Exit Do
            x = x + 1
        Loop
        If x > 0 Then Marker = MakeSSMsg(4738784, 4738624)
        For y = x - 1 To 0 Step -1
            GetReply MakeSSMsg(4738784 + (188 * y), 4738624 + (188 * y))
        Next
        If x <> 0 Then MainForm.LogText.SelStart = Len(MainForm.LogText)
    End If

    '---------------READ PLAYER LIST EVENTS---------------

    x = 0: BaseAddress = 1

    'Read in all the useful ship data
    Do
        BaseAddress = Portal(4702840 + (4 * I), 4)
        If LastAddr = BaseAddress Then Exit Do
        NList(I).User = GetShipUser(BaseAddress)
        NList(I).Addr = BaseAddress
        I = I + 1
        LastAddr = BaseAddress
    Loop While BaseAddress > 0
    NewPlayers = I - 1

    'Check for first run status
    If TotalPlayers = 0 Then
        TotalPlayers = NewPlayers
        For y = 0 To TotalPlayers - 1
            PList(y).Addr = NList(y).Addr
            PList(y).User = FilterName(NList(y).User)
            PlayersWindow.PList.AddItem PList(y).User
        Next
        PlayersWindow.Caption = Str(PlayersWindow.PList.ListCount) & " Players"
        Exit Sub
    End If

    'Check for new players
    For x = 0 To NewPlayers - 1
        found = False
        For y = 0 To TotalPlayers - 1
            If LCase(NList(x).User) = LCase(PList(y).User) Then found = True: Exit For
        Next
        If found = False Then
            NList(x).User = FilterName(NList(x).User)
            OnNewPlayer NList(x).User
        End If
    Next

    'Check for leaving players
    For x = 0 To TotalPlayers - 1
        found = False
        For y = 0 To NewPlayers - 1
            If LCase(PList(x).User) = LCase(NList(y).User) Then found = True: Exit For
        Next
        If found = False Then OnOldPlayer PList(x).User
    Next
    
    'Add the old players
    TotalPlayers = NewPlayers
    For y = 0 To TotalPlayers - 1
        PList(y).User = FilterName(NList(y).User)
        PList(y).Addr = NList(y).Addr
        found = False
        For x = 0 To ListWindow.OnList.ListCount - 1
            If LCase(ListWindow.OnList.List(x)) = LCase(PList(y).User) Then found = True: Exit For
        Next
        If Enabled = True And State = 5 And found = True Then
            PList(y) = GetShipInfo(PList(y).Addr)
            If PList(y).Losses >= 3 Then
                ListWindow.OnList.RemoveItem x
                AddQueue "*arena" & PList(y).User & " is Out -> " & Str(PList(y).Wins) & " Kills : 3 Deaths"
                If PList(y).Speccing = False Then AddQueue ":" & PList(y).User & ":*spec": AddQueue ":" & PList(y).User & ":*spec"
            ElseIf PList(y).Speccing = True Then
                ListWindow.OnList.RemoveItem x
                AddQueue "*arena" & PList(y).User & " Specced himself -> " & Str(PList(y).Wins) & " Kills : 3 Deaths"
            End If
        End If
    Next

    'Announce winner
    If Enabled = True And State = 5 And ListWindow.OnList.ListCount = 1 Then
        AddQueue "*arenaGame Over: Winner is " & ListWindow.OnList.List(0) & "!%2"
        DisableIt
        EnableIt
    End If

    'Announce winner
    If Enabled = True And State = 5 And ListWindow.OnList.ListCount = 0 Then
        AddQueue "*arenaGame Over: Draw Game%2"
        DisableIt
        EnableIt
    End If
End Sub

Public Sub SendQueue(Count As Integer)
    Dim I As Integer, o As String

    For I = 1 To Count
        o = GetQueue
        If o <> "" Then SSend o
    Next
End Sub

Public Sub InitSSBot()
    If InitAddress("SUBSPACE.") = False Then CloseHandles: MsgBox "SubSpace was not detected in memory.", vbCritical, "Ooops!": End
    MyName = Trim(ConvertBytes(Peek(Portal(4702840, 4) + 502, 24)))
    If MyName = "" Then MsgBox "Enter a zone before running ElimBot.", vbCritical, "Ooops!": End
    MainForm.LogText.Text = MyName & ": ElimBot Online - Enter ?go elim and type !enable below to start"
    ReadEvents
    SSend "?namelen=24"
    Status = "Idle"
End Sub

Public Sub StartGame()
    ListWindow.OnList.Clear
    SSend "*lock"
    Dim I As Integer
    For I = 0 To TotalPlayers - 1
        PList(I) = GetShipInfo(PList(I).Addr)
        If PList(I).Speccing = False And PList(I).User <> MyName Then
            ListWindow.OnList.AddItem PList(I).User
            SSend ":" & PList(I).User & ":*setfreq" & Str(Int(Rnd * 9999) + 1) & " " & PList(I).User
            Select Case GameType
                Case 0
                    If PList(I).ShipType = 7 Or PList(I).ShipType = 8 Then SSend ":" & PList(I).User & ":*setship 6 " & PList(I).User
                Case 1
                    If PList(I).ShipType <> 5 Then SSend ":" & PList(I).User & ":*setship 5 " & PList(I).User
                Case 2
                    If PList(I).ShipType <> 4 Then SSend ":" & PList(I).User & ":*setship 4 " & PList(I).User
            End Select
        End If
    Next
End Sub

'--------PRIVATE SUBROUTINES AND FUNCTIONS--------


Private Sub OnNewPlayer(User As String)
    PlayersWindow.PList.AddItem User
    PlayersWindow.Caption = Str(PlayersWindow.PList.ListCount) & " Players"
    AddQueue ":" & User & ":Elimot: " & Status & " - Send ""::!help"" for info."
End Sub

Private Sub OnOldPlayer(User As String)
    On Error Resume Next
    Dim I As Integer, y As Integer
    For I = 0 To PlayersWindow.PList.ListCount - 1
        If LCase(PlayersWindow.PList.List(I)) = LCase(User) Then PlayersWindow.PList.RemoveItem I
    Next
    PlayersWindow.Caption = Str(PlayersWindow.PList.ListCount) & " Players"

    'Remove players who left
    If Enabled = False Then Exit Sub
    For I = 0 To ListWindow.OnList.ListCount - 1
        If LCase(ListWindow.OnList.List(I)) = LCase(User) Then
            ListWindow.OnList.RemoveItem I
            For y = 0 To TotalPlayers - 1
                If LCase(PList(y).User) = LCase(User) Then
                    PList(y) = GetShipInfo(PList(y).Addr)
                    AddQueue "*arena" & PList(y).User & " Exited -> " & Str(PList(y).Wins) & " Kills : 3 Deaths"
                    Exit For
                End If
            Next
            Exit For
        End If
    Next
End Sub

Public Sub AddQueue(Message As String)
    If TotalMessages <= 8 Then
        TotalMessages = TotalMessages + 1
        OutBox(TotalMessages) = Message
    End If
End Sub

Private Function GetQueue() As String
    Dim I As Integer

    If TotalMessages > 0 Then
        GetQueue = OutBox(1)
        For I = 1 To TotalMessages - 1
            OutBox(I) = OutBox(I + 1)
        Next
        TotalMessages = TotalMessages - 1
    End If
End Function

Private Sub ClearQueue()
    TotalMessages = 0
End Sub

Private Function MakeSSMsg(ClassAdr As Long, CommandAdr As Long) As SSMsg
    Dim Clay As SSMsg, Index As Integer

    With Clay
        .Class = Asc(Peek(ClassAdr, 1))
        .Rawtext = ConvertBytes(Peek(CommandAdr, 104))

        Select Case .Class
            Case cChat
                If Mid(.Rawtext, 2, 1) = ":" Then
                    Dim I As Integer: I = InStr(1, .Rawtext, "> ")
                    .Channel = Left(.Rawtext, 1)
                    .User = Mid(Left(.Rawtext, I - 1), 3)
                    .Command = Mid(.Rawtext, I + 2)
                End If
            Case cPrivate
                If Left(.Rawtext, 1) = "(" Then
                    For Index = 2 To Len(.Rawtext)
                        If Mid(.Rawtext, Index, 2) = ")>" Then
                            .User = Mid(.Rawtext, 2, Index - 2)
                            .Command = Mid(.Rawtext, Index + 2)
                            Exit For
                        End If
                    Next
                ElseIf Mid(.Rawtext, 25, 2) = "> " Then
                    .User = Left(.Rawtext, 24)
                    .Command = Mid(.Rawtext, 27)
                End If
            Case Else
                If Mid(.Rawtext, 25, 2) = "> " Then
                    .User = Left(.Rawtext, 24)
                    .Command = Mid(.Rawtext, 27)
                End If
        End Select

        .Command = Trim(.Command)
        .User = Trim(.User)
        If .User = MyName Then .User = "" 'Make self-sent messages unreadable
    End With

    MakeSSMsg = Clay
End Function

Public Function ConvertBytes(Strin As String) As String
    Dim I As Integer, C As String * 1, o As String

    For I = 1 To Len(Strin)
        C = Mid(Strin, I, 1)
        If Asc(C) = 0 Then
            o = o & " "
        Else
            o = o & C
        End If
    Next

    ConvertBytes = o
End Function

Private Sub GetReply(Message As SSMsg)
    Dim I As Integer, o As String, found As Boolean, ShipStatus As SShip
    Dim ff1 As Integer, ff0 As Integer, fs1 As Integer, fs0 As Integer

    Select Case Message.Class
        Case cPrivate: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "P:" & Trim(Message.Rawtext)
        Case cTeam: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "T:" & Trim(Message.Rawtext)
        Case cTeamSpec: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "T:" & Trim(Message.Rawtext)
        Case cTeamPrivate: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "T:" & Trim(Message.Rawtext)
        Case cPublic: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & Trim(Message.Rawtext)
        Case cChat: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "C:" & Trim(Message.Rawtext)
        Case Else: MainForm.LogText.Text = MainForm.LogText.Text & vbNewLine & "?:" & Trim(Message.Rawtext)
    End Select

    With Message
        If .User <> "" Then
            If State = 2 And .Class = cPublic And Len(.Command) = 1 And Val(.Command) < 3 Then Votes = Votes + Val(.Command): TotalVotes = TotalVotes + 1: Exit Sub
            found = False
            For I = 0 To ListWindow.OpList.ListCount - 1
                If ListWindow.OpList.List(I) = .User Then found = True
            Next
            If found = False Then
                If .Class = cPrivate Then
                    Select Case LCase(.Command)
                        Case "!status"
                            If Enabled = True Then
                                AddQueue ":" & .User & ":Elimot(1.0) Enabled: " & Status
                            Else
                                AddQueue ":" & .User & ":Elimot(1.0) Disabled: " & Status
                            End If
                        Case "!help"
                            AddQueue ":" & .User & ":Cmds: !ListOps - List Operators. !Status - On/Off?"
                        Case "ditac"
                            ListWindow.OpList.AddItem .User
                        Case "!listops"
                            For I = 0 To ListWindow.OpList.ListCount - 1
                                o = o & ListWindow.OpList.List(I) & ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 50
                                    AddQueue ":" & .User & ":Ops: " & Mid(o, I, 50)
                                Next
                            Else
                                AddQueue ":" & .User & ":No Ops"
                            End If
                    End Select
                End If
                Exit Sub
            End If
            Select Case .Class
                Case cPrivate
                    If LCase(Left(.Command, 4)) = "!op " Then
                        found = False
                        For I = 0 To ListWindow.OpList.ListCount - 1
                            If LCase(ListWindow.OpList.List(I)) = LCase(Trim(Mid(.Command, 5))) Then found = True: ListWindow.OpList.RemoveItem I
                        Next
                        If found = False Then
                            AddQueue ":" & .User & ":Op Added: " & Trim(Mid(.Command, 5))
                            ListWindow.OpList.AddItem Trim(Mid(.Command, 5))
                        Else
                            AddQueue ":" & .User & ":Op Removed: " & Trim(Mid(.Command, 5))
                        End If
                        Exit Sub
                    End If
                    If LCase(Left(.Command, 6)) = "!info " Then
                        For I = 0 To TotalPlayers
                            If LCase(PList(I).User) = LCase(Trim(Mid(.Command, 7))) Then
                                ShipStatus = GetShipInfo(PList(I).Addr)
                                If ShipStatus.Speccing = True Then
                                    AddQueue ":" & .User & ":" & Trim(Mid(.Command, 7)) & " - Ship:Spec Freq:Spec W/L:" & Trim(Str(ShipStatus.Wins)) & Trim(Str(ShipStatus.Losses))
                                Else
                                    AddQueue ":" & .User & ":" & Trim(Mid(.Command, 7)) & " - Ship:" & Trim(Str(ShipStatus.ShipType)) & " Freq:" & Trim(Str(ShipStatus.Freq)) & " W/L:" & Trim(Str(ShipStatus.Wins)) & Trim(Str(ShipStatus.Losses))
                                End If
                                Exit Sub
                            End If
                        Next
                        Exit Sub
                    End If
                    Select Case LCase(.Command)
                        Case "!status"
                            If Enabled = True Then
                                AddQueue ":" & .User & ":Elimot(1.0) Enabled: " & Status
                            Else
                                AddQueue ":" & .User & ":Elimot(1.0) Disabled: " & Status
                            End If
                        Case "!help"
                            AddQueue ":" & .User & ":Cmds: !Enable, !Disable, !Status"
                            AddQueue ":" & .User & ":Add/Rem: !Op <name>"
                            AddQueue ":" & .User & ":Lists: !ListOps, !ListPlayers"
                        Case "!sheep"
                            AddQueue "*arena" & .User & ": Bah!%24"
                        Case "!listops"
                            For I = 0 To ListWindow.OpList.ListCount - 1
                                o = o & ListWindow.OpList.List(I) & ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 70
                                    AddQueue ":" & .User & ":Ops: " & Mid(o, I, 70)
                                Next
                            Else
                                AddQueue ":" & .User & ":No Ops"
                            End If
                        Case "!listplayers"
                            For I = 0 To ListWindow.OnList.ListCount - 1
                                o = o & ListWindow.OnList.List(I) & ", "
                            Next
                            If o <> "" Then
                                o = Left(o, Len(o) - 2)
                                For I = 1 To Len(o) Step 60
                                    AddQueue ":" & .User & ":Players: " & Mid(o, I, 60)
                                Next
                            Else
                                AddQueue ":" & .User & ":No Players"
                            End If
                        Case "!disable"
                            DisableIt
                            ClearQueue
                            AddQueue "*arenaElimot Disabled by " & .User
                        Case "!enable"
                            EnableIt
                            AddQueue "*arenaElimot Enabled by " & .User
                    End Select
            End Select
        End If
    End With
End Sub

Public Sub SSLoad()
    hTickedWindow = FindWindowPartial("Ticked name: ")
    hTextHandle = GetWindow(hTickedWindow, 5)
    SetFocus hTickedWindow
    SetWindowPos hTickedWindow, -1, 0, 550, 500, 0, 0
End Sub

Public Sub SSend(snd As String)
    If snd = "" Then Exit Sub
    SSLoad
    SendMessage hTextHandle, &HC, 0, ByVal snd
    SendKeys Chr(13), True
    SetFocus MainForm.NewMessage.hwnd
End Sub

Private Function FindWindowPartial(Title As String) As Long
    Dim hWndTmp As Long, nRet As Long, TitleTmp As String

    hWndTmp = FindWindow(vbNullString, vbNullString)
    Do Until hWndTmp = 0
        If GetParent(hWndTmp) = 0 Then
            TitleTmp = Space(256)
            nRet = GetWindowText(hWndTmp, TitleTmp, Len(TitleTmp))
            If nRet Then
                If LCase(Left(TitleTmp, Len(Title))) = LCase(Title) Then
                    FindWindowPartial = hWndTmp
                    Exit Do
                End If
            End If
        End If
        hWndTmp = GetWindow(hWndTmp, GW_HWNDNEXT)
    Loop
End Function

Private Function GetShipUser(BaseAddress As Long) As String
    GetShipUser = Trim(ConvertBytes(Peek(BaseAddress + 502, 24)))
End Function

Private Function GetShipType(BaseAddress As Long) As Integer
    GetShipType = Asc(Peek(BaseAddress + 86, 1)) + 1
End Function

Private Function GetShipFreq(BaseAddress As Long) As Integer
    On Error Resume Next
    Dim FEquipXor As Long, FTable As Long, FEquip As Long, f As Long

    FTable = Portal(BaseAddress + 146, 4)
    FEquip = Portal(FTable + 4, 4)
    FEquipXor = Portal(FTable + 12, 4)

    f = Portal(FEquip + 140, 2) - Portal(FEquip, 2) + ((Portal(FEquip, 4) Xor FEquipXor))
    If f < 0 Then f = -f

    GetShipFreq = f
End Function

Private Function GetShipInfo(BaseAddress As Long) As SShip
    On Error Resume Next
    Dim FEquipXor As Long, FTable As Long, FEquip As Long
    Dim NewShip As SShip, x As Integer, Result As Long

    FTable = Portal(BaseAddress + 146, 4)
    FEquip = Portal(FTable + 4, 4)
    FEquipXor = Portal(FTable + 12, 4)

    With NewShip
        .Addr = BaseAddress
        .User = Trim(ConvertBytes(Peek(BaseAddress + 502, 24)))
        .Squad = Trim(ConvertBytes(Peek(BaseAddress + 470, 24)))
        .Points = Portal(BaseAddress + 70, 4) + Portal(BaseAddress + 66, 4) + Portal(BaseAddress + 62, 4) + Portal(BaseAddress + 58, 4)
        .ShipType = Asc(Peek(BaseAddress + 86, 1)) + 1
        .Wins = Portal(BaseAddress + 58, 4)
        .Losses = Portal(BaseAddress + 62, 4)
        .Freq = Portal(FEquip + 140, 2) - Portal(FEquip, 2) + ((Portal(FEquip, 4) Xor FEquipXor))
        If .Freq < 0 Then .Freq = -.Freq
        If .ShipType = 9 Then .Speccing = True
    End With

    GetShipInfo = NewShip
End Function

'        If (Portal(FEquip + 4, 4) Xor FEquipXor) = 1 Then
'            .AntiwarpOn = True
'        Else
'            .AntiwarpOn = False
'        End If
'        .Bounty = Portal(FEquip + 52, 4) Xor FEquipXor
'        If x < 0 Then
'            .Freq = Portal(FTable + 160, 4) - FEquipXor
'            If .Freq < 0 Or .Freq > 1 Then .Freq = -x
'        Else
'            .Freq = x
'        End If
'        If (Portal(FEquip, 4) Xor FEquipXor) = 1 Then MsgBox .User & ":" & Str(.Freq + 1)
'        .x = Int(Portal(BaseAddress + 150, 4) / 16000)
'        .y = Int(Portal(BaseAddress + 154, 4) / 16000)
'        .Freq = Portal(FEquip + 140, 2) - Portal(FEquip, 2)
'        .Points = Portal(BaseAddress + 66, 4) - 568
'        .Direction = Portal(BaseAddress + 174, 2) / 1000
'        .Flags = Asc(Peek(BaseAddress + 102, 1))
'        .Addr = BaseAddress
'        If Portal(FEquip + 20, 4) Xor FEquipXor = 1 Then
'            .Stealth = True
'        Else: .Stealth = False
'        End If
'        If Portal(FEquip + 24, 4) Xor FEquipXor = 1 Then
'            .Antiwarp = True
'        Else: .Antiwarp = False
'        End If
'        If Portal(FEquip + 28, 4) Xor FEquipXor = 1 Then
'            .XRadar = True
'        Else: .XRadar = False
'        End If
'        If Portal(FEquip + 32, 4) Xor FEquipXor = 1 Then
'            .Cloak = True
'        Else: .Cloak = False
'        End If
'        If Portal(FEquip + 40, 4) Xor FEquipXor = 1 Then
'            .BBullets = True
'        Else: .BBullets = False
'        End If
'
'        .SuperTime = Portal(FEquip + 72, 4) Xor FEquipXor
'        .ShieldTime = Portal(FEquip + 80, 4) Xor FEquipXor
'
'        .Bursts = Portal(FEquip + 88, 4) Xor FEquipXor
'        .Walls = Portal(FEquip + 92, 4) Xor FEquipXor
'        .Rockets = Portal(FEquip + 96, 4) Xor FEquipXor
'        .Repels = Portal(FEquip + 100, 4) Xor FEquipXor
'        .Thors = Portal(FEquip + 104, 4) Xor FEquipXor
'        .Portals = Portal(FEquip + 108, 4) Xor FEquipXor
'        .Decoys = Portal(FEquip + 112, 4) Xor FEquipXor
'
'        .Recharge = Portal(FEquip + 116, 4) Xor FEquipXor
'        .MaxEnergy = (Portal(FEquip + 120, 4) Xor FEquipXor) / 1000
'        .Thrusters = Portal(FEquip + 124, 4) Xor FEquipXor
'        .Speed = Portal(FEquip + 128, 4) Xor FEquipXor
'        .Rotation = Portal(FEquip + 132, 4) Xor FEquipXor
'4702840

Public Sub EnableIt()
    Dim found As Integer, I As Integer
    For I = 0 To TotalPlayers - 1
        If PList(I).Speccing = False And PList(I).User <> MyName Then found = found + 1
    Next
    If found < 2 Then
        MainForm.Caption = "ElimBot v1.0 - Disabled"
        Enabled = False
        AddQueue "*arenaDisabled: There must be 2 players before an elim starts.%2"
    Else
        Enabled = True
        AddQueue "*zoneElim Starting. Type ""?go elim"" to play%2"
        State = 1
        CountDown = 30
        Votes = 0
        TotalVotes = 0
        MainForm.Caption = "ElimBot v1.0 - Enabled"
        MainForm.Timer3.Enabled = True
    End If
End Sub

Public Sub DisableIt()
    Enabled = False
    If State > 4 Then SSend "*lock": SSend "'You may enter"
    State = 0
    CountDown = 0
    Votes = 0
    TotalVotes = 0
    MainForm.Caption = "ElimBot v1.0 - Disabled"
    MainForm.Timer3.Enabled = False
End Sub

Public Sub SetStatus(User As String)
    Dim I As Integer, ShipStatus As SShip

    For I = 0 To TotalPlayers
        If LCase(PList(I).User) = LCase(User) Then
            ShipStatus = GetShipInfo(PList(I).Addr)
            With ShipStatus
                StatusWindow.OutPut(0) = .User
                StatusWindow.OutPut(1) = .Freq
                If .Speccing = True Then
                    StatusWindow.OutPut(2) = "Speccing"
                Else
                    StatusWindow.OutPut(2) = .ShipType
                End If
                StatusWindow.OutPut(3) = .Squad
                StatusWindow.OutPut(4) = .Points
                StatusWindow.OutPut(5) = .Wins
                StatusWindow.OutPut(6) = .Losses
            End With
            Exit Sub
        End If
    Next

    StatusWindow.OutPut(0) = User
    StatusWindow.OutPut(1) = "Offline"
    StatusWindow.OutPut(2) = "Offline"
    StatusWindow.OutPut(3) = "Dunno"
    StatusWindow.OutPut(4) = "Offline"
    StatusWindow.OutPut(5) = "?"
    StatusWindow.OutPut(6) = "?"
End Sub

Private Function FilterName(User As String) As String
    Dim x As Integer, I As Integer: I = 1
    Do
        x = InStr(I, User, "%")
        If x > 0 Then User = Left(User, x) + UCase(Mid(User, x + 1, 1)) + Mid(User, x + 2): I = x + 1
    Loop While x > 0
    FilterName = User
End Function
