Attribute VB_Name = "AliasFinder"
Option Explicit

Public Type AliasInfo
    User                    As String
    MachineID               As Long
    IP                      As String
    Dat                     As String
    Other                   As String
End Type

Public Alias(1 To 15000)    As AliasInfo
Public TotalAliases         As Integer

Public CurrentName          As String
Public CurrentID            As Long
Public CurrentDat           As String
Public CurrentIP            As String

Public Sub OpenPLog()
    Dim S As String
    On Error GoTo ErrHandler

        Open "PlayerData.txt" For Input As #1
    Do While Not EOF(1)
        TotalAliases = TotalAliases + 1
        Line Input #1, S
            Alias(TotalAliases).User = Left(S, InStr(1, S, vbTab) - 1)
        S = Mid(S, InStr(1, S, vbTab) + 1)
            Alias(TotalAliases).IP = Left(S, InStr(1, S, vbTab) - 1)
        S = Mid(S, InStr(1, S, vbTab) + 1)
            Alias(TotalAliases).Dat = Left(S, InStr(1, S, vbTab) - 1)
        S = Mid(S, InStr(1, S, vbTab) + 1)
            Alias(TotalAliases).MachineID = CLng(Left(S, InStr(1, S, vbTab) - 1))
        S = Mid(S, InStr(1, S, vbTab) + 1)
            Alias(TotalAliases).Other = S
    Loop

ErrHandler:
    Close
End Sub

Public Sub ClosePLog()
    Dim I As Integer
    
    If TotalAliases <= 0 Then Exit Sub
    Open "PlayerData.txt" For Output As #2
        For I = 1 To TotalAliases
            Print #2, Alias(I).User + vbTab + Alias(I).IP + vbTab + Alias(I).Dat + vbTab + CStr(Alias(I).MachineID) + vbTab + Alias(I).Other
        Next
    Close
End Sub

Public Sub AddAlias(User As String, IP As String, MachineID As Long, Dat As String)
    Dim S As String, I As Integer, J As Integer

    TotalAliases = TotalAliases + 1
    Alias(TotalAliases).User = User
    Alias(TotalAliases).IP = IP
    Alias(TotalAliases).Dat = Dat
    Alias(TotalAliases).MachineID = MachineID

    S = HostByAddress(IP)
    For I = Len(S) To 1 Step -1
        If Mid(S, I, 1) = "." Then J = J + 1
        If J = 2 Then Exit For
    Next

    If J = 2 Then
        Alias(TotalAliases).Other = S + vbTab + Mid(S, I + 1)
    Else
        Alias(TotalAliases).Other = S + vbTab + "Error"
    End If
End Sub

Public Function KnownName(User As String) As Boolean
    Dim I As Integer

    KnownName = False
    For I = 1 To TotalAliases
        If LCase(Alias(I).User) = LCase(User) Then KnownName = True
    Next
End Function

Public Function FindAliases(User As String, UseIP As Boolean) As String
    Dim IP As String, MachineID As Long, Ignore As Integer
    Dim I As Long, o As String, cIP As String * 3, tIP As String * 4, rIP As String * 3

    For I = 1 To TotalAliases
        If LCase(Alias(I).User) = LCase(User) Then
            IP = Alias(I).IP
            MachineID = Alias(I).MachineID
            Ignore = I
            Exit For
        End If
    Next
    
    If MachineID = 0 Then
        FindAliases = "Unknown User"
        Exit Function
    End If

    tIP = Space(4)
    CopyMemory ByVal tIP, inet_addr(IP), 4: cIP = Left(tIP, 3)
    For I = 1 To TotalAliases
        If I <> Ignore Then
            If Alias(I).MachineID = MachineID Then o = o + Alias(I).User + "(ID match), "
            CopyMemory ByVal tIP, inet_addr(Alias(I).IP), 4: rIP = Left(tIP, 3)
            If UseIP = True And cIP = rIP Then o = o + Alias(I).User + "(~IP match), "
        End If
    Next
    If o <> "" Then
        o = Left(o, Len(o) - 2)
    Else
        o = "No Matches"
    End If
    
    FindAliases = o
End Function

Public Function CollectID(RawData As String) As Long
    Dim I As Integer, L As Integer
    
    L = InStr(1, RawData, "MachineId:")
    
    If L > 0 Then
        I = InStr(L, RawData, "  DeathsLeft:")
        If I > 0 Then
            CollectID = CLng(Mid(RawData, L + 10, I - L - 10))
        Else
            CollectID = CLng(Mid(RawData, L + 10))
        End If
    Else
        CollectID = 0
    End If
End Function

Public Function CollectDat(RawData As String) As String
    Dim I As Integer, L As Integer
    
    L = InStr(1, RawData, "Created: ")
    
    If L > 0 Then
        I = InStr(L, RawData, "  Bytes/Sec:")
        If I > 0 Then
            CollectDat = Mid(RawData, L + 9, I - L - 9)
            CollectDat = Left(CollectDat, InStr(1, CollectDat, " ") - 1)
        Else
            CollectDat = Mid(RawData, L + 9)
            CollectDat = Left(CollectDat, InStr(1, CollectDat, " ") - 1)
        End If
    Else
        CollectDat = ""
    End If
End Function

Public Function CollectIP(RawData As String) As String
    Dim I As Integer, L As Integer

    L = InStr(1, RawData, "IP:")

    If L > 0 Then
        I = InStr(L, RawData, "  TimeZoneBias:")
        If I > 0 Then
            CollectIP = Mid(RawData, L + 3, I - L - 3)
        Else
            CollectIP = Mid(RawData, L + 3)
        End If
    Else
        CollectIP = ""
    End If
End Function

Public Function CollectName(RawData As String) As String
    Dim I As Integer, L As Integer

    L = InStr(1, RawData, "TypedName:")

    If L > 0 Then
        I = InStr(L, RawData, "  Demo:")
        If I > 0 Then
            CollectName = Mid(RawData, L + 10, I - L - 10)
        Else
            CollectName = Mid(RawData, L + 10)
        End If
    Else
        CollectName = ""
    End If
End Function

Public Sub Collect(RawText As String)
    Dim S As String, I As Integer

    If CurrentName = "" Then CurrentName = CollectName(RawText)
    If CurrentID = 0 Then CurrentID = CollectID(RawText)
    If CurrentDat = "" Then CurrentDat = CollectDat(RawText)
    If CurrentIP = "" Then CurrentIP = CollectIP(RawText)

    If CurrentName <> "" And CurrentID <> 0 And CurrentIP <> "" And CurrentDat <> "" Then
        AddAlias CurrentName, CurrentIP, CurrentID, CurrentDat
        CurrentName = ""
        CurrentIP = ""
        CurrentDat = ""
        CurrentID = 0
    End If
End Sub
