VERSION 5.00
Begin VB.UserControl Screen 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   2220
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   5865
   LockControls    =   -1  'True
   ScaleHeight     =   2220
   ScaleWidth      =   5865
   Begin VB.VScrollBar VScroll1 
      Enabled         =   0   'False
      Height          =   2055
      Left            =   5595
      TabIndex        =   0
      Top             =   30
      Width           =   210
   End
   Begin VB.PictureBox Pic1 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1815
      Left            =   0
      ScaleHeight     =   121
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   307
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   0
      Width           =   4605
   End
End
Attribute VB_Name = "Screen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Events
Event Change()
Event Click()
Event DblClick()
Event KeyDown(KeyCode As Integer, Shift As Integer)
Event KeyPress(KeyAscii As Integer)
Event KeyUp(KeyCode As Integer, Shift As Integer)
Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Event Scroll()

'Properties
Private pNumLines As Integer        'Number of visible lines on screen
Private pPixBetweenLines As Integer 'Number of pixels between lines
Private pNumItems As Long           'Number of items in TItem() array
Private pSelectedItem As Long       'Number of selected item in TItem() array
Private pBackColor As Long          'BackColor of screen
Private pForeColor As Long          'ForeColor of screen
Private pSelBackColor As Long       'BackColor of selected item
Private pSelForeColor As Long       'ForeColor of selected item
Private pLockDisplay As Boolean     'Indicates if the screen display is locked or not
Private pFontName As String         'Font properties
Private pFontSize As Integer        '  ''
Private pFontBold As Boolean        '  ''
Private pFontItalic As Boolean      '  ''
Private pFontUnderline As Boolean   '  ''
Private pFontStrikethru As Boolean  '  ''
Private pFontTransparent As Boolean '  ''

Private TItem() As String           'Array with the items to be displayed (1 to pNumItems)
Private StartItem As Long           'Item to be displayed on first line of screen
Private SwForceDisplay As Boolean   'Wether display might be forced when LockDisplay = true

Property Get NumLines() As Integer
    NumLines = pNumLines
End Property
Property Let NumLines(iNumLines As Integer)
    pNumLines = iNumLines: PropertyChanged ("NumLines")
    VScroll1.LargeChange = pNumLines - 1
    UserControl_Resize
    Refresh
End Property

Property Get PixBetweenLines() As Integer
    PixBetweenLines = pPixBetweenLines
End Property
Property Let PixBetweenLines(iPixBetweenLines As Integer)
    If iPixBetweenLines < 0 Then Error 5
    pPixBetweenLines = iPixBetweenLines: PropertyChanged ("PixBetweenLines")
    UserControl_Resize
    Refresh
End Property

Property Get NumItems() As Long
    NumItems = pNumItems
End Property

Property Get SelectedItem() As Long
    SelectedItem = pSelectedItem
End Property
Property Let SelectedItem(lSelectedItem As Long)
    If lSelectedItem < 1 Or lSelectedItem > pNumItems Then Error 5
    VScroll1.Value = lSelectedItem - 1
End Property

Property Get LockDisplay() As Boolean
    LockDisplay = pLockDisplay
End Property
Property Let LockDisplay(bLockDisplay As Boolean)
    If pLockDisplay = True And bLockDisplay = False Then
        pLockDisplay = bLockDisplay: PropertyChanged ("LockDisplay")
        DrawScreen
    Else
        pLockDisplay = bLockDisplay: PropertyChanged ("LockDisplay")
    End If
End Property

Property Get ForeColor() As Long
    ForeColor = pForeColor
End Property
Property Let ForeColor(lForeColor As Long)
    pForeColor = lForeColor: PropertyChanged ("ForeColor")
End Property

Property Get BackColor() As Long
    BackColor = pBackColor
End Property
Property Let BackColor(lBackColor As Long)
    pBackColor = lBackColor: PropertyChanged ("BackColor")
    Pic1.BackColor = lBackColor
End Property

Property Get SelForeColor() As Long
    SelForeColor = pSelForeColor
End Property
Property Let SelForeColor(lSelForeColor As Long)
    pSelForeColor = lSelForeColor: PropertyChanged ("SelForeColor")
End Property

Property Get SelBackColor() As Long
    SelBackColor = pSelBackColor
End Property
Property Let SelBackColor(lSelBackColor As Long)
    pSelBackColor = lSelBackColor: PropertyChanged ("SelBackColor")
End Property

Property Get FontName() As String
    FontName = pFontName
End Property
Property Let FontName(sFontName As String)
    pFontName = sFontName: PropertyChanged ("FontName")
    Pic1.FontName = pFontName
    Refresh
End Property

Property Get FontSize() As Integer
    FontSize = pFontSize
End Property
Property Let FontSize(iFontSize As Integer)
    pFontSize = iFontSize: PropertyChanged ("FontSize")
    Pic1.FontSize = pFontSize
    UserControl_Resize
    Refresh
End Property

Property Get FontBold() As Boolean
    FontBold = pFontBold
End Property
Property Let FontBold(bFontBold As Boolean)
    pFontBold = bFontBold: PropertyChanged ("FontBold")
    Pic1.FontBold = pFontBold
    Refresh
End Property

Property Get FontItalic() As Boolean
    FontItalic = pFontItalic
End Property
Property Let FontItalic(bFontItalic As Boolean)
    pFontItalic = bFontItalic: PropertyChanged ("FontItalic")
    Pic1.FontItalic = pFontItalic
    Refresh
End Property

Property Get FontUnderline() As Boolean
    FontUnderline = pFontUnderline
End Property
Property Let FontUnderline(bFontUnderline As Boolean)
    pFontUnderline = bFontUnderline: PropertyChanged ("FontUnderline")
    Pic1.FontUnderline = pFontUnderline
    Refresh
End Property

Property Get FontStrikethru() As Boolean
    FontStrikethru = pFontStrikethru
End Property
Property Let FontStrikethru(bFontStrikethru As Boolean)
    pFontStrikethru = bFontStrikethru: PropertyChanged ("FontStrikethru")
    Pic1.FontStrikethru = pFontStrikethru
    Refresh
End Property

Property Get FontTransparent() As Boolean
    FontTransparent = pFontTransparent
End Property
Property Let FontTransparent(bFontTransparent As Boolean)
    pFontTransparent = bFontTransparent: PropertyChanged ("FontTransparent")
    Pic1.FontTransparent = pFontTransparent
    Refresh
End Property

Private Sub UserControl_InitProperties()
    On Error Resume Next
    pNumLines = 3: PropertyChanged ("NumLines")
    pPixBetweenLines = 4: PropertyChanged ("PixBetweenLines")
    pFontName = "Courier New": PropertyChanged ("FontName")
    pFontSize = 10: PropertyChanged ("FontSize")
    pFontBold = False: PropertyChanged ("FontBold")
    pFontItalic = False: PropertyChanged ("FontItalic")
    pFontUnderline = False: PropertyChanged ("FontUnderline")
    pFontStrikethru = False: PropertyChanged ("FontStrikethru")
    pFontTransparent = True: PropertyChanged ("FontTransparent")
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    On Error Resume Next
    pNumLines = PropBag.ReadProperty("NumLines")
    pPixBetweenLines = PropBag.ReadProperty("PixBetweenLines")
    pBackColor = PropBag.ReadProperty("BackColor")
    pForeColor = PropBag.ReadProperty("ForeColor")
    pBackColor = PropBag.ReadProperty("SelBackColor")
    pForeColor = PropBag.ReadProperty("SelForeColor")
    pLockDisplay = PropBag.ReadProperty("LockDisplay")
    pFontName = PropBag.ReadProperty("FontName")
    pFontSize = PropBag.ReadProperty("FontSize")
    pFontBold = PropBag.ReadProperty("FontBold")
    pFontItalic = PropBag.ReadProperty("FontItalic")
    pFontUnderline = PropBag.ReadProperty("FontUnderline")
    pFontStrikethru = PropBag.ReadProperty("FontStrikethru")
    pFontTransparent = PropBag.ReadProperty("FontTransparent")
    '
    Pic1.FontName = pFontName
    Pic1.FontSize = pFontSize
    Pic1.FontBold = pFontBold
    Pic1.FontItalic = pFontItalic
    Pic1.FontUnderline = pFontUnderline
    Pic1.FontStrikethru = pFontStrikethru
    Pic1.FontTransparent = pFontTransparent
    '
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    On Error Resume Next
    PropBag.WriteProperty "NumLines", pNumLines
    PropBag.WriteProperty "PixBetweenLines", pPixBetweenLines
    PropBag.WriteProperty "BackColor", pBackColor
    PropBag.WriteProperty "ForeColor", pForeColor
    PropBag.WriteProperty "SelBackColor", pSelBackColor
    PropBag.WriteProperty "SelForeColor", pSelForeColor
    PropBag.WriteProperty "LockDisplay", pLockDisplay
    PropBag.WriteProperty "FontName", pFontName
    PropBag.WriteProperty "FontSize", pFontSize
    PropBag.WriteProperty "FontBold", pFontBold
    PropBag.WriteProperty "FontItalic", pFontItalic
    PropBag.WriteProperty "FontUnderline", pFontUnderline
    PropBag.WriteProperty "FontStrikethru", pFontStrikethru
    PropBag.WriteProperty "FontTransparent", pFontTransparent
End Sub

Private Sub UserControl_Resize()
    UserControl.Height = (7 * Screen.TwipsPerPixelY) + (pNumLines * (Pic1.FontSize + pPixBetweenLines) * Screen.TwipsPerPixelY)
    '
    VScroll1.Move (UserControl.Width - VScroll1.Width) - (4 * Screen.TwipsPerPixelX), _
                  0 * Screen.TwipsPerPixelY, _
                  VScroll1.Width, _
                  UserControl.Height - (4 * Screen.TwipsPerPixelY)
    '
    Pic1.Height = UserControl.Height '+ (1 * 1)
    Pic1.Width = (UserControl.Width - VScroll1.Width) - (5 * Screen.TwipsPerPixelX)
End Sub

Private Sub Pic1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim Line1 As Long
    Dim pSel2 As Long
    If Button = vbLeftButton And pNumItems > 0 Then
        Line1 = Int((Y - 1) / (Pic1.FontSize + pPixBetweenLines))
        pSel2 = StartItem + Line1
        If pSel2 > pNumItems Then
            pSel2 = pNumItems
        End If
        If pSel2 > 0 Then
            VScroll1.Value = pSel2 - 1
        End If
    End If
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub

Private Sub Pic1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim Line1 As Long
    Dim pSel2 As Long
    '
    If Button = vbLeftButton And pNumItems > 0 Then
        If Y < 0 Then
            If VScroll1.Value > 0 Then
                VScroll1.Value = VScroll1.Value - 1
            End If
        ElseIf Y > Pic1.Height Then
            If VScroll1.Value < VScroll1.Max Then
                VScroll1.Value = VScroll1.Value + 1
            End If
        Else
            Line1 = Int((Y - 1) / (Pic1.FontSize + pPixBetweenLines))
            pSel2 = StartItem + Line1
            If pSel2 > pNumItems Then
                pSel2 = pNumItems
            ElseIf pSel2 < 1 Then
                pSel2 = 1
            End If
            VScroll1.Value = pSel2 - 1
        End If
    End If
    '
    RaiseEvent MouseMove(Button, Shift, X, Y)
End Sub

Private Sub Pic1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If VScroll1.Enabled = True Then VScroll1.SetFocus
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub

Private Sub Pic1_Click()
    RaiseEvent Click
End Sub

Private Sub Pic1_DblClick()
    RaiseEvent DblClick
End Sub

Private Sub Pic1_KeyDown(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub Pic1_KeyPress(KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub Pic1_KeyUp(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Private Sub VScroll1_KeyDown(KeyCode As Integer, Shift As Integer)
    Pic1_KeyDown KeyCode, Shift
End Sub

Private Sub VScroll1_KeyPress(KeyAscii As Integer)
    Pic1_KeyPress KeyAscii
End Sub

Private Sub VScroll1_KeyUp(KeyCode As Integer, Shift As Integer)
    Pic1_KeyUp KeyCode, Shift
End Sub

Private Sub VScroll1_Scroll()
    RaiseEvent Scroll
End Sub

Private Sub VScroll1_Change()
    Dim Limit As Long
    Dim NewSelectedItem As Long
    '
    NewSelectedItem = VScroll1.Value + 1
    '
    If StartItem = 0 Then StartItem = 1
    If pSelectedItem = 0 Then pSelectedItem = 1
    '
    If NewSelectedItem = pSelectedItem Then Exit Sub
    '
    If NewSelectedItem < pSelectedItem Then  'Scroll Up
        If NewSelectedItem < StartItem Then
            StartItem = NewSelectedItem
        End If
    Else                                     'Scroll Down
        Limit = StartItem + pNumLines - 1: If Limit > pNumItems Then Limit = pNumItems
        If NewSelectedItem > Limit Then
            StartItem = NewSelectedItem - (pNumLines - 1)
        End If
    End If
    '
    pSelectedItem = NewSelectedItem
    '
    DrawScreen
    '
    RaiseEvent Change
End Sub

Private Sub DrawScreen()
    Dim Limit As Long
    Dim Line1 As Long
    Dim n As Long
    '
    If SwForceDisplay = True Then
        SwForceDisplay = False
    Else
        If pLockDisplay = True Then Exit Sub
    End If
    '
    Pic1.Cls
    '
    If pNumItems > 0 Then
        VScroll1.Max = pNumItems - 1
        VScroll1.LargeChange = pNumLines - 1
        VScroll1.Enabled = True
    Else
        VScroll1.Max = 32767
        VScroll1.LargeChange = 1
        VScroll1.Value = 0
        VScroll1.Enabled = False
        Exit Sub
    End If
    '
    If StartItem = 0 Then StartItem = 1
    If pSelectedItem = 0 Then pSelectedItem = 1
    '
    Limit = StartItem + pNumLines - 1
    If Limit > pNumItems Then Limit = pNumItems
    If Limit < 0 Then Limit = 0
    Line1 = 0
    For n = StartItem To Limit
        If n = pSelectedItem Then
            Pic1.Line (0, (Pic1.FontSize + pPixBetweenLines) * Line1)- _
                      (Pic1.Width, (Pic1.FontSize + pPixBetweenLines) * (Line1 + 1) + 2), _
                      pSelBackColor, BF
            Pic1.ForeColor = pSelForeColor
        Else
            Pic1.ForeColor = pForeColor
        End If
        '
        '
        Pic1.CurrentX = 0
        Pic1.CurrentY = (Pic1.FontSize + pPixBetweenLines) * Line1
        Pic1.Print TItem(n)
        Line1 = Line1 + 1
    Next
End Sub

'----------------- METHODS ---------------------------------------------------------------------
Public Sub AddItem(sItem As String)
    pNumItems = pNumItems + 1
    ReDim Preserve TItem(1 To pNumItems) As String
    '
    TItem(pNumItems) = sItem
    '
    DrawScreen
End Sub

Public Sub RemoveItem(NumItem As Long)
    Dim n As Long
    '
    If NumItem > pNumItems Or NumItem < 1 Then Error 5
    '
    For n = NumItem To pNumItems - 1
        TItem(n) = TItem(n + 1)
    Next
    '
    pNumItems = pNumItems - 1
    ReDim Preserve TItem(1 To pNumItems) As String
    '
    If pSelectedItem > pNumItems Then pSelectedItem = pNumItems
    '
    DrawScreen
End Sub

Public Sub SetItem(ByVal NumItem As Long, ByVal sItem As String)
    If NumItem < 1 Or NumItem > pNumItems Then Error 5
    '
    TItem(NumItem) = sItem
    '
    DrawScreen
End Sub

Public Function Item(NumItem As Long) As String
    If NumItem < 1 Or NumItem > pNumItems Then Error 5
    '
    Item = TItem(NumItem)
End Function

Public Sub Clear()
    pNumItems = 0
    StartItem = 0
    pSelectedItem = 0
    ReDim TItem(1 To 1) As String
    DrawScreen
End Sub

Public Sub Refresh()
    SwForceDisplay = True
    DrawScreen
End Sub

