Attribute VB_Name = "SysTray"
Option Explicit

Private Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean
Private Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function SetTimer Lib "user32" (ByVal hWnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Private Declare Function KillTimer Lib "user32" (ByVal hWnd As Long, ByVal nIDEvent As Long) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cX As Long, ByVal cY As Long, ByVal wFlags As Long) As Long

Private Type NOTIFYICONDATA
    cbSize As Long
    hWnd As Long
    uId As Long
    uFlags As Long
    ucallbackMessage As Long
    hIcon As Long
    szTip As String * 64
End Type

Private Const WS_POPUP = &H80000000
Private Const NIM_ADD = &H0
Private Const NIM_MODIFY = &H1
Private Const NIM_DELETE = &H2
Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4
Private Const GWL_WNDPROC = -4
Private Const WM_TIMER = &H113
Private Const WM_MOUSEMOVE = &H200
Private Const WM_LBUTTONUP = &H202
Private Const WM_LBUTTONDOWN = &H201
Private Const WM_LBUTTONDBLCLK = &H203

Private OldWndProc      As Long
Private MyHWnd          As Long
Private t               As NOTIFYICONDATA
Private SelPicture      As Long

Private Const SWP_NOSIZE = &H1
Private Const SWP_NOMOVE = &H2
Private Const SWP_SHOWWINDOW = &H40
Private Const SWP_DRAWFRAME = &H20
Private Const HWND_TOP = 0

Public Sub SysTrayTrigger()
    Call UnloadTrayIcon
    Call SetWindowPos(MainFrm.hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE + SWP_NOMOVE + SWP_SHOWWINDOW + SWP_DRAWFRAME)
End Sub

Public Sub LoadTrayIcon(SelectedPicture As Long)
    MyHWnd = CreateWindowEx(0, "#32770", "SSBilling_SysTray", 0&, 0, 0, 1, 1, 0&, 0&, App.hInstance, 0&)
    OldWndProc = SetWindowLong(MyHWnd, GWL_WNDPROC, AddressOf SysTrayEvent)
    
    t.cbSize = Len(t)
    t.hWnd = MyHWnd
    t.uId = 1&
    t.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
    t.ucallbackMessage = 5150
    t.hIcon = SelectedPicture
    t.szTip = "SSBilling_SysTray_Icon" & Chr(0)
    SelPicture = SelectedPicture
    Shell_NotifyIcon NIM_ADD, t

    SetTimer MyHWnd, 123, 1000, AddressOf SysTrayEvent
End Sub

Public Sub UnloadTrayIcon()
    KillTimer MyHWnd, 123

    t.cbSize = Len(t)
    t.hWnd = MyHWnd
    t.uId = 1&
    Shell_NotifyIcon NIM_DELETE, t
    
    SetWindowLong MyHWnd, GWL_WNDPROC, OldWndProc
    DestroyWindow MyHWnd
End Sub

Private Function SysTrayEvent(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Select Case uMsg
        Case WM_TIMER
            t.cbSize = Len(t)
            t.hWnd = MyHWnd
            t.uId = 1&
            t.uFlags = NIF_ICON
            t.hIcon = SelPicture
            Shell_NotifyIcon NIM_MODIFY, t
        Case 5150
            If LOWORD(lParam) <> 512 Then SysTrayTrigger
        Case Else
            SysTrayEvent = CallWindowProc(OldWndProc, hWnd, uMsg, wParam, ByVal lParam)
    End Select
End Function
