Attribute VB_Name = "StartUp"
Option Explicit

Public Type INI_stuff
    Port                As Long         'Implemented
    AllowNewUsers       As Long         'Implemented
    AskNewUsers         As Long         'Implemented
    
    MaxQueueForLogin    As Long         'What does this do?
    LowPriority         As Long         'What does this do?
    KickOutDelay        As Long         'What does this do?

    QuickMessageLimit   As Integer      'Number of messages sent every 5 seconds before all
                                        'inter-zone messages are ignored from that player
    AllowNewZones       As Long         'Can unknown zones create a session?
    
    ZonecastLock        As Long         '** requires BSysOp?
End Type

Private Running         As Boolean      'Running?

Public BillingSettings  As INI_stuff    'Settings from disk

Public Sub FillSettings()
    If GetProfileString("Login", "AllowNewZones") = "" Then Call SetProfile("Login", "AllowNewZones", "0")
    If GetProfileString("Login", "Port") = "" Then Call SetProfile("Login", "Port", "4000")
    If GetProfileString("Login", "AllowNewUsers") = "" Then Call SetProfile("Login", "AllowNewUsers", "1")
    If GetProfileString("Login", "AskNewUsers") = "" Then Call SetProfile("Login", "AskNewUsers", "1")

    If GetProfileString("Misc", "QuickMessageLimit") = "" Then Call SetProfile("Misc", "QuickMessageLimit", "4")
    If GetProfileString("Misc", "ZonecastLock") = "" Then Call SetProfile("Misc", "ZonecastLock", "1")
'    If GetProfileString("Misc", "KickOutDelay") = "" Then Call SetProfile("Misc", "KickOutDelay", "50")
'    If GetProfileString("Misc", "LowPriority") = "" Then Call SetProfile("Misc", "LowPriority", "0")
'    If GetProfileString("Misc", "MaxQueueForLogin") = "" Then Call SetProfile("Misc", "MaxQueueForLogin", "24000")
End Sub

Public Sub LoadSettings()
    BillingSettings.AllowNewZones = GetProfileNumeric("Login", "AllowNewZones")
    BillingSettings.Port = GetProfileNumeric("Login", "Port")
    BillingSettings.AllowNewUsers = GetProfileNumeric("Login", "AllowNewUsers")
    BillingSettings.AskNewUsers = GetProfileNumeric("Login", "AskNewUsers")
    
    BillingSettings.QuickMessageLimit = GetProfileNumeric("Misc", "QuickMessageLimit")
    BillingSettings.ZonecastLock = GetProfileNumeric("Misc", "ZonecastLock")
'    BillingSettings.KickOutDelay = GetProfileNumeric("Misc", "KickOutDelay")
'    BillingSettings.LowPriority = GetProfileNumeric("Misc", "LowPriority")
'    BillingSettings.MaxQueueForLogin = GetProfileNumeric("Misc", "MaxQueueForLogin")
End Sub

'Called on StartUp
Public Sub Main()
    If FindWindow(vbNullString, PROG_TITLE) > 0 Then
        Running = False
        End
    Else
        Randomize Timer

        Call FillSettings: LoadSettings

        MainFrm.Show

        UDPStartWinsock
        MySock = UDPMakeSocket(CInt(BillingSettings.Port))
        UDPBindCallBack MySock

        AddDebug "Waiting for Connect on port " + CStr(BillingSettings.Port) + " ..."

        MainFrm.Caption = PROG_TITLE
        Running = True
    End If
End Sub

'Save all events in the main window to disk
Public Sub PutServerLog()
On Error GoTo ErrHandler2
                Open "Server.log" For Output As #14: Close
                Open "Server.log" For Binary As #15
                    Put #15, 1, CStr(MainFrm.sOut)
ErrHandler2:    Close
End Sub

'Send a disconnect and clean up my handles
Public Sub ShutDown()
    If Running = False Then Exit Sub

    Do While TotalServers > 0
        Call DeleteServer(1)
    Loop

    Call UDPBindCallBack(MySock)
    Call UDPEndWinsock
End Sub
