Attribute VB_Name = "SquadBot"
Option Explicit
                                    
                                    'Offset for..
Public Const S_Length = 72          'End of Squad data
Public Const S_Name = 0             'Squad name
Public Const S_Password = 24        'Squad password
Public Const S_Owner = 48           'Squad Squad

                                    'Length of data block for..
Private Const L_Name = 24           'Squad name
Private Const L_Password = 24       'Squad password
Private Const L_Owner = 24          'Squad Owner

'Retreive one full Squad information block
Private Function GetSquadData(ServerID As Integer, SquadID As Long) As String
    With ServerList(ServerID)
        GetSquadData = Cipher(SquadID, mID(.VSquadData, (SquadID - 1) * S_Length + 1, S_Length))
    End With
End Function

'Write a Squad information block to disk
Private Sub PutSquadData(ServerID As Integer, SquadID As Long, SquadData As String)
    With ServerList(ServerID)
        .VSquadData = Left(.VSquadData, (SquadID - 1) * S_Length + 1) + Cipher(SquadID, SquadData) + mID(.VSquadData, (SquadID) * S_Length + 1)
    End With
End Sub

'Remove a squad from the Squad.RAW (Leaves garbage at the end for now)
Public Sub RemoveSquad(ServerID As Integer, SquadID As Long)
    Dim oStr As String * S_Length, L As Long, S As String

    With ServerList(ServerID)
        S = LCase(GetSData(ServerID, SquadID, S_Name))
        For L = 1 To .TotalLoggedPlayers
            If LCase(GetData(ServerID, L, P_Squad)) = S Then
                Call PutData(ServerID, L, P_Squad, "")
            End If
        Next

        For L = SquadID To .TotalLoggedSquads - 1
            Call PutSquadData(ServerID, L, GetSquadData(ServerID, L + 1))
        Next

        .TotalLoggedSquads = .TotalLoggedSquads - 1
    End With
End Sub

'Intended to be used ONCE during login for the SquadID parameter
Public Function FindSquad(ServerID As Integer, Name As String) As Long
    Dim oStr As String * S_Length, I As Long, S As String
    S = LCase(FillZero(Name, 24))

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedSquads
            oStr = GetSquadData(ServerID, I)
            If LCase(mID(oStr, S_Name + 1, L_Name)) = S Then
                FindSquad = I
                Exit For
            End If
        Next
    End With
End Function

'Add a Squad to the end of the database and increment the TotalLoggedSquads
' on disk and memory by one
Public Sub AddSquadEntry(ServerID As Integer, Name As String, Password As String, Owner As String)
    Dim oStr As String * S_Length

    oStr = FillZero(Name, 24) + pwEncryption(FillZero(Password, 24)) + FillZero(Owner, 24)

    With ServerList(ServerID)
        .TotalLoggedSquads = .TotalLoggedSquads + 1
        Call PutSquadData(ServerID, .TotalLoggedSquads, oStr)
    End With
End Sub

'Simplified form of GetSquadData():  This one extracts literal string data
' from a specified Catagory.
Public Function GetSData(ServerID As Integer, SquadID As Long, Catagory As Integer) As String
    Dim oStr As String * S_Length: oStr = GetSquadData(ServerID, SquadID)

    Select Case Catagory
        Case S_Name
            GetSData = mID(oStr, S_Name + 1, L_Name)
        Case S_Password
            GetSData = mID(oStr, S_Password + 1, L_Password)
        Case S_Owner
            GetSData = mID(oStr, S_Owner + 1, L_Owner)
        Case Else
            AddDebug "Unable to read an entry from Squad." + CStr(ServerList(ServerID).ScoreID)
    End Select
End Function

'Inserts given data into the given slot.  Going to be slow for now
Public Sub PutSData(ServerID As Integer, SquadID As Long, Catagory As Integer, NewData As String)
    Dim oStr As String * S_Length: oStr = GetSquadData(ServerID, SquadID)

    Select Case Catagory
        Case S_Name
            NewData = FillZero(NewData, L_Name)
            oStr = NewData + mID(oStr, S_Name + L_Name + 1)
        Case S_Password
            NewData = FillZero(NewData, L_Password)
            oStr = Left(oStr, S_Password) + pwEncryption(NewData) + mID(oStr, S_Password + L_Password + 1)
        Case S_Owner
            NewData = FillZero(NewData, L_Owner)
            oStr = Left(oStr, S_Owner) + NewData + mID(oStr, S_Owner + L_Owner + 1)
        Case Else
            AddDebug "Unable to write an entry to Squad." + CStr(ServerList(ServerID).ScoreID)
    End Select

    Call PutSquadData(ServerID, SquadID, oStr)
End Sub
