Attribute VB_Name = "ScoreBot"
Option Explicit
                                    
                                    'Offset for..
Private Const Z_Length = 92         'End of score data
Public Const Z_Points = 0           'Player points
Public Const Z_Wins = 4             'Player wins
Public Const Z_Losses = 6           'Player losses

                                    'Length of data block for..
Private Const L_Points = 4          'Banned player's name
Private Const L_Wins = 2            'The operator who banned him
Private Const L_Losses = 2          'The date he was banned as a long


Public Sub LoadScoreData(ServerIndex As Long, ScoreID As Long)
'On error GoTo ErrHandler7
                Open "Scores." + CStr(ScoreID) For Binary As #7
                    VBanData = Space(B_Length * TotalLoggedBans)
                    Get #7, 1, ServerList(ServerIndex).VScoreData
ErrHandler7:    Close
End Sub

Public Sub SaveBanData(ScoreID As Long)
'On error GoTo ErrHandler8
                Open "Scores." + CStr(ScoreID) For Binary As #8
                    Put #8, 1, VBanData
ErrHandler8:    Close
End Sub

'Retreive one full Ban information block
Private Function GetBanData(BanID As Long) As String
    GetBanData = Cipher(BanID, mID(VBanData, (BanID - 1) * B_Length + 5, B_Length))
End Function

'Write a Ban information block to disk
Private Sub PutBanData(BanID As Long, BanData As String)
    VBanData = Left(VBanData, (BanID - 1) * B_Length + 4) + Cipher(BanID, BanData) + mID(VBanData, (BanID) * B_Length + 5)
End Sub

'Gets the total logged Bans as a Long.  It is stored at offset 0 in the Ban.RAW
Public Sub GetTotalBans()
    TotalLoggedBans = GetLong(Left(VBanData, 4))
End Sub

'Change the total number of logged Bans to the value given
Public Sub SetTotalBans(L As Long)
    TotalLoggedBans = L
    VBanData = GetString(L) + mID(VBanData, 5)
End Sub

'Intended to be used ONCE during login for the BanID parameter
Public Function FindBan(Name As String) As Long
    Dim oStr As String * B_Length, I As Long, S As String
    S = LCase(FillZero(Name, 24))

    For I = 1 To TotalLoggedBans
        oStr = GetBanData(I)
        If LCase(mID(oStr, B_Name + 1, L_Name)) = S Then
            FindBan = I
            Exit For
        End If
    Next
End Function

'Match a ban with the given info
Public Function MatchBan(Name As String, ID As String, IP As String) As Long
    Dim oStr As String * B_Length, I As Long
    IP = Left(IP, L_IP - 1)

    For I = 1 To TotalLoggedBans
        oStr = GetBanData(I)
        If LCase(mID(oStr, B_Name + 1, L_Name)) = LCase(FillZero(Name, 24)) Then
            MatchBan = I: Exit Function
        ElseIf mID(oStr, B_MachineID + 1, L_MachineID) = ID Then
            MatchBan = I: Exit Function
        ElseIf mID(oStr, B_IP + 1, L_IP - 1) = IP Then
            MatchBan = I: Exit Function
        End If
    Next

    MatchBan = 0
End Function

'Add a Ban to the end of the database and increment the TotalLoggedBans on disk and memory by one
Public Sub AddBanEntry(Name As String, Operator As String, ID As String, IP As String)
    Dim oStr As String * B_Length

    oStr = FillZero(Name, 24) + FillZero(Operator, 24) + GetTimeString + ID + IP + String(32, Chr(0))

    Call SetTotalBans(TotalLoggedBans + 1)
    Call PutBanData(TotalLoggedBans, oStr)
End Sub

'Input = 23
'Output = Dorkus Maximus [123.56.6.*] Catid [27-4-90]
Public Function GetBanInfo(BanID As Long) As String
    GetBanInfo = TrimZero(GetBData(BanID, B_Name)) + " [" + GetApproxIPString(GetBData(BanID, B_IP)) + "] by " + TrimZero(GetBData(BanID, B_Operator)) + " [" + GetStringTime(GetBData(BanID, B_Date)) + "]"
End Function

'Remove a ban from the Ban.RAW (Leaves garbage at the end for now)
Public Sub RemoveBan(BanID As Long)
'On error GoTo ErrHandler2
                Dim oStr As String * B_Length, L As Long

                Open "Ban.RAW" For Binary As #10
                    For L = BanID To TotalLoggedBans - 1
                        Call PutBanData(L, GetBanData(L + 1))
                    Next
                Close

                Call SetTotalBans(TotalLoggedBans - 1)
ErrHandler2:    Close
End Sub

'Simplified form of GetBanData():  This one extracts literal string data
' from a specified category.
Public Function GetBData(BanID As Long, Category As Integer) As String
    Dim oStr As String * B_Length: oStr = GetBanData(BanID)

    Select Case Category
        Case B_Name
            GetBData = mID(oStr, B_Name + 1, L_Name)
        Case B_Operator
            GetBData = mID(oStr, B_Operator + 1, L_Operator)
        Case B_Date
            GetBData = mID(oStr, B_Date + 1, L_Date)
        Case B_MachineID
            GetBData = mID(oStr, B_MachineID + 1, L_MachineID)
        Case B_IP
            GetBData = mID(oStr, B_IP + 1, L_IP)
        Case B_Comment
            GetBData = mID(oStr, B_Comment + 1, L_Comment)
        Case Else
            MsgBox "Unable to read an entry from Ban.RAW", vbExclamation, "Important information lost:"
    End Select
End Function

'Inserts given data into the given slot.  Going to be slow for now
Public Sub PutBData(BanID As Long, Category As Integer, NewData As String)
    Dim oStr As String * B_Length: oStr = GetBanData(BanID)

    Select Case Category
        Case B_Name
            NewData = FillZero(NewData, L_Name)
            oStr = NewData + mID(oStr, B_Name + L_Name + 1)
        Case B_Operator
            NewData = FillZero(NewData, L_Operator)
            oStr = Left(oStr, B_Operator) + pwEncryption(NewData) + mID(oStr, B_Operator + L_Operator + 1)
        Case B_Date
            NewData = FillZero(NewData, L_Date)
            oStr = Left(oStr, B_Date) + NewData + mID(oStr, B_Date + L_Date + 1)
        Case B_MachineID
            NewData = FillZero(NewData, L_MachineID)
            oStr = Left(oStr, B_MachineID) + NewData + mID(oStr, B_MachineID + L_MachineID + 1)
        Case B_IP
            NewData = FillZero(NewData, L_IP)
            oStr = Left(oStr, B_IP) + NewData + mID(oStr, B_IP + L_IP + 1)
        Case B_Comment
            NewData = FillZero(NewData, L_Comment)
            oStr = Left(oStr, B_Comment) + NewData + mID(oStr, B_Comment + L_Comment + 1)
        Case Else
            MsgBox "Unable to write an entry to Ban.RAW", vbExclamation, "Important information lost:"
    End Select

    Call PutBanData(BanID, oStr)
End Sub
