Attribute VB_Name = "PlayerBot"
Option Explicit

                                    'Offset for..
Public Const P_Length = 128         'End of player data
Public Const P_Name = 0             'Player name
Public Const P_Password = 24        'Player password
Public Const P_Squad = 48           'Player Squad
Public Const P_Score = 72           'Win/Loss/Goals/Kill Pts/Pts given/something else
Public Const P_CreateDate = 86      'Creation date
Public Const P_LastIP = 98          'Last IP Address he logged in under
Public Const P_LastID = 112         'Last Machine ID he used
Public Const P_LastPlayed = 116     'Date of last time playing
Public Const P_TotalSeconds = 120   'Total seconds he spent logged in
Public Const P_TotalLogins = 124    'Total times he logged in

                                    'Length of data block for..
Private Const L_Name = 24           'Player name
Private Const L_Password = 24       'Player password
Private Const L_Squad = 24          'Player Squad
Private Const L_Score = 14          'Points
Private Const L_CreateDate = 12     'Creation date
Private Const L_LastIP = 4          'Last IP Address he logged in under
Private Const L_LastID = 4          'Last Machine ID he used
Private Const L_LastPlayed = 4      'Date of last time playing
Private Const L_TotalSeconds = 4    'Total seconds he spent logged in
Private Const L_TotalLogins = 4     'Total times he logged in

'Retreive one full player information block
Private Function GetPlayerData(ServerID As Integer, PlayerID As Long) As String
    With ServerList(ServerID)
        GetPlayerData = Cipher(PlayerID, mID(.VPlayerData, (PlayerID - 1) * P_Length + 1, P_Length))
    End With
End Function

'Write a player information block to disk
Private Sub PutPlayerData(ServerID As Integer, PlayerID As Long, PlayerData As String)
    With ServerList(ServerID)
        .VPlayerData = Left(.VPlayerData, (PlayerID - 1) * P_Length) + Cipher(PlayerID, PlayerData) + mID(.VPlayerData, PlayerID * P_Length + 1)
    End With
End Sub

'Intended to be used during login for the StoredID & PlayerID parameters
Public Function FindPlayer(ServerID As Integer, Name As String) As Long
    Dim oStr As String * P_Length, I As Long, S As String * 24
    S = LCase(FillZero(Name, 24))

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedPlayers
            oStr = GetPlayerData(ServerID, I)
            If LCase(mID(oStr, P_Name + 1, L_Name)) = S Then
                FindPlayer = I
                Exit For
            End If
        Next
    End With
End Function

'Add a player to the end of the database and increment the TotalLoggedPlayers on disk and memory by one
Public Sub AddPlayerEntry(Name As String, Password As String, LastIP As String, LastID As String)
    Dim oStr As String * P_Length, I As Integer, L As Long

    oStr = FillZero(Name, 24) + pwEncryption(FillZero(Password, 24)) + String(L_Squad + L_Score, Chr(0))
    oStr = oStr + GetDateString + LastIP + LastID + GetTimeString + String(L_TotalSeconds + L_TotalLogins, 0)

    For I = 1 To TotalServers
        With ServerList(I)
            L = FindPlayer(I, Name)
            If L = 0 Then
                .TotalLoggedPlayers = .TotalLoggedPlayers + 1
                Call PutPlayerData(I, .TotalLoggedPlayers, oStr)
            Else
                Call PutData(I, L, P_Password, Password)
            End If
        End With
    Next
End Sub

'Macro'd commands to change a players score (triggered when they quit)
Public Sub UpdatePlayer(ServerID As Integer, PlayerID As Long, Score As String, TimeOnline As String)
    Dim oStr As String * P_Length: oStr = GetPlayerData(ServerID, PlayerID)

    oStr = Left(oStr, P_Score) + FillZero(Score, L_Score) + mID(oStr, P_Score + L_Score + 1)
    oStr = Left(oStr, P_TotalSeconds) + FillZero(GetString(GetLong(mID(oStr, P_TotalSeconds + 1, L_TotalSeconds)) + CLng(GetInteger(TimeOnline))), L_TotalSeconds) + mID(oStr, P_TotalSeconds + L_TotalSeconds + 1)

    PutPlayerData ServerID, PlayerID, oStr
End Sub

'Match an alias with the given info
Public Function MatchAlias(ServerID As Integer, Name As String, ID As String, IP As String) As String
    Dim oStr As String * P_Length, I As Long, O As String: O = ""

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedPlayers
            oStr = GetPlayerData(ServerID, I)
            If mID(oStr, P_LastID + 1, L_LastID) = ID Then
                O = O + TrimZero(mID(oStr, P_Name + 1, L_Name)) + ", "
            ElseIf mID(oStr, P_LastIP + 1, L_LastIP) = IP Then
                O = O + TrimZero(mID(oStr, P_Name + 1, L_Name)) + ", "
            ElseIf mID(oStr, P_LastIP + 1, L_LastIP - 1) = Left(IP, L_LastIP - 1) Then
                O = O + TrimZero(mID(oStr, P_Name + 1, L_Name)) + "(~IP), "
            End If
        Next
    End With

    MatchAlias = Left(O, Len(O) - 2)
End Function

'Simplified form of GetPlayerData():  This one extracts literal string data
' from a specified Catagory.
Public Function GetData(ServerID As Integer, PlayerID As Long, Catagory As Integer) As String
    Dim oStr As String * P_Length: oStr = GetPlayerData(ServerID, PlayerID)

    Select Case Catagory
        Case P_Name
            GetData = mID(oStr, P_Name + 1, L_Name)
        Case P_Password
            GetData = mID(oStr, P_Password + 1, L_Password)
        Case P_Squad
            GetData = mID(oStr, P_Squad + 1, L_Squad)
        Case P_Score
            GetData = mID(oStr, P_Score + 1, L_Score)
        Case P_LastIP
            GetData = mID(oStr, P_LastIP + 1, L_LastIP)
        Case P_LastID
            GetData = mID(oStr, P_LastID + 1, L_LastID)
        Case P_CreateDate
            GetData = mID(oStr, P_CreateDate + 1, L_CreateDate)
        Case P_LastPlayed
            GetData = mID(oStr, P_LastPlayed + 1, L_LastPlayed)
        Case P_TotalSeconds
            GetData = mID(oStr, P_TotalSeconds + 1, L_TotalSeconds)
        Case P_TotalLogins
            GetData = mID(oStr, P_TotalLogins + 1, L_TotalLogins)
        Case Else
            AddDebug "Unable to read an entry from User." + CStr(ServerList(ServerID).ScoreID)
    End Select
End Function

'Inserts given data into the given slot.  Going to be slow for now
Public Sub PutData(ServerID As Integer, PlayerID As Long, Catagory As Integer, NewData As String)
    Dim oStr As String * P_Length: oStr = GetPlayerData(ServerID, PlayerID)

    Select Case Catagory
        Case P_Name
            NewData = FillZero(NewData, L_Name)
            oStr = NewData + mID(oStr, P_Name + L_Name + 1)
        Case P_Password
            NewData = FillZero(NewData, L_Password)
            oStr = Left(oStr, P_Password) + pwEncryption(NewData) + mID(oStr, P_Password + L_Password + 1)
        Case P_Squad
            NewData = FillZero(NewData, L_Squad)
            oStr = Left(oStr, P_Squad) + NewData + mID(oStr, P_Squad + L_Squad + 1)
        Case P_Score
            NewData = FillZero(NewData, L_Score)
            oStr = Left(oStr, P_Score) + NewData + mID(oStr, P_Score + L_Score + 1)
        Case P_CreateDate
            NewData = FillZero(NewData, L_CreateDate)
            oStr = Left(oStr, P_CreateDate) + NewData + mID(oStr, P_CreateDate + L_CreateDate + 1)
        Case P_LastIP
            NewData = FillZero(NewData, L_LastIP)
            oStr = Left(oStr, P_LastIP) + NewData + mID(oStr, P_LastIP + L_LastIP + 1)
        Case P_LastID
            NewData = FillZero(NewData, L_LastID)
            oStr = Left(oStr, P_LastID) + NewData + mID(oStr, P_LastID + L_LastID + 1)
        Case P_LastPlayed
            NewData = FillZero(NewData, L_LastPlayed)
            oStr = Left(oStr, P_LastPlayed) + NewData + mID(oStr, P_LastPlayed + L_LastPlayed + 1)
        Case P_TotalSeconds
            NewData = FillZero(NewData, L_TotalSeconds)
            oStr = Left(oStr, P_TotalSeconds) + NewData + mID(oStr, P_TotalSeconds + L_TotalSeconds + 1)
        Case P_TotalLogins
            NewData = FillZero(NewData, L_TotalLogins)
            oStr = Left(oStr, P_TotalLogins) + NewData
        Case Else
            AddDebug "Unable to write an entry to User." + CStr(ServerList(ServerID).ScoreID)
    End Select

    Call PutPlayerData(ServerID, PlayerID, oStr)
End Sub
