Attribute VB_Name = "Declares"
Option Explicit

'Used for managing SSBilling.INI
Public Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

'Used for maintaining only one open instance at a time
Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

'Extremely useful in converting Strings to Longs and Ints and vice-versa
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Dest As Any, Src As Any, ByVal cb&)

Public Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Public Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal wndrpcPrev As Long, ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Public Pointer      As String * 4           '..So I don't have to declare a temporary
                                            ' variable all the time.

Public Const PROG_TITLE = "SSBilling (beta 7)"  'So that only one instance can be opened

Private QueuedMessages              As String
Private TotalMessages               As Integer

Private I                           As Integer
Private L                           As Long

'Read a setting from SubBill.INI -> String
Public Function GetProfileString(Section As String, Key As String) As String
    Dim S As String * 255
    L = GetPrivateProfileString(Section, Key, "", S, 255, App.Path + "\SubBill.INI")
    GetProfileString = Left(S, L)
End Function

'Read a setting from SubBill.INI -> Long
Public Function GetProfileNumeric(Section As String, Key As String) As Long
    Dim S As String * 255
    L = GetPrivateProfileString(Section, Key, "0", S, 255, App.Path + "\SubBill.INI")
    GetProfileNumeric = CLng(Left(S, L))
End Function

'Set a settings in SubBill.INI to something.
'This is used for when variables are out of range or when I need
' to generate a new SubBill.INI for the user to edit (first run)
Public Sub SetProfile(Section As String, Key As String, Value As String)
    WritePrivateProfileString Section, Key, Value, App.Path + "\Subbill.INI"
End Sub

'Return an Integer stored in the given string
Public Function GetInteger(RawText As String) As Integer
    Call CopyMemory(I, ByVal RawText, 2)
    GetInteger = I
End Function

'Return a Long stored in the given string
Public Function GetLong(RawText As String) As Long
    Call CopyMemory(L, ByVal RawText, 4)
    GetLong = L
End Function

'Return a string representing a Long
Public Function GetString(lL As Long) As String
    Call CopyMemory(ByVal Pointer, lL, 4)
    GetString = Pointer
End Function

'Return a string representing an Integer
Public Function GetString2(iI As Integer) As String
    Dim S As String * 2
    Call CopyMemory(ByVal S, iI, 2)
    GetString2 = S
End Function

'Return RawText + X number of chr(0)s
Public Function FillZero(RawText As String, DesiredLength As Long) As String
    If DesiredLength = Len(RawText) Then
        FillZero = RawText
    ElseIf DesiredLength > Len(RawText) Then
        FillZero = RawText + String(DesiredLength - Len(RawText), Chr(0))
    Else
        FillZero = Left(RawText, DesiredLength)
    End If
End Function

'Return RawText without any chr(0)s on the right
Public Function TrimZero(RawText As String) As String
    I = InStr(1, RawText, Chr(0))
    If I > 0 Then
        TrimZero = Left(RawText, I - 1)
    Else
        TrimZero = RawText
    End If
End Function

'Return the current day, month and year as a Long
Public Function GetTimeString() As String
    GetTimeString = Chr(Day(Date)) + Chr(Month(Date)) + GetString2(Year(Date))
End Function

Public Function GetStringTime(cTime As String) As String
    GetStringTime = CStr(Asc(Left(cTime, 1))) + "-" + CStr(Asc(mID(cTime, 2, 1))) + "-" + CStr(GetInteger(mID(cTime, 3, 2)))
End Function

'Get the dotted format for a String IP
Public Function GetIPString(RawText As String)
    GetIPString = CStr(Asc(mID(RawText, 1, 1))) + "." + CStr(Asc(mID(RawText, 2, 1))) + "." + CStr(Asc(mID(RawText, 3, 1))) + "." + CStr(Asc(mID(RawText, 4, 1)))
End Function

'Get the dotted format for a String IP, minus the subnet
Public Function GetApproxIPString(RawText As String)
    GetApproxIPString = CStr(Asc(mID(RawText, 1, 1))) + "." + CStr(Asc(mID(RawText, 2, 1))) + "." + CStr(Asc(mID(RawText, 3, 1))) + ".*"
End Function

'Get the password from the given "Name:Pass" string
Public Function RParse(RawText As String, sChar As String) As String
    RawText = Trim(RawText)
    I = InStr(1, RawText, sChar)
    If I > 0 Then
        RParse = Trim(mID(RawText, I + 1))
    Else
        RParse = ""
    End If
End Function

'Get the name from the given "Name:Pass" string
Public Function LParse(RawText As String, sChar As String) As String
    RawText = Trim(RawText)
    I = InStr(1, RawText, sChar)
    If I > 0 Then
        LParse = Trim(Left(RawText, I - 1))
    Else
        LParse = ""
    End If
End Function

'year, month, day, hour, minute, second [12 bytes]
Public Function GetDateString()
    GetDateString = Chr(&HD0) + Chr(7) + GetString2(Month(Date)) + GetString2(Day(Date)) + GetString2(Hour(Time)) + GetString2(Minute(Time)) + GetString2(Second(Time))
End Function

Public Function Reverse(RawText As String) As String
    Dim O As String

    For I = Len(RawText) To 1 Step -1
        O = O + mID(RawText, I, 1)
    Next

    Reverse = O
End Function

Public Function LOWORD(DWord As Long) As Integer
    LOWORD = CInt(DWord Mod 65536)
End Function

Public Function HIWORD(DWord As Long) As Integer
    HIWORD = CInt(DWord / 65536)
End Function

'A macro for writing an info message to the Mainfrm.sOut textbox
Public Sub AddDebug(Text As String)
    If TotalMessages < 20 Then
        TotalMessages = TotalMessages + 1
        QueuedMessages = QueuedMessages + vbNewLine + CStr(Time) + "| " + Text
    End If
End Sub

'...Modified to prevent flooding
Public Sub DisplayMessages()
    If TotalMessages = 0 Then Exit Sub
    
    If Len(MainFrm.sOut) > 31000 Then MainFrm.sOut = Right(MainFrm.sOut, 31000)
    MainFrm.sOut = MainFrm.sOut + QueuedMessages
    
    MainFrm.sOut.SelStart = Len(MainFrm.sOut)
    TotalMessages = 0: QueuedMessages = ""
End Sub
