Attribute VB_Name = "BanFreeBot"
Option Explicit
                                    
                                    'Offset for..
Public Const F_Length = 52          'End of BanFree data
Public Const F_Name = 0             'Banfreed player's name
Public Const F_Operator = 24        'The operator who banfreed him
Public Const F_Date = 48            'The date he was banfreed as a long

                                    'Length of data block for..
Private Const L_Name = 24           'Banfreed player's name
Private Const L_Operator = 24       'The operator who banfreed him
Private Const L_Date = 4            'The date he was banfreed as a long

'Retreive one full Banfree information block
Private Function GetBanfreeData(ServerID As Integer, BanfreeID As Long) As String
    With ServerList(ServerID)
        GetBanfreeData = Cipher(BanfreeID, mID(.VBanfreeData, (BanfreeID - 1) * F_Length + 1, F_Length))
    End With
End Function

'Write a Banfree information block to disk
Private Sub PutBanfreeData(ServerID As Integer, BanfreeID As Long, BanfreeData As String)
    With ServerList(ServerID)
        .VBanfreeData = Left(.VBanfreeData, (BanfreeID - 1) * F_Length) + Cipher(BanfreeID, BanfreeData) + mID(.VBanfreeData, (BanfreeID) * F_Length + 1)
    End With
End Sub

'Intended to be used ONCE during login for the BanfreeID parameter
Public Function FindBanfree(ServerID As Integer, Name As String) As Long
    Dim oStr As String * F_Length, I As Long, S As String
    S = LCase(FillZero(Name, 24))

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedBanfrees
            oStr = GetBanfreeData(ServerID, I)
            If LCase(mID(oStr, F_Name + 1, L_Name)) = S Then
                FindBanfree = I
                Exit For
            End If
        Next
    End With
End Function

'Add a Banfree to the end of the database and increment the TotalLoggedBanfrees on disk and memory by one
Public Sub AddBanfreeEntry(ServerID As Integer, Name As String, Operator As String)
    Dim oStr As String * F_Length

    oStr = FillZero(Name, 24) + FillZero(Operator, 24) + GetTimeString

    With ServerList(ServerID)
        .TotalLoggedBanfrees = .TotalLoggedBanfrees + 1
        Call PutBanfreeData(ServerID, .TotalLoggedBanfrees, oStr)
    End With
End Sub

'Input = 23, Output = Dorkus Maximus by Catid [27-4-90]
Public Function GetBanfreeInfo(ServerID As Integer, BanfreeID As Long) As String
    GetBanfreeInfo = TrimZero(GetFData(ServerID, BanfreeID, F_Name)) + " by " + TrimZero(GetFData(ServerID, BanfreeID, F_Operator)) + " [" + GetStringTime(GetFData(ServerID, BanfreeID, F_Date)) + "]"
End Function

'Remove a Banfree from the Banfree.RAW (Leaves garbage at the end for now)
Public Sub RemoveBanfree(ServerID As Integer, BanfreeID As Long)
    Dim oStr As String * F_Length, L As Long

    With ServerList(ServerID)
        For L = BanfreeID To .TotalLoggedBanfrees - 1
            Call PutBanfreeData(ServerID, L, GetBanfreeData(ServerID, L + 1))
        Next

        .TotalLoggedBanfrees = .TotalLoggedBanfrees - 1
    End With
End Sub

'Simplified form of GetBanfreeData():  This one extracts literal string data
' from a specified Catagory.
Public Function GetFData(ServerID As Integer, BanfreeID As Long, Catagory As Integer) As String
    Dim oStr As String * F_Length: oStr = GetBanfreeData(ServerID, BanfreeID)

    Select Case Catagory
        Case F_Name
            GetFData = mID(oStr, F_Name + 1, L_Name)
        Case F_Operator
            GetFData = mID(oStr, F_Operator + 1, L_Operator)
        Case F_Date
            GetFData = mID(oStr, F_Date + 1, L_Date)
        Case Else
            AddDebug "Unable to read an entry from Banfree." + CStr(ServerList(ServerID).ScoreID)
    End Select
End Function

'Inserts given data into the given slot.  Going to be slow for now
Public Sub PutFData(ServerID As Integer, BanfreeID As Long, Catagory As Integer, NewData As String)
    Dim oStr As String * F_Length: oStr = GetBanfreeData(ServerID, BanfreeID)

    Select Case Catagory
        Case F_Name
            NewData = FillZero(NewData, L_Name)
            oStr = NewData + mID(oStr, F_Name + L_Name + 1)
        Case F_Operator
            NewData = FillZero(NewData, L_Operator)
            oStr = Left(oStr, F_Operator) + pwEncryption(NewData) + mID(oStr, F_Operator + L_Operator + 1)
        Case F_Date
            NewData = FillZero(NewData, L_Date)
            oStr = Left(oStr, F_Date) + NewData + mID(oStr, F_Date + L_Date + 1)
        Case Else
            AddDebug "Unable to wrute an entry to Banfree." + CStr(ServerList(ServerID).ScoreID)
    End Select

    Call PutBanfreeData(ServerID, BanfreeID, oStr)
End Sub
