Attribute VB_Name = "BanBot"
Option Explicit
                                    
                                    'Offset for..
Public Const B_Length = 92          'End of Ban data
Public Const B_Name = 0             'Banned player's name
Public Const B_Operator = 24        'The operator who banned him
Public Const B_Date = 48            'The date he was banned as a long
Public Const B_MachineID = 52       'The banned machine ID
Public Const B_IP = 56              'His banned IP
Public Const B_Comment = 60         'Ban comment

                                    'Length of data block for..
Private Const L_Name = 24           'Banned player's name
Private Const L_Operator = 24       'The operator who banned him
Private Const L_Date = 4            'The date he was banned as a long
Private Const L_MachineID = 4       'The banned machine ID
Private Const L_IP = 4              'His banned IP
Private Const L_Comment = 32        'Ban comment

'Retreive one full Ban information block
Private Function GetBanData(ServerID As Integer, BanID As Long) As String
    With ServerList(ServerID)
        GetBanData = Cipher(BanID, mID(.VBanData, (BanID - 1) * B_Length + 1, B_Length))
    End With
End Function

'Write a Ban information block to disk
Private Sub PutBanData(ServerID As Integer, BanID As Long, BanData As String)
    With ServerList(ServerID)
        .VBanData = Left(.VBanData, (BanID - 1) * B_Length) + Cipher(BanID, BanData) + mID(.VBanData, (BanID) * B_Length + 1)
    End With
End Sub

'Intended to be used ONCE during login for the BanID parameter
Public Function FindBan(ServerID As Integer, Name As String) As Long
    Dim oStr As String * B_Length, I As Long, S As String
    S = LCase(FillZero(Name, 24))

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedBans
            oStr = GetBanData(ServerID, I)
            If LCase(mID(oStr, B_Name + 1, L_Name)) = S Then
                FindBan = I
                Exit For
            End If
        Next
    End With
End Function

'Match a ban with the given info
Public Function MatchBan(ServerID As Integer, Name As String, ID As String, IP As String) As Long
    Dim oStr As String * B_Length, I As Long, N As String * 24
    IP = Left(IP, L_IP - 1): N = LCase(FillZero(Name, 24))

    With ServerList(ServerID)
        For I = 1 To .TotalLoggedBans
            oStr = GetBanData(ServerID, I)
            If LCase(mID(oStr, B_Name + 1, L_Name)) = N Then
                MatchBan = I: Exit Function
            ElseIf mID(oStr, B_MachineID + 1, L_MachineID) = ID Then
                MatchBan = I: Exit Function
            ElseIf mID(oStr, B_IP + 1, L_IP - 1) = IP Then
                MatchBan = I: Exit Function
            End If
        Next
    End With

    MatchBan = 0
End Function

'Add a Ban to the end of the database and increment the TotalLoggedBans on disk and memory by one
Public Sub AddBanEntry(ServerID As Integer, Name As String, Operator As String, ID As String, IP As String)
    Dim oStr As String * B_Length

    oStr = FillZero(Name, 24) + FillZero(Operator, 24) + GetTimeString + ID + IP + String(32, Chr(0))

    With ServerList(ServerID)
        .TotalLoggedBans = .TotalLoggedBans + 1
        Call PutBanData(ServerID, .TotalLoggedBans, oStr)
    End With
End Sub

'Input = 23, Output = Dorkus Maximus [123.56.6.*] Catid [27-4-90]
Public Function GetBanInfo(ServerID As Integer, BanID As Long) As String
    GetBanInfo = TrimZero(GetBData(ServerID, BanID, B_Name)) + " [" + GetApproxIPString(GetBData(ServerID, BanID, B_IP)) + "] by " + TrimZero(GetBData(ServerID, BanID, B_Operator)) + " [" + GetStringTime(GetBData(ServerID, BanID, B_Date)) + "]"
End Function

'Remove a ban from the Ban.RAW (Leaves garbage at the end for now)
Public Sub RemoveBan(ServerID As Integer, BanID As Long)
    Dim oStr As String * B_Length, L As Long

    With ServerList(ServerID)
        For L = BanID To .TotalLoggedBans - 1
            Call PutBanData(ServerID, L, GetBanData(ServerID, L + 1))
        Next

        .TotalLoggedBans = .TotalLoggedBans - 1
    End With
End Sub

'Simplified form of GetBanData():  This one extracts literal string data
' from a specified Catagory.
Public Function GetBData(ServerID As Integer, BanID As Long, Catagory As Integer) As String
    Dim oStr As String * B_Length: oStr = GetBanData(ServerID, BanID)

    Select Case Catagory
        Case B_Name
            GetBData = mID(oStr, B_Name + 1, L_Name)
        Case B_Operator
            GetBData = mID(oStr, B_Operator + 1, L_Operator)
        Case B_Date
            GetBData = mID(oStr, B_Date + 1, L_Date)
        Case B_MachineID
            GetBData = mID(oStr, B_MachineID + 1, L_MachineID)
        Case B_IP
            GetBData = mID(oStr, B_IP + 1, L_IP)
        Case B_Comment
            GetBData = mID(oStr, B_Comment + 1, L_Comment)
        Case Else
            AddDebug "Unable to read an entry from Ban." + CStr(ServerList(ServerID).ScoreID)
    End Select
End Function

'Inserts given data into the given slot.  Going to be slow for now
Public Sub PutBData(ServerID As Integer, BanID As Long, Catagory As Integer, NewData As String)
    Dim oStr As String * B_Length: oStr = GetBanData(ServerID, BanID)

    Select Case Catagory
        Case B_Name
            NewData = FillZero(NewData, L_Name)
            oStr = NewData + mID(oStr, B_Name + L_Name + 1)
        Case B_Operator
            NewData = FillZero(NewData, L_Operator)
            oStr = Left(oStr, B_Operator) + pwEncryption(NewData) + mID(oStr, B_Operator + L_Operator + 1)
        Case B_Date
            NewData = FillZero(NewData, L_Date)
            oStr = Left(oStr, B_Date) + NewData + mID(oStr, B_Date + L_Date + 1)
        Case B_MachineID
            NewData = FillZero(NewData, L_MachineID)
            oStr = Left(oStr, B_MachineID) + NewData + mID(oStr, B_MachineID + L_MachineID + 1)
        Case B_IP
            NewData = FillZero(NewData, L_IP)
            oStr = Left(oStr, B_IP) + NewData + mID(oStr, B_IP + L_IP + 1)
        Case B_Comment
            NewData = FillZero(NewData, L_Comment)
            oStr = Left(oStr, B_Comment) + NewData + mID(oStr, B_Comment + L_Comment + 1)
        Case Else
            AddDebug "Unable to wrute an entry to Ban." + CStr(ServerList(ServerID).ScoreID)
    End Select

    Call PutBanData(ServerID, BanID, oStr)
End Sub
