Attribute VB_Name = "Winsock"
Option Explicit

'Declare Function lstrlen Lib "kernel32" (ByVal lpString As Any) As Integer

Public Enum FD
    FD_READ = 1
    FD_WRITE = 2
    FD_OOB = 4
    FD_ACCEPT = 8
    FD_CONNECT = 16
    FD_CLOSE = 32
    FD_SETSIZE = 64
End Enum

Global Const FD_ALL = 1 Or 2 Or 4 Or 8 Or 16 Or 32 Or 64

Type hostent
    h_name As Long
    h_aliases As Long
    h_addrtype As Integer
    h_length As Integer
    h_addr_list As Long
End Type

Public hostent As hostent

Type WSAdata
    wVersion As Integer
    wHighVersion As Integer
    szDescription As String * 257
    szSystemStatus As String * 129
    iMaxSockets As Integer
    iMaxUdpDg As Integer
    lpVendorInfo As Long
End Type
Public WSAdata As WSAdata

Type sockaddr
    sin_family As Integer
    sin_port As Integer
    sin_addr As Long
    sin_zero As String * 8
End Type
Public sockaddr As sockaddr

Public Declare Function bind Lib "wsock32.dll" (ByVal S As Long, addr As sockaddr, ByVal namelen As Long) As Long
Public Declare Function closesocket Lib "wsock32.dll" (ByVal S As Long) As Long
Public Declare Function htons Lib "wsock32.dll" (ByVal hostshort As Long) As Integer
Public Declare Function inet_addr Lib "wsock32.dll" (ByVal CP As String) As Long
Public Declare Function recvfrom Lib "wsock32.dll" (ByVal S As Long, buf As Any, ByVal buflen As Long, ByVal flags As Long, from As sockaddr, fromlen As Long) As Long
Public Declare Function sendto Lib "wsock32.dll" (ByVal S As Long, buf As Any, ByVal buflen As Long, ByVal flags As Long, to_addr As sockaddr, ByVal tolen As Long) As Long
Public Declare Function socket Lib "wsock32.dll" (ByVal af As Long, ByVal s_type As Long, ByVal protocol As Long) As Long
Public Declare Function gethostbyname Lib "wsock32.dll" (ByVal host_name As String) As Long
Public Declare Function WSAStartup Lib "wsock32.dll" (ByVal wVR As Long, lpWSAD As WSAdata) As Long
Public Declare Function WSACleanup Lib "wsock32.dll" () As Long
Public Declare Function WSAAsyncSelect Lib "wsock32.dll" (ByVal S As Long, ByVal hWnd As Long, ByVal wMsg As Long, ByVal lEvent As Long) As Long

Public Function WSAGetSelectEvent(ByVal lParam As Long) As Long
    WSAGetSelectEvent = Int(lParam Mod 65536)
End Function

Function Long2IP(Address As Long) As String
    Dim S As String * 4

    S = GetString(Address)
    Long2IP = CStr(Asc(Mid(S, 1, 1))) + "." + CStr(Asc(Mid(S, 2, 1))) + "." + CStr(Asc(Mid(S, 3, 1))) + "." + CStr(Asc(Mid(S, 4, 1)))
End Function

Public Function IP2Long(ByVal HostName As String) As Long
    Dim phe As Long, addrList As Long, retIP As Long

    retIP = inet_addr(HostName)
    If retIP = &HFFFF Then
        phe = gethostbyname(HostName)
        If phe <> 0 Then
            CopyMemory ByVal hostent, phe, 16
            CopyMemory ByVal addrList, hostent.h_addr_list, 4
            CopyMemory ByVal retIP, addrList, hostent.h_length
        Else
            retIP = &HFFFF
        End If
    End If

    IP2Long = retIP
End Function

Function GetWSAErrorString(ByVal ErrNum As Long) As String
  On Error Resume Next
  
  Select Case ErrNum
    Case 0: GetWSAErrorString = "No error."
    Case 10004: GetWSAErrorString = "Interrupted system call."
    Case 10009: GetWSAErrorString = "Bad file number."
    Case 10013: GetWSAErrorString = "Permission Denied."
    Case 10014: GetWSAErrorString = "Bad Address."
    Case 10022: GetWSAErrorString = "Invalid Argument."
    Case 10024: GetWSAErrorString = "Too many open files."
    Case 10035: GetWSAErrorString = "Operation would block."
    Case 10036: GetWSAErrorString = "Operation now in progress."
    Case 10037: GetWSAErrorString = "Operation already in progress."
    Case 10038: GetWSAErrorString = "Socket operation on nonsocket."
    Case 10039: GetWSAErrorString = "Destination address required."
    Case 10040: GetWSAErrorString = "Message too long."
    Case 10041: GetWSAErrorString = "Protocol wrong type for socket."
    Case 10042: GetWSAErrorString = "Protocol not available."
    Case 10043: GetWSAErrorString = "Protocol not supported."
    Case 10044: GetWSAErrorString = "Socket type not supported."
    Case 10045: GetWSAErrorString = "Operation not supported on socket."
    Case 10046: GetWSAErrorString = "Protocol family not supported."
    Case 10047: GetWSAErrorString = "Address family not supported by protocol family."
    Case 10048: GetWSAErrorString = "Address already in use."
    Case 10049: GetWSAErrorString = "Can't assign requested address."
    Case 10050: GetWSAErrorString = "Network is down."
    Case 10051: GetWSAErrorString = "Network is unreachable."
    Case 10052: GetWSAErrorString = "Network dropped connection."
    Case 10053: GetWSAErrorString = "Software caused connection abort."
    Case 10054: GetWSAErrorString = "Connection reset by peer."
    Case 10055: GetWSAErrorString = "No buffer space available."
    Case 10056: GetWSAErrorString = "Socket is already connected."
    Case 10057: GetWSAErrorString = "Socket is not connected."
    Case 10058: GetWSAErrorString = "Can't send after socket shutdown."
    Case 10059: GetWSAErrorString = "Too many references: can't splice."
    Case 10060: GetWSAErrorString = "Connection timed out."
    Case 10061: GetWSAErrorString = "Connection refused."
    Case 10062: GetWSAErrorString = "Too many levels of symbolic links."
    Case 10063: GetWSAErrorString = "File name too long."
    Case 10064: GetWSAErrorString = "Host is down."
    Case 10065: GetWSAErrorString = "No route to host."
    Case 10066: GetWSAErrorString = "Directory not empty."
    Case 10067: GetWSAErrorString = "Too many processes."
    Case 10068: GetWSAErrorString = "Too many users."
    Case 10069: GetWSAErrorString = "Disk quota exceeded."
    Case 10070: GetWSAErrorString = "Stale NFS file handle."
    Case 10071: GetWSAErrorString = "Too many levels of remote in path."
    Case 10091: GetWSAErrorString = "Network subsystem is unusable."
    Case 10092: GetWSAErrorString = "Winsock DLL cannot support this application."
    Case 10093: GetWSAErrorString = "Winsock not initialized."
    Case 10101: GetWSAErrorString = "Disconnect."
    Case 11001: GetWSAErrorString = "Host not found."
    Case 11002: GetWSAErrorString = "Nonauthoritative host not found."
    Case 11003: GetWSAErrorString = "Nonrecoverable error."
    Case 11004: GetWSAErrorString = "Valid name, no data record of requested type."
    Case Else: GetWSAErrorString = "Undefined error"
  End Select
End Function
