Attribute VB_Name = "SSEncryption"
Option Explicit

Private Declare Sub SSInit Lib "sasme" (SSEncrTable As SSTable)
Private Declare Function SSEncrypt Lib "sasme" (SSEncrTable As SSTable, StrToEncr As String, ByVal StartPos As Integer) As Long
Private Declare Function SSDecrypt Lib "sasme" (SSEncrTable As SSTable, StrToDecr As String, ByVal StartPos As Integer) As Long
Private Declare Function SSPingValue Lib "sasme" () As Long
Private Declare Sub SSRandomize Lib "sasme" (ByVal Seed As Long)
Private Declare Function SSRnd Lib "sasme" () As Integer
Private Declare Function SSKey01 Lib "sasme" () As Long

Private Type SSTable
    SSKey               As Long
    SSBuf(1 To 520)     As Byte
End Type

Private FirstKey        As Long
Private EncryptTable    As SSTable

Public LastSID          As Long

Public Function NextSID() As String
    NextSID = GetString(LastSID)
    LastSID = LastSID + 1
End Function

Public Function MakePing() As String
    MakePing = GetString(SSPingValue)
End Function

Public Sub InitEncryption(ServerKey As Long)
    LastSID = 0

    EncryptTable.SSKey = ServerKey
    SSInit EncryptTable
    DoEvents
End Sub

Public Sub ResetKey()
    Dim I As Integer

    FirstKey = 0
    EncryptTable.SSKey = 0
    For I = 1 To 520
        EncryptTable.SSBuf(I) = 0
    Next
End Sub

Public Function Make01Key() As String
    FirstKey = SSKey01
'    Make01Key = Chr(0) + Chr(1) + GetString(FirstKey) + Chr(1) + Chr(0)
    Make01Key = Chr(0) + Chr(1) + GetString(0) + Chr(1) + Chr(0)
End Function

Public Sub Encrypt(PlainText As String)
    If EncryptTable.SSKey <> FirstKey Then
        If Left(PlainText, 1) <> Chr(0) Then
            Call SSEncrypt(EncryptTable, PlainText, 2)
        Else
            Call SSEncrypt(EncryptTable, PlainText, 3)
        End If
    End If
    DoEvents
End Sub

Public Sub Decrypt(CipherText As String)
    If EncryptTable.SSKey <> FirstKey Then
        If Left(CipherText, 1) <> Chr(0) Then
            Call SSDecrypt(EncryptTable, CipherText, 2)
        Else
            Call SSDecrypt(EncryptTable, CipherText, 3)
        End If
    End If
    DoEvents
End Sub
