Attribute VB_Name = "SSDirServ"
Option Explicit

'Socket structures

Private SockAddy            As sockaddr

'Packet filters

Private Enum O1_TYPES
    SessionData = 0
End Enum

Private Enum O2_TYPES
    SessionRequest = 1
    KeyNotify = 2
    ACKRequired = 3
    ACKMessage = 4
    SyncClient = 5
    SyncServer = 6
    Disconnect = 7
    PacketCluster = 14
End Enum

'Statix

Private DServList As String
Private Const DServIP = "212.161.6.11"

'Publix

Public Sub DownloadServerList()
    SERVER_TYPE = DirectoryServer
    ClearServers
    SetState STATUS_WINDOW

    Connect IP2Long(DServIP), 4990, DirectoryServer

    AddStatus "Connecting to Directory Server [" + DServIP + ":4990]"
End Sub

'Event handlers

Private Sub GenerateServerList(ByVal zList As String)
    Dim Comment As String, SName As String

    zList = Mid(zList, 2)

    Do While zList <> ""
        SName = TrimZero(Mid(zList, 15, 64))
        Comment = TrimZero(Mid(zList, 79))
        AddServer SName, Comment, GetLong(Left(zList, 4)), GetInteger(Mid(zList, 5, 2)), GetInteger(Mid(zList, 7, 2))
        zList = Mid(zList, 80 + Len(Comment))
    Loop
End Sub

Private Sub Handler02(UnencryptedPacket As String)
    UDPSend SockAddy, Chr(0) + Chr(3) + NextSID + GetString(1) + Chr(0)
    SendSync 1
    
    AddStatus "Sent login packet"
End Sub

Private Sub Handler03(UnencryptedPacket As String)
    If DServList = "" Then AddStatus "Receiving server list...  Please wait"

    DServList = DServList + Mid(UnencryptedPacket, 13)

    If Len(UnencryptedPacket) < 492 Then
        AddStatus "Done receiving the server list"
        AddStatus "Leaving"
        GenerateServerList DServList
        LeaveServer
        DServList = ""
    End If
End Sub

Private Sub Handler06(UnencryptedPacket As String)
    AddStatus "Sync packet accepted"
End Sub

Private Sub Handler07(UnencryptedPacket As String)
    AddStatus "Disconnected"
    DServList = ""
    Reset_Virtual_Connection
End Sub

Private Sub Handler0E(UnencryptedPacket As String)
    On Error GoTo LeaveCluster
    
    Dim I As Integer, O As String
    
    O = Mid(UnencryptedPacket, 3)
    Do
        I = Asc(Left(O, 1))
        Call HandleDServ(SockAddy, Mid(O, 2, I))
        O = Mid(O, I + 2)
    Loop
    
LeaveCluster:
End Sub

'Handler entry point

Public Sub HandleDServ(Sender As sockaddr, UnencryptedPacket As String)
    SockAddy = Sender

    Select Case Asc(Left(UnencryptedPacket, 1))
        Case O1_TYPES.SessionData
            Select Case Asc(Mid(UnencryptedPacket, 2, 1))
                Case O2_TYPES.KeyNotify: Call Handler02(UnencryptedPacket)
                Case O2_TYPES.ACKRequired: Call Handler03(UnencryptedPacket)
                Case O2_TYPES.SyncServer: Call Handler06(UnencryptedPacket)
                Case O2_TYPES.Disconnect: Call Handler07(UnencryptedPacket)
                Case O2_TYPES.PacketCluster: Call Handler0E(UnencryptedPacket)
                Case Else
                    AddDebug "Error: unknown O2 packet #" + CStr(Asc(Mid(UnencryptedPacket, 2, 1)))
            End Select
        Case Else
            AddDebug "Error: unknown O1 packet #" + CStr(Asc(Left(UnencryptedPacket, 1)))
    End Select
End Sub
