Attribute VB_Name = "Declares"
Option Explicit

'API declares

Public Declare Function GetTickCount Lib "kernel32" () As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Dest As Any, Src As Any, ByVal cb&)

Public Type ServerEntry
    ServerName  As String
    ServerIP    As Long
    ServerPort  As Integer
    ServerTotal As Integer
    Comment     As String

    EntryText   As String
End Type

'Private variables

Private S2 As String * 2
Private S4 As String * 4
Private S As String
Private I As Integer
Private L As Long

'Public variables

Public ACKs(0 To 32767) As Byte
Public ServerList(0 To 255) As ServerEntry
Public TotalServers         As Integer
Public Connected            As Boolean

'Server list

Public Sub LoadServerList()
Dim S As String, I As Integer, IPOffset As Integer, PortOffset As Integer

On Error GoTo ErrHandler
    Open "favorite.lst" For Input As #1
        Do While Not EOF(1)
            Line Input #1, S
            Select Case Left(S, 1)
                Case "#"
                    ServerList(I).Comment = Mid(S, 2)
                Case Else
                    I = I + 1
                    IPOffset = InStr(2, S, ",")
                    PortOffset = InStr(IPOffset + 1, S, ",")

                    With ServerList(I)
                        .ServerTotal = -1
                        .ServerName = Left(S, IPOffset - 1)
                        .ServerIP = IP2Long(Mid(S, IPOffset + 1, PortOffset - IPOffset - 1))
                        .ServerPort = CInt(Mid(S, PortOffset + 1))
                        .ServerTotal = -1
                        .EntryText = .ServerName + "," + Long2IP(.ServerIP) + "," + CStr(.ServerPort)
                        MainFrm.LoginZoneList.AddItem .ServerName + "(?)"
                    End With
            End Select
        Loop
ErrHandler: Close
    TotalServers = I
End Sub

Public Sub SaveServerList()
    Dim I As Integer

On Error GoTo ErrHandler
    Open "favorite.lst" For Output As #2

    For I = 1 To TotalServers
        Print #2, ServerList(I).EntryText
        Print #2, "#" + ServerList(I).Comment
    Next

ErrHandler: Close
End Sub

Public Sub AddServer(ServerName As String, Comment As String, IP As Long, Port As Integer, TotalPlayers As Integer)
    TotalServers = TotalServers + 1

    ServerList(TotalServers).ServerName = ServerName
    ServerList(TotalServers).Comment = Comment
    ServerList(TotalServers).ServerTotal = TotalPlayers
    ServerList(TotalServers).ServerIP = IP
    ServerList(TotalServers).ServerPort = Port
    ServerList(TotalServers).EntryText = ServerName + "," + Long2IP(IP) + "," + CStr(Port)

    MainFrm.LoginZoneList.AddItem ServerName + "(" + CStr(TotalPlayers) + ")"
End Sub

Public Sub ClearServers()
    MainFrm.LoginZoneList.Clear
    TotalServers = 0
End Sub

Public Function FindServer(ByVal ServerName As String) As Integer
    For I = Len(ServerName) To 1 Step -1
        If Mid(ServerName, I, 1) = "(" Then Exit For
    Next
    If I <= 1 Then Exit Function
    ServerName = Left(ServerName, I - 1)
    For I = 1 To TotalServers
        If ServerList(I).ServerName = ServerName Then FindServer = I: Exit Function
    Next
End Function

'Misc.

Public Sub ClearACKs()
    For L = 0 To 32767
        If ACKs(L) = 0 Then Exit For
        ACKs(L) = 0
    Next
End Sub

Public Sub DrawPacket(SendRecv As String, RawHex As String)
    S = "": For I = 1 To Len(RawHex)
        S = S + Hex(Asc(Mid(RawHex, I, 1))) + " "
    Next

    AddDebug "(" + SendRecv + ") " + S
End Sub

Public Function GetInteger(RawText As String) As Integer
    Call CopyMemory(I, ByVal RawText, 2)
    GetInteger = I
End Function

Public Function GetLong(RawText As String) As Long
    Call CopyMemory(L, ByVal RawText, 4)
    GetLong = L
End Function

Public Function GetString(L As Long) As String
    Call CopyMemory(ByVal S4, L, 4)
    GetString = S4
End Function

Public Function GetString2(I As Integer) As String
    Call CopyMemory(ByVal S2, I, 2)
    GetString2 = S2
End Function

Public Function FillZero(RawText As String, DesiredLength As Long) As String
    If DesiredLength <= Len(RawText) Then
        FillZero = RawText
    Else
        FillZero = RawText + String(DesiredLength - Len(RawText), Chr(0))
    End If
End Function

Public Function TrimZero(RawText As String) As String
    L = InStr(1, RawText, Chr(0))
    If L > 0 Then
        TrimZero = Left(RawText, InStr(1, RawText, Chr(0)) - 1)
    Else
        TrimZero = RawText
    End If
End Function

Public Sub AddDebug(mStr As String)
    DebugDialog.dOut = Right(DebugDialog.dOut, 10000) + vbNewLine + mStr
    DebugDialog.dOut.SelStart = 20000
End Sub

Public Sub UpdateTitle(mStr As String)
    Select Case WINDOW_STATE
        Case STATE.CHAT_WINDOW
            MainFrm.Caption = "SSChat (" + CStr(MainFrm.ChatUsers.ListCount) + " online) - " + mStr
        Case Else
            MainFrm.Caption = "SSChat - " + mStr
    End Select
End Sub

Public Sub ClipString(mStr As String)
    If Len(mStr) > 0 Then mStr = Left(mStr, Len(mStr) - 1)
End Sub
