Attribute VB_Name = "MERV_Flavors"
Option Explicit

'Player score changes

Public Sub HandleScoreChanges(BotID As Integer, PlayerID As Integer, KillerID As Integer)
On Error GoTo FlyPaper

    Dim B As Byte, I As Integer, I2 As Integer

    With BotList(BotID)
        If KillerID > -1 And .KillPrize > 0 Then
            PrivateMessage BotID, KillerID, "*prize #" + CStr(.KillPrize), 0
        End If
        If .AutoSpec > 0 And .AutoSpec <= .pList(PlayerID).Losses Then
            PrivateMessage BotID, PlayerID, "*spec", 0
            PrivateMessage BotID, PlayerID, "*spec", 0
        End If
        If .Bot_Type = ELIM_REF And .Bot_Enabled = 1 And .Bot_Status = STARTED Then
            Select Case .GameType
                Case ELIM_TYPE.Vanilla
                    If .pList(PlayerID).Losses >= .MaxDeaths Then
                        B = FindItem(BotID, .pList(PlayerID).SSName)
                        If B > 0 Then
                            PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " is out. " + CStr(.pList(PlayerID).Wins) + " wins " + CStr(.pList(PlayerID).Losses) + " losses", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            DelItem BotID, B
                            UpdateRank .pList(PlayerID).SSName, False, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                        End If
                    End If
                Case ELIM_TYPE.Race
                    If .pList(PlayerID).Wins >= .MaxDeaths Then
                        PublicMessage BotID, "*arena GAME OVER. Winner: " + .pList(PlayerID).SSName, 103
                        PublicMessage BotID, "*lock", 0
                        TeamMessage BotID, "You may enter", 0
                        BotList(BotID).Bot_Status = CHECK
                        UpdateRank .pList(PlayerID).SSName, True, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                    End If
                Case ELIM_TYPE.WBElim
                    If .pList(PlayerID).Losses >= .MaxDeaths Then
                        B = FindItem(BotID, .pList(PlayerID).SSName)
                        If B > 0 Then
                            PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " is out. " + CStr(.pList(PlayerID).Wins) + " wins " + CStr(.pList(PlayerID).Losses) + " losses", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            DelItem BotID, B
                            UpdateRank .pList(PlayerID).SSName, False, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                        End If
                    End If
                Case ELIM_TYPE.WBRace
                    If .pList(PlayerID).Wins >= .MaxDeaths Then
                        PublicMessage BotID, "*arena GAME OVER. Winner: " + .pList(PlayerID).SSName, 2
                        PublicMessage BotID, "*lock", 0
                        TeamMessage BotID, "You may enter", 0
                        BotList(BotID).LockShip = 0
                        BotList(BotID).Bot_Status = CHECK
                        UpdateRank .pList(PlayerID).SSName, True, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                    End If
                Case ELIM_TYPE.JavElim
                    If .pList(PlayerID).Losses >= .MaxDeaths Then
                        B = FindItem(BotID, .pList(PlayerID).SSName)
                        If B > 0 Then
                            PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " is out. " + CStr(.pList(PlayerID).Wins) + " wins " + CStr(.pList(PlayerID).Losses) + " losses", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            DelItem BotID, B
                            UpdateRank .pList(PlayerID).SSName, False, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                        End If
                    End If
                Case ELIM_TYPE.JavRace
                    If .pList(PlayerID).Wins >= .MaxDeaths Then
                        PublicMessage BotID, "*arena GAME OVER. Winner: " + .pList(PlayerID).SSName, 2
                        PublicMessage BotID, "*lock", 0
                        TeamMessage BotID, "You may enter", 0
                        BotList(BotID).LockShip = 0
                        BotList(BotID).Bot_Status = CHECK
                        UpdateRank .pList(PlayerID).SSName, True, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                    End If
                Case ELIM_TYPE.TeamElim
                    If .pList(PlayerID).Losses >= .MaxDeaths Then
                        B = FindItem(BotID, .pList(PlayerID).SSName)
                        If B > 0 Then
                            PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + "(" + CStr(.pList(PlayerID).Frequency) + ") is out. " + CStr(.pList(PlayerID).Wins) + " wins " + CStr(.pList(PlayerID).Losses) + " losses", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            PrivateMessage BotID, PlayerID, "*spec", 0
                            DelItem BotID, B
                            UpdateRank .pList(PlayerID).SSName, False, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                        End If
                    End If
                Case ELIM_TYPE.GolfElim
                    If KillerID > -1 Then
                        If .pList(KillerID).GamePoints < .MaxDeaths Then
                            .pList(KillerID).GamePoints = .pList(KillerID).GamePoints + 1
                        End If
                        .pList(PlayerID).GamePoints = .pList(PlayerID).GamePoints - 1
                        If .pList(PlayerID).GamePoints = 0 Then
                            PublicMessage BotID, "*arena " + .pList(KillerID).SSName + "(" + CStr(.pList(KillerID).GamePoints) + " +pts). " + .pList(PlayerID).SSName + " is out. " + CStr(.pList(PlayerID).Wins) + " wins " + CStr(.pList(PlayerID).Losses) + " losses", 0
                            B = FindItem(BotID, .pList(PlayerID).SSName)
                            If B > 0 Then
                                PrivateMessage BotID, PlayerID, "*spec", 0
                                PrivateMessage BotID, PlayerID, "*spec", 0
                                DelItem BotID, B
                                UpdateRank .pList(PlayerID).SSName, False, .pList(PlayerID).Wins, .pList(PlayerID).Losses
                            End If
                        Else
                            PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + "(" + CStr(.pList(PlayerID).GamePoints) + " -pts) kb " + .pList(KillerID).SSName + "(" + CStr(.pList(KillerID).GamePoints) + " +pts)", 0
                        End If
                    End If
            End Select

        ElseIf .Bot_Type = ZOMBIES_REF And .Bot_Status = STARTED And .Bot_Enabled = 1 Then
            B = FindItem(BotID, .pList(PlayerID).SSName)
            If B > 0 And KillerID > -1 Then
                Select Case Int(Rnd * 10)
                    Case 0: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " has been zombified! BrainZ!", 0
                    Case 1: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " has been zombified", 0
                    Case 2: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " was taken in by the dark side", 13
                    Case 3: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " has seen the benefits of an all-brain diet", 0
                    Case 4: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " seems a little green.. and thirsty for brains!", 0
                    Case 5: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " had his grey-matter feasted upon", 0
                    Case 6: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " is now one of the undead", 0
                    Case 7: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " was annexed by the zombie horde!", 0
                    Case 8: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " has become ""one with the zombie""", 0
                    Case 9: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + " strayed into zombie territory and was eatten", 0
                End Select
                PrivateMessage BotID, PlayerID, "*setfreq 1", 0
                DelItem BotID, B
            Else
                PrivateMessage BotID, PlayerID, "*shipreset", 0
            End If

        ElseIf .Bot_Type = CONQUER_REF And .Bot_Status = STARTED And .Bot_Enabled = 1 Then
            If KillerID > -1 Then ConquerPlayer BotID, PlayerID, KillerID

        ElseIf .Bot_Type = BOUNTYGAME_REF And .Bot_Enabled = 1 And KillerID > -1 Then
            If PlayerID = .BountyID Then
                Select Case Int(Rnd * 13)
                    Case 0: PublicMessage BotID, "*arena The BountyRabbit(tm) has struck again! Zone in panic! " + .pList(KillerID).SSName + " now at large! $5000 reward!", 25
                    Case 1: PublicMessage BotID, "*arena Hop. hop. hop. Another rabbit bit the dust. " + .pList(KillerID).SSName + " now holds the 5000 bounty!", 7
                    Case 2: PublicMessage BotID, "*arena " + .pList(PlayerID).SSName + "(old rabbit) kb " + .pList(KillerID).SSName + "(new rabbit with 5000 bounty)", 22
                    Case 3: PublicMessage BotID, "*arena Uh oh, " + .pList(KillerID).SSName + " is growing ears! He's contracted the BountyRabbit(tm) virus from " + .pList(PlayerID).SSName + "!", 13
                    Case 4: PublicMessage BotID, "*arena " + .pList(KillerID).SSName + " is now the BountyRabbit! Type ?target=5000 for a Big Light Blue indicator on your radar", 19
                    Case 5: PublicMessage BotID, "*arena " + .pList(KillerID).SSName + " has been rabbitified! Type ?time to check how much time is left until he wins", 20
                    Case 6: PublicMessage BotID, "*arena Another waskalie wabbit has been sighted: " + .pList(KillerID).SSName + ". And it's wabbit-hunting season!", 18
                    Case 7: PublicMessage BotID, "*arena " + .pList(KillerID).SSName + " has vanquished the villainous old rabbit! He has been granted a $5000 reward", 27
                    Case 8: PublicMessage BotID, "*arena A new bounty rabbit has been born and it ain't pretty! " + .pList(KillerID).SSName + " holds the sucker", 32
                    Case 9: PublicMessage BotID, "*arena Uh oh, " + .pList(KillerID).SSName + " is growing ears! He's contracted the BountyRabbit(tm) virus from " + .pList(PlayerID).SSName + "!", 4
                    Case 10: PublicMessage BotID, "*arena The BountyRabbit(tm) has struck again! Zone in panic! " + .pList(KillerID).SSName + " now at large! $5000 reward!", 17
                    Case 11: PublicMessage BotID, "*arena Zee rebbeet, " + .pList(KillerID).SSName + ", veell be-a in zee stoo suun inuoogh. $5000 preece-a teg", 21
                    Case 12: PublicMessage BotID, "*arena Psst! " + Mid(.pList(KillerID).SSName, 2) + Left(.pList(KillerID).SSName, 1) + "ay has ethay OuntyRabbitbay irusvay! Asspay it onyay!", 16
                End Select
                PublicMessage BotID, "*timereset", 0
                PublicMessage BotID, "*timer 10", 0
                .BountyID = KillerID
                If HasSysop Then
                    PrivateMessage BotID, KillerID, "*prize 5000", 0
                Else
                    For I = 1 To 50
                        PrivateMessage BotID, KillerID, "*prize 100", 0
                    Next
                End If
            End If

        End If

    End With

Exit Sub
FlyPaper:
    AddDebug BotID, "Error detected in HandleScoreChanges(): " + Err.Description, RED
    Resume Next
End Sub

'Player ship changes

Public Sub HandleShipChanges(BotID As Integer, PlayerID As Integer)
On Error GoTo FlyPaper

    Dim B As Byte, I As Integer, I2 As Integer

    If BotList(BotID).AutoSpec > 0 And BotList(BotID).AutoSpec <= BotList(BotID).pList(PlayerID).Losses And BotList(BotID).pList(PlayerID).ShipType < 8 Then
        PrivateMessage BotID, PlayerID, "*spec", 0
        PrivateMessage BotID, PlayerID, "*spec", 0
    End If

    If BotList(BotID).pList(PlayerID).ShipType < 8 And BotList(BotID).LockShip <> (BotList(BotID).pList(PlayerID).ShipType + 1) And BotList(BotID).LockShip > 0 Then
        PrivateMessage BotID, PlayerID, "*setship " + CStr(BotList(BotID).LockShip), 0
    End If

    If BotList(BotID).Bot_Enabled = 0 Then Exit Sub

    If BotList(BotID).Bot_Type = SWZ_REF Then
        With BotList(BotID).pList(PlayerID)
            Select Case .Frequency
                Case 0
                    Select Case .ShipType
                        Case 3
                            PrivateMessage BotID, PlayerID, "*setship 2", 0
                        Case 4
                            PrivateMessage BotID, PlayerID, "*setship 1", 0
                        Case 5
                            PrivateMessage BotID, PlayerID, "*setship 3", 0
                        Case 6
                            If FindItem(BotID, .SSName) = 0 Then
                                PrivateMessage BotID, PlayerID, "*setship " + CStr(Int(Rnd * 3) + 1), 0
                            Else
                                PrivateMessage BotID, PlayerID, "*setship 8", 0
                            End If
                        Case 7
                            If FindItem(BotID, .SSName) = 0 Then PrivateMessage BotID, PlayerID, "*setship " + CStr(Int(Rnd * 3) + 1), 0
                    End Select
                Case 1
                    Select Case .ShipType
                        Case 0
                            PrivateMessage BotID, PlayerID, "*setship 5", 0
                        Case 1
                            PrivateMessage BotID, PlayerID, "*setship 4", 0
                        Case 2
                            PrivateMessage BotID, PlayerID, "*setship 6", 0
                        Case 6
                            If FindItem(BotID, .SSName) = 0 Then PrivateMessage BotID, PlayerID, "*setship " + CStr(Int(Rnd * 3) + 4), 0
                        Case 7
                            If FindItem(BotID, .SSName) = 0 Then
                                PrivateMessage BotID, PlayerID, "*setship " + CStr(Int(Rnd * 3) + 4), 0
                            Else
                                PrivateMessage BotID, PlayerID, "*setship 7", 0
                            End If
                    End Select
            End Select
        End With

    ElseIf BotList(BotID).Bot_Type = DSB_REF Then
        With BotList(BotID).pList(PlayerID)
            Select Case .Frequency
                Case 0
                    Select Case .ShipType
                        Case 4
                            PrivateMessage BotID, PlayerID, "*setship 1", 0
                        Case 5
                            PrivateMessage BotID, PlayerID, "*setship 2", 0
                        Case 6
                            PrivateMessage BotID, PlayerID, "*setship 3", 0
                        Case 7
                            PrivateMessage BotID, PlayerID, "*setship 4", 0
                    End Select
                Case 1
                    Select Case .ShipType
                        Case 0
                            PrivateMessage BotID, PlayerID, "*setship 5", 0
                        Case 1
                            PrivateMessage BotID, PlayerID, "*setship 6", 0
                        Case 2
                            PrivateMessage BotID, PlayerID, "*setship 7", 0
                        Case 3
                            PrivateMessage BotID, PlayerID, "*setship 8", 0
                    End Select
            End Select
        End With

    ElseIf BotList(BotID).Bot_Type = ELIM_REF And BotList(BotID).Bot_Status = STARTED Then
        With BotList(BotID).pList(PlayerID)
            B = FindItem(BotID, .SSName)
            If B > 0 Then
                If .ShipType = 8 Then
                    DelItem BotID, B
                    UpdateRank .SSName, False, .Wins, .Losses
'                ElseIf BotList(BotID).GameType >= ELIM_TYPE.JavElim And BotList(BotID).GameType <= ELIM_TYPE.JavRace And .ShipType <> 1 Then
'                    PrivateMessage BotID, PlayerID, "*setship 2", 0
'                    Exit Sub
'                ElseIf BotList(BotID).GameType >= ELIM_TYPE.WBElim And BotList(BotID).GameType <= ELIM_TYPE.WBRace And .ShipType <> 0 Then
'                    PrivateMessage BotID, PlayerID, "*setship 1", 0
'                    Exit Sub
                ElseIf BotList(BotID).GameType = ELIM_TYPE.TeamElim And .Frequency > 1 Then
                    DelItem BotID, B
                    UpdateRank .SSName, False, .Wins, .Losses
                    PrivateMessage BotID, PlayerID, "*spec", 0
                    PrivateMessage BotID, PlayerID, "*spec", 0
                End If
            Else
                If .ShipType < 8 Then
                    PrivateMessage BotID, PlayerID, "*spec", 0
                    PrivateMessage BotID, PlayerID, "*spec", 0
                End If
            End If
        End With

    ElseIf BotList(BotID).Bot_Type = ZOMBIES_REF And BotList(BotID).Bot_Status = STARTED Then
        With BotList(BotID).pList(PlayerID)
            B = FindItem(BotID, .SSName)
            If B > 0 Then
                If .Frequency = 1 Or .ShipType = 8 Then DelItem BotID, B
            Else
                If .Frequency = 0 And .ShipType < 8 Then
                    PrivateMessage BotID, PlayerID, "*setfreq 1", 0
                End If
            End If
        End With

    ElseIf BotList(BotID).Bot_Type = CONQUER_REF And BotList(BotID).Bot_Status = STARTED Then
        ConquerCheckFreq BotID, PlayerID

    ElseIf BotList(BotID).Bot_Type = BOUNTYGAME_REF And BotList(BotID).BountyID = PlayerID Then
        If BotList(BotID).pList(PlayerID).ShipType < 8 Then
            If HasSysop Then
                PrivateMessage BotID, PlayerID, "*prize 5000", 0
            Else
                For I = 1 To 50
                    PrivateMessage BotID, PlayerID, "*prize 100", 0
                Next
            End If
        Else
            NewRabbit BotID, True
        End If

    End If

Exit Sub
FlyPaper:
    AddDebug BotID, "Error detected in HandleShipChanges(): " + Err.Description, RED
    Resume Next
End Sub

'Player commands

Public Sub HandleCommand(BotID As Integer, PlayerID As Integer, ByVal Command As String)
    Dim B As Byte, a As ALLOW

    Command = Trim(Command)

    B = BotList(BotID).pList(PlayerID).OpID
    If B = 0 Then
        a = OP_PUBLIC
    Else
        a = OpList(B).OperatorStatus
    End If

    If HandleGeneral(BotID, PlayerID, a, Command) Then
        Select Case BotList(BotID).Bot_Type
            Case BOT_FLAVORS.DSB_REF:        Call HandleDSB(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.ELIM_REF:       Call HandleELIM(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.ALIAS_REF:      Call HandleALIAS(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.SWZ_REF:        Call HandleSWZ(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.ZOMBIES_REF:    Call HandleZOMBIES(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.CONQUER_REF:    Call HandleCONQUER(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.BOUNTYGAME_REF: Call HandleBTY(BotID, PlayerID, a, Command)
            Case BOT_FLAVORS.SARUNOKAMI_REF: Call HandleSarunokami(BotID, PlayerID, a, Command)
        End Select
    End If
End Sub

'Sarunokaminorobotto! (Monkey God Bot)

Private Sub HandleSarunokami(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim O As String, I As Integer

    Select Case OpLevel
        Case ALLOW.OP_ACCOUNT
            If Left(Command, 5) = "!rate" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 3))
                If I >= 1 And I <= 120 Then
                    PrivateMessage BotID, PlayerID, "Now monkeying around at a rate of " + CStr(I) + " seconds between changes", 0
                    BotList(BotID).TimerMax = CByte(I)
                Else
                    PrivateMessage BotID, PlayerID, "Format: !rate <1-120>", 0
                End If
            End If
        Case ALLOW.OP_SUPER
            If Left(Command, 5) = "!rate" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 3))
                If I >= 1 And I <= 120 Then
                    PrivateMessage BotID, PlayerID, "Now monkeying around at a rate of " + CStr(I) + " seconds between changes", 0
                    BotList(BotID).TimerMax = CByte(I)
                Else
                    PrivateMessage BotID, PlayerID, "Format: !rate <1-120>", 0
                End If
            ElseIf Command = "!reset" Then
                PublicMessage BotID, "*arena NOTICE: Server settings resetting to normal...", 2
                ResetSettings BotID
            End If
    End Select
End Sub

'Bounty Game

Private Sub HandleBTY(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim O As String, I As Integer

    Select Case OpLevel
        Case ALLOW.OP_SIMPLE: If Command = "!newpick" Then NewRabbit BotID, True
        Case ALLOW.OP_ACCOUNT: If Command = "!newpick" Then NewRabbit BotID, True
        Case ALLOW.OP_SUPER: If Command = "!newpick" Then NewRabbit BotID, True
    End Select
End Sub

'DSB Ship-checking

Private Sub HandleDSB(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim B As Byte, B2 As Byte

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
        Case ALLOW.OP_SIMPLE
        Case ALLOW.OP_ACCOUNT
        Case ALLOW.OP_SUPER
    End Select
End Sub

'ElimRef commands

Private Sub HandleELIM(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim B As Byte, B2 As Byte

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
            If Command = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(BotList(BotID).pList(PlayerID).SSName), 0
            ElseIf Left(Command, 5) = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(LTrim(Mid(Command, 6))), 0
            End If
        Case ALLOW.OP_SIMPLE
            If Command = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(BotList(BotID).pList(PlayerID).SSName), 0
            ElseIf Left(Command, 5) = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(LTrim(Mid(Command, 6))), 0
            ElseIf Left(Command, 6) = "!force" Then
                If BotList(BotID).Bot_Status = WAIT_AFTER_RESULTS Then
                    B = Val(Mid(Command, 8, 1))
                    B2 = Val(Mid(Command, 10, 2))
                    If B < 1 Or B > 8 Then
                        PrivateMessage BotID, PlayerID, "Invalid game tag. Choices: 1-Elim,2-Race,3-WBElim,4-WBRace,5-JavElim,6-JavRace,7-TeamElim, 8-Golf", 0
                    ElseIf B2 < 1 Or B2 > 10 Then
                        PrivateMessage BotID, PlayerID, "Invalid number of kllls/deaths. Choices: Any number from 1-10", 0
                    Else
                        Select Case B
                            Case ELIM_TYPE.Vanilla: PublicMessage BotID, "*arena FORCED: Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.Race: PublicMessage BotID, "*arena FORCED: Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBElim: PublicMessage BotID, "*arena FORCED: Warbird Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBRace: PublicMessage BotID, "*arena FORCED: Warbird Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavElim: PublicMessage BotID, "*arena FORCED: Javelin Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavRace: PublicMessage BotID, "*arena FORCED: Javelin Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.TeamElim: PublicMessage BotID, "*arena FORCED: Team Elim to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.GolfElim: PublicMessage BotID, "*arena FORCED: Golf with a maximum of " + CStr(B2) + " point(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                        End Select
                        BotList(BotID).GameType = B
                        BotList(BotID).MaxDeaths = B2
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Oops: !force <game> <kills> can only be used during the 10 second wait period", 0
                End If
            End If
        Case ALLOW.OP_ACCOUNT
            If Command = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(BotList(BotID).pList(PlayerID).SSName), 0
            ElseIf Left(Command, 5) = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(LTrim(Mid(Command, 6))), 0
            ElseIf Left(Command, 6) = "!force" Then
                If BotList(BotID).Bot_Status = WAIT_AFTER_RESULTS Then
                    B = Val(Mid(Command, 8, 1))
                    B2 = Val(Mid(Command, 10, 2))
                    If B < 1 Or B > 8 Then
                        PrivateMessage BotID, PlayerID, "Invalid game tag. Choices: 1-Elim,2-Race,3-WBElim,4-WBRace,5-JavElim,6-JavRace,7-TeamElim, 8-Golf", 0
                    ElseIf B2 < 1 Or B2 > 10 Then
                        PrivateMessage BotID, PlayerID, "Invalid number of kllls/deaths. Choices: Any number from 1-10", 0
                    Else
                        Select Case B
                            Case ELIM_TYPE.Vanilla: PublicMessage BotID, "*arena FORCED: Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.Race: PublicMessage BotID, "*arena FORCED: Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBElim: PublicMessage BotID, "*arena FORCED: Warbird Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBRace: PublicMessage BotID, "*arena FORCED: Warbird Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavElim: PublicMessage BotID, "*arena FORCED: Javelin Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavRace: PublicMessage BotID, "*arena FORCED: Javelin Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.TeamElim: PublicMessage BotID, "*arena FORCED: Team Elim to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.GolfElim: PublicMessage BotID, "*arena FORCED: Golf with a maximum of " + CStr(B2) + " point(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                        End Select
                        BotList(BotID).GameType = B
                        BotList(BotID).MaxDeaths = B2
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Oops: !force <game> <kills> can only be used during the 10 second wait period", 0
                End If
            End If
        Case ALLOW.OP_SUPER
            If Command = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(BotList(BotID).pList(PlayerID).SSName), 0
            ElseIf Left(Command, 5) = "!rank" Then
                PrivateMessage BotID, PlayerID, "Rank: " + GetRankString(LTrim(Mid(Command, 6))), 0
            ElseIf Left(Command, 6) = "!force" Then
                If BotList(BotID).Bot_Status = WAIT_AFTER_RESULTS Then
                    B = Val(Mid(Command, 8, 1))
                    B2 = Val(Mid(Command, 10, 2))
                    If B < 1 Or B > 8 Then
                        PrivateMessage BotID, PlayerID, "Invalid game tag. Choices: 1-Elim,2-Race,3-WBElim,4-WBRace,5-JavElim,6-JavRace,7-TeamElim, 8-Golf", 0
                    ElseIf B2 < 1 Or B2 > 10 Then
                        PrivateMessage BotID, PlayerID, "Invalid number of kllls/deaths. Choices: Any number from 1-10", 0
                    Else
                        Select Case B
                            Case ELIM_TYPE.Vanilla: PublicMessage BotID, "*arena FORCED: Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.Race: PublicMessage BotID, "*arena FORCED: Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBElim: PublicMessage BotID, "*arena FORCED: Warbird Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.WBRace: PublicMessage BotID, "*arena FORCED: Warbird Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavElim: PublicMessage BotID, "*arena FORCED: Javelin Elimination to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.JavRace: PublicMessage BotID, "*arena FORCED: Javelin Race to " + CStr(B2) + " kill(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.TeamElim: PublicMessage BotID, "*arena FORCED: Team Elim to " + CStr(B2) + " death(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                            Case ELIM_TYPE.GolfElim: PublicMessage BotID, "*arena FORCED: Golf with a maximum of " + CStr(B2) + " point(s) by " + BotList(BotID).pList(PlayerID).SSName, 3
                        End Select
                        BotList(BotID).GameType = B
                        BotList(BotID).MaxDeaths = B2
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Oops: !force <game> <kills> can only be used during the 10 second wait period", 0
                End If
            End If
    End Select
End Sub

'ZombieRef commands

Private Sub HandleZOMBIES(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
        Case ALLOW.OP_SIMPLE
        Case ALLOW.OP_ACCOUNT
        Case ALLOW.OP_SUPER
    End Select
End Sub

'Alias-finder commands

Private Sub HandleALIAS(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim O As String, I As Integer

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
        Case ALLOW.OP_SIMPLE
            If Left(Command, 6) = "!alias" Then
                O = FindAliases(LTrim(Mid(Command, 7)))
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No aliases", 0
                Else
                    For I = 1 To Len(O) Step 83
                        PrivateMessage BotID, PlayerID, "Alias: " + Mid(O, I, 83), 0
                    Next
                End If
            End If
        Case ALLOW.OP_ACCOUNT
            If Left(Command, 6) = "!alias" Then
                O = FindAliases(LTrim(Mid(Command, 7)))
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No aliases", 0
                Else
                    For I = 1 To Len(O) Step 83
                        PrivateMessage BotID, PlayerID, "Alias: " + Mid(O, I, 83), 0
                    Next
                End If
            End If
        Case ALLOW.OP_SUPER
            If Left(Command, 6) = "!alias" Then
                O = FindAliases(LTrim(Mid(Command, 7)))
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No aliases", 0
                Else
                    For I = 1 To Len(O) Step 83
                        PrivateMessage BotID, PlayerID, "Alias: " + Mid(O, I, 83), 0
                    Next
                End If
            End If
    End Select
End Sub

'SWZ Ship-checker commands

Private Sub HandleSWZ(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim I As Integer, O As String, B As Byte

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
            If Command = "!listcaps" Then
                O = GetItemList(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No capital ships", 0
                Else
                    For I = 1 To Len(O) Step 84
                        PrivateMessage BotID, PlayerID, "Caps: " + Mid(O, I, 84), 0
                    Next
                End If
            End If
        Case ALLOW.OP_SIMPLE
            If Command = "!yellcaps" Then
                For I = 1 To TotalItems(BotID)
                    O = O + SharedList(BotID, I) + ", "
                Next
                If O = "" Then
                    PublicMessage BotID, "*arena No capital ships", 1
                Else
                    O = Left(O, Len(O) - 2)
                    For I = 1 To Len(O) Step 60
                        PublicMessage BotID, "*arena Capital Ships: " + Mid(O, I, 60), 2
                    Next
                End If
            ElseIf Left(Command, 5) = "!info" Then
                I = FindUser(BotID, Mid(Command, 7))
                With BotList(BotID).pList(I)
                    If I > -1 Then
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    Else
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " not online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    End If
                End With
            ElseIf Left(Command, 4) = "!cap" Then
                B = FindItem(BotID, Mid(Command, 6))
                If B > 0 Then
                    PrivateMessage BotID, PlayerID, "Add: " + SharedList(BotID, B) + " is already a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Add: " + Mid(Command, 6) + " added as a capital ship", 0
                    AddItem BotID, Mid(Command, 6)
                    I = FindUser(BotID, Mid(Command, 6))
                    If I > -1 Then PrivateMessage BotID, I, "You are now a capital ship", 0
                End If
            ElseIf Left(Command, 5) = "!dcap" Then
                B = FindItem(BotID, Mid(Command, 7))
                If B = 0 Then
                    PrivateMessage BotID, PlayerID, "Remove: " + Mid(Command, 7) + " is not a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Remove: " + SharedList(BotID, B) + " stripped of capital ship status", 0
                    DelItem BotID, B
                End If
            ElseIf Command = "!listcaps" Then
                O = GetItemList(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No capital ships", 0
                Else
                    For I = 1 To Len(O) Step 84
                        PrivateMessage BotID, PlayerID, "Caps: " + Mid(O, I, 84), 0
                    Next
                End If
            End If
        Case ALLOW.OP_ACCOUNT
            If Command = "!yellcaps" Then
                For I = 1 To TotalItems(BotID)
                    O = O + SharedList(BotID, I) + ", "
                Next
                If O = "" Then
                    PublicMessage BotID, "*arena No capital ships", 1
                Else
                    O = Left(O, Len(O) - 2)
                    For I = 1 To Len(O) Step 60
                        PublicMessage BotID, "*arena Capital Ships: " + Mid(O, I, 60), 2
                    Next
                End If
            ElseIf Left(Command, 5) = "!info" Then
                I = FindUser(BotID, Mid(Command, 7))
                With BotList(BotID).pList(I)
                    If I > -1 Then
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    Else
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " not online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    End If
                End With
            ElseIf Left(Command, 4) = "!cap" Then
                B = FindItem(BotID, Mid(Command, 6))
                If B > 0 Then
                    PrivateMessage BotID, PlayerID, "Add: " + SharedList(BotID, B) + " is already a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Add: " + Mid(Command, 6) + " added as a capital ship", 0
                    AddItem BotID, Mid(Command, 6)
                    I = FindUser(BotID, Mid(Command, 6))
                    If I > -1 Then PrivateMessage BotID, I, "You are now a capital ship", 0
                End If
            ElseIf Left(Command, 5) = "!dcap" Then
                B = FindItem(BotID, Mid(Command, 7))
                If B = 0 Then
                    PrivateMessage BotID, PlayerID, "Remove: " + Mid(Command, 7) + " is not a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Remove: " + SharedList(BotID, B) + " stripped of capital ship status", 0
                    DelItem BotID, B
                End If
            ElseIf Command = "!listcaps" Then
                O = GetItemList(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No capital ships", 0
                Else
                    For I = 1 To Len(O) Step 84
                        PrivateMessage BotID, PlayerID, "Caps: " + Mid(O, I, 84), 0
                    Next
                End If
            End If
        Case ALLOW.OP_SUPER
            If Command = "!yellcaps" Then
                For I = 1 To TotalItems(BotID)
                    O = O + SharedList(BotID, I) + ", "
                Next
                If O = "" Then
                    PublicMessage BotID, "*arena No capital ships", 1
                Else
                    O = Left(O, Len(O) - 2)
                    For I = 1 To Len(O) Step 60
                        PublicMessage BotID, "*arena Capital Ships: " + Mid(O, I, 60), 2
                    Next
                End If
            ElseIf Left(Command, 4) = "!cap" Then
                B = FindItem(BotID, Mid(Command, 6))
                If B > 0 Then
                    PrivateMessage BotID, PlayerID, "Add: " + SharedList(BotID, B) + " is already a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Add: " + Mid(Command, 6) + " added as a capital ship", 0
                    AddItem BotID, Mid(Command, 6)
                    I = FindUser(BotID, Mid(Command, 6))
                    If I > -1 Then PrivateMessage BotID, I, "You are now a capital ship", 0
                End If
            ElseIf Left(Command, 5) = "!info" Then
                I = FindUser(BotID, Mid(Command, 7))
                With BotList(BotID).pList(I)
                    If I > -1 Then
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    Else
                        PrivateMessage BotID, PlayerID, "Info: " + .SSName + " not online. Capped " + CStr(GetTotal(.SSName)) + " total times; " + CStr(GetCount(.SSName)) + " today", 0
                    End If
                End With
            ElseIf Left(Command, 5) = "!dcap" Then
                B = FindItem(BotID, Mid(Command, 7))
                If B = 0 Then
                    PrivateMessage BotID, PlayerID, "Remove: " + Mid(Command, 7) + " is not a capital ship", 0
                Else
                    PrivateMessage BotID, PlayerID, "Remove: " + SharedList(BotID, B) + " stripped of capital ship status", 0
                    DelItem BotID, B
                End If
            ElseIf Command = "!listcaps" Then
                O = GetItemList(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No capital ships", 0
                Else
                    For I = 1 To Len(O) Step 84
                        PrivateMessage BotID, PlayerID, "Caps: " + Mid(O, I, 84), 0
                    Next
                End If
            End If
    End Select
End Sub

'ConquerRef

Private Sub HandleCONQUER(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String)
    Dim O As String, I As Integer, X As Integer, Y As Integer, Found As Boolean

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
            If Left(Command, 6) = "!owner" Then
                O = LCase(LTrim(Mid(Command, 7)))
                If IsNumeric(O) Then
                    For I = 1 To TotalFreqs(BotID)
                        If Conquer(BotID, I).Frequency = Val(Left(O, 4)) Then
                            PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, I), 0
                        End If
                    Next
                ElseIf O = "" Then
                    For I = 1 To TotalFreqs(BotID)
                        For Y = 1 To Conquer(BotID, I).TotalCurrent
                            If Conquer(BotID, I).CurrentPlayers(Y) = PlayerID Then
                                PrivateMessage BotID, PlayerID, "Your owner is " + GetFreq(BotID, I), 0
                            End If
                        Next
                    Next
                Else
                    For I = 0 To MAX_PLAYERS
                        If LCase(BotList(BotID).pList(I).SSName) = O Then
                            Found = True
                        End If
                    Next
                    If Not Found Then
                        PrivateMessage BotID, PlayerID, "Unknown player", 0
                    Else
                        For X = 1 To TotalFreqs(BotID)
                            For Y = 1 To Conquer(BotID, X).TotalCurrent
                                If Conquer(BotID, X).CurrentPlayers(Y) = I Then
                                    PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, X), 0
                                End If
                            Next
                        Next
                    End If
                End If
            End If
        Case ALLOW.OP_SIMPLE
            If Left(Command, 6) = "!owner" Then
                O = LCase(LTrim(Mid(Command, 7)))
                If IsNumeric(O) Then
                    For I = 1 To TotalFreqs(BotID)
                        If Conquer(BotID, I).Frequency = Val(Left(O, 4)) Then
                            PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, I), 0
                        End If
                    Next
                ElseIf O = "" Then
                    For I = 1 To TotalFreqs(BotID)
                        For Y = 1 To Conquer(BotID, I).TotalCurrent
                            If Conquer(BotID, I).CurrentPlayers(Y) = PlayerID Then
                                PrivateMessage BotID, PlayerID, "Your owner is " + GetFreq(BotID, I), 0
                            End If
                        Next
                    Next
                Else
                    For I = 0 To MAX_PLAYERS
                        If LCase(BotList(BotID).pList(I).SSName) = O Then
                            Found = True
                        End If
                    Next
                    If Not Found Then
                        PrivateMessage BotID, PlayerID, "Unknown player", 0
                    Else
                        For X = 1 To TotalFreqs(BotID)
                            For Y = 1 To Conquer(BotID, X).TotalCurrent
                                If Conquer(BotID, X).CurrentPlayers(Y) = I Then
                                    PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, X), 0
                                End If
                            Next
                        Next
                    End If
                End If
            End If
        Case ALLOW.OP_ACCOUNT
            If Left(Command, 6) = "!owner" Then
                O = LCase(LTrim(Mid(Command, 7)))
                If IsNumeric(O) Then
                    For I = 1 To TotalFreqs(BotID)
                        If Conquer(BotID, I).Frequency = Val(Left(O, 4)) Then
                            PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, I), 0
                        End If
                    Next
                ElseIf O = "" Then
                    For I = 1 To TotalFreqs(BotID)
                        For Y = 1 To Conquer(BotID, I).TotalCurrent
                            If Conquer(BotID, I).CurrentPlayers(Y) = PlayerID Then
                                PrivateMessage BotID, PlayerID, "Your owner is " + GetFreq(BotID, I), 0
                            End If
                        Next
                    Next
                Else
                    For I = 0 To MAX_PLAYERS
                        If LCase(BotList(BotID).pList(I).SSName) = O Then
                            Found = True
                        End If
                    Next
                    If Not Found Then
                        PrivateMessage BotID, PlayerID, "Unknown player", 0
                    Else
                        For X = 1 To TotalFreqs(BotID)
                            For Y = 1 To Conquer(BotID, X).TotalCurrent
                                If Conquer(BotID, X).CurrentPlayers(Y) = I Then
                                    PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, X), 0
                                End If
                            Next
                        Next
                    End If
                End If
            End If
        Case ALLOW.OP_SUPER
            If Left(Command, 6) = "!owner" Then
                O = LCase(LTrim(Mid(Command, 7)))
                If IsNumeric(O) Then
                    For I = 1 To TotalFreqs(BotID)
                        If Conquer(BotID, I).Frequency = Val(Left(O, 4)) Then
                            PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, I), 0
                        End If
                    Next
                ElseIf O = "" Then
                    For I = 1 To TotalFreqs(BotID)
                        For Y = 1 To Conquer(BotID, I).TotalCurrent
                            If Conquer(BotID, I).CurrentPlayers(Y) = PlayerID Then
                                PrivateMessage BotID, PlayerID, "Your owner is " + GetFreq(BotID, I), 0
                            End If
                        Next
                    Next
                Else
                    For I = 0 To MAX_PLAYERS
                        If LCase(BotList(BotID).pList(I).SSName) = O Then
                            Found = True
                        End If
                    Next
                    If Not Found Then
                        PrivateMessage BotID, PlayerID, "Unknown player", 0
                    Else
                        For X = 1 To TotalFreqs(BotID)
                            For Y = 1 To Conquer(BotID, X).TotalCurrent
                                If Conquer(BotID, X).CurrentPlayers(Y) = I Then
                                    PrivateMessage BotID, PlayerID, "Owner is " + GetFreq(BotID, X), 0
                                End If
                            Next
                        Next
                    End If
                End If
            End If
    End Select
End Sub

'General, all-purpose bot commands

Private Function HandleGeneral(BotID As Integer, PlayerID As Integer, OpLevel As ALLOW, Command As String) As Boolean
With BotList(BotID)

On Error GoTo FlyPaper

    Dim I As Integer, O As String, B As Byte

    If Left(Command, 5) = "!help" Then SendHelp BotID, PlayerID, OpLevel, Command: Exit Function

    Select Case OpLevel
        Case ALLOW.OP_PUBLIC
            If Command = "!listops" Or Command = "!listop" Or Command = "!oplist" Then
                O = GetOpList(True)

                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No online operators", 0
                Else
                    For I = 1 To Len(O) Step 85
                        PrivateMessage BotID, PlayerID, "Ops: " + Mid(O, I, 85), 0
                    Next
                End If

            ElseIf Command = "!lag" Then
                PrivateMessage BotID, PlayerID, "PING Current:" + CStr(.PingTime) + " ms  Average:" + CStr(.AvgPing) + "ms  C2S:" + Str(Round(.TotalLost / .TotalReliable, 2)) + "%", 0

            ElseIf Command = "!status" Then
                O = GetState(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No status to report", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!rules" Then
                O = GetRules(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "This 'ref has no special game rules", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!quit" Or Command = "!exit" Or Command = "!leave" Or Command = "!bye" Then
                If .Suicide = 1 Then
                    If .pList(PlayerID).ShipType < 8 Then
                        PrivateMessage BotID, PlayerID, "*spec", 0
                        PrivateMessage BotID, PlayerID, "Good bye. Come back soon", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Suiciding is disabled by zone staff", 0
                End If

            Else
                HandleGeneral = True

            End If

        Case ALLOW.OP_SIMPLE
            If Command = "!listops" Or Command = "!listop" Or Command = "!oplist" Then
                O = GetOpList(False)

                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No operators", 0
                Else
                    For I = 1 To Len(O) Step 85
                        PrivateMessage BotID, PlayerID, "Ops: " + Mid(O, I, 85), 0
                    Next
                End If

            ElseIf Command = "!status" Then
                O = GetState(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No status to report", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!rules" Then
                O = GetRules(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "This 'ref has no special game rules", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!quit" Or Command = "!exit" Or Command = "!leave" Or Command = "!bye" Then
                If .Suicide = 1 Then
                    If .pList(PlayerID).ShipType < 8 Then
                        PrivateMessage BotID, PlayerID, "*spec", 0
                        PrivateMessage BotID, PlayerID, "Good bye. Come back soon", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Suiciding is disabled by zone staff", 0
                End If

            ElseIf Left(Command, 10) = "!eventeams" Then
                Select Case Val(LTrim(Mid(Command, 11, 2)))
                    Case Is < 0
                        PrivateMessage BotID, PlayerID, "Invalid parameter. 0 to disable, 1-255 for number of players to trigger on", 0
                    Case Is = 0
                        If .EvenTeams = 0 Then
                            PrivateMessage BotID, PlayerID, "Team-evening already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Team-evening disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                            PrivateMessage BotID, PlayerID, "Team-evening disabled", 0
                            .EvenTeams = 0
                        End If
                    Case Is <= 10
                        B = Val(LTrim(Mid(Command, 11, 2)))
                        If .EvenTeams = B Then
                            PrivateMessage BotID, PlayerID, "Team-evening already using that number of players to trigger on", 0
                        Else
                            If .EvenTeams = 0 Then
                                PublicMessage BotID, "*arena Team-evening enabled allowing a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            Else
                                PublicMessage BotID, "*arena Team-evening now allows a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            End If
                            PrivateMessage BotID, PlayerID, "Team-evening enabled", 0
                            .EvenTeams = B
                        End If
                    Case Is > 10
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Format: !eventeams <off,1-10>", 0
                End Select

            ElseIf Command = "!lag" Then
                PrivateMessage BotID, PlayerID, "PING Current:" + CStr(.PingTime) + " ms  Average:" + CStr(.AvgPing) + "ms  C2S:" + Str(Round(.TotalLost / .TotalReliable, 2)) + "%  Accuracy:" + CStr(.TotalPings), 0

            ElseIf Command = "!enable" Then
                If .Bot_Enabled = 1 Then
                    PrivateMessage BotID, PlayerID, "Already enabled", 0
                Else
                    Select Case .Bot_Type
                        Case BOT_FLAVORS.ALIAS_REF
                        Case BOT_FLAVORS.ELIM_REF
                            If IsPublicArena(.ArenaName) Then
                                PrivateMessage BotID, PlayerID, "Enable: " + .MyName + " cannot be enabled in public arenas", 0
                            Else
                                .Bot_Status = CHECK
                                .Bot_Enabled = 1
                                PublicMessage BotID, "*arena " + .MyName + "(ElimRef) enabled by " + .pList(PlayerID).SSName, 2
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                            End If
                        Case Else
                            If .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "The bot is busy. Try again in 30 seconds", 0
                            ElseIf .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "Monkey god bot requires sysop to edit settings", 0
                            Else
                                .Bot_Enabled = 1
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                PublicMessage BotID, "*arena " + .MyName + "(" + GetTypeString(.Bot_Type) + ") enabled by " + .pList(PlayerID).SSName, 2
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                                Select Case .Bot_Type
                                    Case BOT_FLAVORS.CONQUER_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.ZOMBIES_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.SARUNOKAMI_REF
                                        PublicMessage BotID, "?set Security:SecurityKickoff:0", 0
                                        DownloadSettings BotID
                                    Case BOT_FLAVORS.BOUNTYGAME_REF
                                        NewRabbit BotID, True
                                End Select
                            End If
                    End Select
                End If

            ElseIf Command = "!disable" Then
                If .Bot_Type = ALIAS_REF Then
                    Exit Function
                ElseIf .Bot_Enabled = 0 Then
                    PrivateMessage BotID, PlayerID, "Already disabled", 0
                Else
                    If .Bot_Type = BOUNTYGAME_REF Then PublicMessage BotID, "*timereset", 0
                    If .Bot_Type = CONQUER_REF Or .Bot_Type = ELIM_REF Then
                        If .Bot_Status = STARTED Then PublicMessage BotID, "*lock", 0
                    End If
                    .Bot_Enabled = 0
                    PrivateMessage BotID, PlayerID, "Disabled", 0
                    PublicMessage BotID, "*arena" + .MyName + "(" + GetTypeString(.Bot_Type) + ") disabled by " + .pList(PlayerID).SSName, 1
                    AddDebug BotID, "Disabled by " + .pList(PlayerID).SSName, YELLOW
                End If

            ElseIf Left(Command, 5) = "!door" Then
                If HasSysop Then
                    I = Val(Mid(LTrim(Command), 6, 4))
                    If I >= 0 And I <= 255 Then
                        PublicMessage BotID, "?set Door:DoorMode:" + CStr(I), 0
                        PrivateMessage BotID, PlayerID, "Door:DoorMode changed to " + CStr(I), 0
                    Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Choices: Any number from 0 to 255", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "DoorMode changing cannot be used unless the bot has SysOp access", 0
                End If

            ElseIf Left(Command, 5) = "!ship" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 1))
                If I >= 0 And I <= 8 Then
                    If I = 0 Then
                        If .LockShip = 0 Then
                            PrivateMessage BotID, PlayerID, "ShipLock already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Any ship may now be used. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "ShipLock disabled", 0
                            .LockShip = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "ShipLock already set to " + CStr(I), 0
                        Else
                            PublicMessage BotID, "*arena Only ship #" + CStr(I) + " ( " + ShipNames(I) + " ) is allowed. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "ShipLock set to " + CStr(I), 0
                            .LockShip = I
                            B = I - 1
                            For I = 0 To MAX_PLAYERS
                                If .pList(I).SSName <> "" And .pList(I).ShipType <> B Then
                                    PrivateMessage BotID, I, "*setship " + CStr(B + 1), 0
                                End If
                            Next
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !ship <no,1-8>", 0
                End If

            ElseIf Left(Command, 5) = "!spec" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 2))
                If I >= 0 And I <= 10 Then
                    If I = 0 Then
                        If .LockShip = 0 Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Death restrictions are lifted. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec disabled", 0
                            .AutoSpec = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already set to " + CStr(I), 0
                        Else
                            PublicMessage BotID, "*arena Removing players on " + CStr(I) + " deaths. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec set to " + CStr(I), 0
                            .AutoSpec = I
                            B = I - 1
                            For I = 0 To MAX_PLAYERS
                                If .pList(I).SSName <> "" And .pList(I).Losses >= B Then
                                    PrivateMessage BotID, I, "*spec", 0
                                    PrivateMessage BotID, I, "*spec", 0
                                End If
                            Next
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !spec <no,1-10>", 0
                End If

            ElseIf Left(Command, 10) = "!advertise" Then
                PublicMessage BotID, "*zone " + LTrim(Mid(Command, 11)) + "  -" + .pList(PlayerID).SSName, 0

            ElseIf Left(Command, 8) = "!suicide" Then
                Select Case LCase(LTrim(Mid(Command, 9)))
                    Case "on"
                        If .Suicide = 1 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already allowed", 0
                        Else
                            .Suicide = 1
                            PrivateMessage BotID, PlayerID, "Player suicide allowed", 0
                            PublicMessage BotID, "*arena Player suicide allowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                        End If
                    Case "off"
                        If .Suicide = 0 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already disallowed", 0
                        Else
                            .Suicide = 0
                            PrivateMessage BotID, PlayerID, "Player suicide disallowed", 0
                            PublicMessage BotID, "*arena Player suicide disallowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter: !suicide <on/off>", 0
                End Select

            Else
                HandleGeneral = True

            End If

        Case ALLOW.OP_ACCOUNT
            If Command = "!listops" Or Command = "!listop" Or Command = "!oplist" Then
                O = GetOpList(False)

                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No operators", 0
                Else
                    For I = 1 To Len(O) Step 85
                        PrivateMessage BotID, PlayerID, "Ops: " + Mid(O, I, 85), 0
                    Next
                End If

            ElseIf Command = "!status" Then
                O = GetState(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No status to report", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!rules" Then
                O = GetRules(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "This 'ref has no special game rules", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Left(Command, 10) = "!killprize" Then
                I = Val(LTrim(Mid(Command, 11, 4)))
                If I > -1 And I <= 28 Then
                    If I = 0 Then
                        PrivateMessage BotID, PlayerID, "Kill prize disabled", 0
                        If .KillPrize > 0 Then PublicMessage BotID, "*arena Kill prize disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                        .KillPrize = 0
                    Else
                        PrivateMessage BotID, PlayerID, "Kill prize changed to " + PrizeNames(I), 0
                        PublicMessage BotID, "*arena Kill prize changed to " + PrizeNames(I) + " by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                        .KillPrize = I
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Invalid prize number. Choices: <No, 1 to 28>", 0
                End If

            ElseIf Left(Command, 5) = "!door" Then
                If HasSysop Then
                    I = Val(Mid(LTrim(Command), 6, 4))
                    If I >= 0 And I <= 255 Then
                        PublicMessage BotID, "?set Door:DoorMode:" + CStr(I), 0
                        PrivateMessage BotID, PlayerID, "Door:DoorMode changed to " + CStr(I), 0
                    Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Choices: Any number from 0 to 255", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "DoorMode changing cannot be used unless the bot has SysOp access", 0
                End If

            ElseIf Left(Command, 5) = "!ship" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 1))
                If I >= 0 And I <= 8 Then
                    If I = 0 Then
                        If .LockShip = 0 Then
                            PrivateMessage BotID, PlayerID, "ShipLock already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Any ship may now be used. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "ShipLock disabled", 0
                            .LockShip = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "ShipLock already set to " + CStr(I), 0
                        Else
                            PublicMessage BotID, "*arena Only ship #" + CStr(I) + " ( " + ShipNames(I) + " ) is allowed. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "ShipLock set to " + CStr(I), 0
                            .LockShip = I
                            B = I - 1
                            For I = 0 To MAX_PLAYERS
                                If .pList(I).SSName <> "" And .pList(I).ShipType <> B Then
                                    PrivateMessage BotID, I, "*setship " + CStr(B + 1), 0
                                End If
                            Next
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !ship <no,1-8>", 0
                End If

            ElseIf Left(Command, 5) = "!spec" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 2))
                If I >= 0 And I <= 10 Then
                    If I = 0 Then
                        If .LockShip = 0 Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Death restrictions are lifted. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec disabled", 0
                            .AutoSpec = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already set to " + CStr(I), 0
                        Else
                            PublicMessage BotID, "*arena Removing players on " + CStr(I) + " deaths. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec set to " + CStr(I), 0
                            .AutoSpec = I
                            B = I - 1
                            For I = 0 To MAX_PLAYERS
                                If .pList(I).SSName <> "" And .pList(I).Losses >= B Then
                                    PrivateMessage BotID, I, "*spec", 0
                                    PrivateMessage BotID, I, "*spec", 0
                                End If
                            Next
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !spec <no,1-10>", 0
                End If

            ElseIf Left(Command, 10) = "!advertise" Then
                PublicMessage BotID, "*zone " + LTrim(Mid(Command, 11)) + "  -" + .pList(PlayerID).SSName, 0

            ElseIf Left(Command, 3) = "!go" Then
                O = GetArenaString(LTrim(Mid(Command, 4, 16)))
                PrivateMessage BotID, PlayerID, "Moving to '" + O + "'", 0
                LeaveArena BotID
                EnterArena BotID, 8, O, 1600, 1280

            ElseIf Command = "!quit" Or Command = "!exit" Or Command = "!leave" Or Command = "!bye" Then
                If .Suicide = 1 Then
                    If .pList(PlayerID).ShipType < 8 Then
                        PrivateMessage BotID, PlayerID, "*spec", 0
                        PrivateMessage BotID, PlayerID, "Good bye. Come back soon", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Suiciding is disabled by zone staff", 0
                End If

            ElseIf Left(Command, 3) = "!op" Then
                B = FindOperator(Mid(Command, 5))
                If B > 0 Then
                    If OpList(B).OperatorStatus >= OP_ACCOUNT Then
                        PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 5) + " cannot be downgraded", 0
                    ElseIf OpList(B).OperatorStatus = OP_SIMPLE Then
                        PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 5) + " is already a Simple-level operator", 0
                    Else
                        OpList(B).OperatorStatus = OP_SIMPLE
                        PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 5) + " changed to a Simple-level operator", 0
                    End If
                Else
                    AddOp BotID, Mid(Command, 5), OP_SIMPLE
                    PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 5) + " is now a Simple-level operator", 0
                End If

            ElseIf Left(Command, 4) = "!dop" Then
                B = FindOperator(Mid(Command, 6))
                If B > 0 Then
                    If OpList(B).OperatorStatus > OP_SIMPLE Then
                        PrivateMessage BotID, PlayerID, "DOp: " + Mid(Command, 6) + " cannot be stripped of status", 0
                    Else
                        DelOp BotID, B
                        PrivateMessage BotID, PlayerID, "DOp: " + Mid(Command, 6) + " stripped of operator status", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "DOp: " + Mid(Command, 6) + " is not an operator", 0
                End If

            ElseIf Left(Command, 9) = "!setprize" Then
                I = Val(LTrim(Mid(Command, 10, 4)))
                If Abs(I) <= 28 Then
                    .PrizeNumber = I
                    PrivateMessage BotID, PlayerID, "Periodic prize changed to " + PrizeNames(I), 0
                    If .PrizeEnabled = 1 Then PublicMessage BotID, "*arena Periodic prize changed to " + PrizeNames(I) + " by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                Else
                    PrivateMessage BotID, PlayerID, "Invalid prize number. Choices: Any number -28 to 28", 0
                End If

            ElseIf Left(Command, 10) = "!prizetime" Then
                I = Val(LTrim(Mid(Command, 11, 4)))
                If I >= 1 And I <= 10 Then
                    PrivateMessage BotID, PlayerID, "Periodic prizes changed to every " + CStr(I) + " second(s)", 0
                    If .PrizeEnabled = 1 Then PublicMessage BotID, "*arena Periodic prizes changed to every " + CStr(I) + " second(s) by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                    .PrizeWait = I
                Else
                    PrivateMessage BotID, PlayerID, "Invalid periodic time. Choices: Any number 1-10", 0
                End If

            ElseIf Command = "!lag" Then
                PrivateMessage BotID, PlayerID, "PING Current:" + CStr(.PingTime) + " ms  Average:" + CStr(.AvgPing) + "ms  C2S:" + Str(Round(.TotalLost / .TotalReliable, 2)) + "%  Accuracy:" + CStr(.TotalPings), 0

            ElseIf Left(Command, 7) = "!prizes" Then
                Select Case LTrim(Mid(Command, 8))
                    Case "on"
                        If .PrizeEnabled = 1 Then
                            PrivateMessage BotID, PlayerID, "Periodic prizes already enabled", 0
                        Else
                            If .PrizeWait = 0 Then
                                PrivateMessage BotID, PlayerID, "Use !prizetime <second(s)> before enabling periodic prizes", 0
                            Else
                                PrivateMessage BotID, PlayerID, "Periodic " + PrizeNames(.PrizeNumber) + "'s every " + CStr(.PrizeWait) + " second(s) enabled", 0
                                PublicMessage BotID, "*arena Periodic " + PrizeNames(.PrizeNumber) + "'s every " + CStr(.PrizeWait) + " second(s) enabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                                .PrizeEnabled = 1
                            End If
                        End If
                    Case "off"
                        If .PrizeEnabled = 0 Then
                            PrivateMessage BotID, PlayerID, "Periodic prizes already disabled", 0
                        Else
                            PrivateMessage BotID, PlayerID, "Periodic prizes disabled", 0
                            PublicMessage BotID, "*arena Periodic prizes disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                            .PrizeEnabled = 0
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Format: !prizes <on/off>", 0
                End Select

            ElseIf Left(Command, 10) = "!eventeams" Then
                Select Case Val(LTrim(Mid(Command, 11, 2)))
                    Case Is < 0
                        PrivateMessage BotID, PlayerID, "Invalid parameter. 0 to disable, 1-255 for number of players to trigger on", 0
                    Case Is = 0
                        If .EvenTeams = 0 Then
                            PrivateMessage BotID, PlayerID, "Team-evening already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Team-evening disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                            PrivateMessage BotID, PlayerID, "Team-evening disabled", 0
                            .EvenTeams = 0
                        End If
                    Case Is <= 10
                        B = Val(LTrim(Mid(Command, 11, 2)))
                        If .EvenTeams = B Then
                            PrivateMessage BotID, PlayerID, "Team-evening already using that number of players to trigger on", 0
                        Else
                            If .EvenTeams = 0 Then
                                PublicMessage BotID, "*arena Team-evening enabled allowing a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            Else
                                PublicMessage BotID, "*arena Team-evening now allows a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            End If
                            PrivateMessage BotID, PlayerID, "Team-evening enabled", 0
                            .EvenTeams = B
                        End If
                    Case Is > 10
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Format: !eventeams <off,1-10>", 0
                End Select

            ElseIf Command = "!enable" Then
                If .Bot_Enabled = 1 Then
                    PrivateMessage BotID, PlayerID, "Already enabled", 0
                Else
                    Select Case .Bot_Type
                        Case BOT_FLAVORS.ALIAS_REF
                        Case BOT_FLAVORS.ELIM_REF
                            If IsPublicArena(.ArenaName) Then
                                PrivateMessage BotID, PlayerID, "Enable: " + .MyName + " cannot be enabled in public arenas", 0
                            Else
                                .Bot_Status = CHECK
                                .Bot_Enabled = 1
                                PublicMessage BotID, "*arena " + .MyName + "(ElimRef) enabled by " + .pList(PlayerID).SSName, 2
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                            End If
                        Case Else
                            If .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "The bot is busy. Try again in 30 seconds", 0
                            ElseIf .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "Monkey god bot requires sysop to edit settings", 0
                            Else
                                .Bot_Enabled = 1
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                PublicMessage BotID, "*arena " + .MyName + "(" + GetTypeString(.Bot_Type) + ") enabled by " + .pList(PlayerID).SSName, 2
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                                Select Case .Bot_Type
                                    Case BOT_FLAVORS.CONQUER_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.ZOMBIES_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.SARUNOKAMI_REF
                                        PublicMessage BotID, "?set Security:SecurityKickoff:0", 0
                                        DownloadSettings BotID
                                    Case BOT_FLAVORS.BOUNTYGAME_REF
                                        NewRabbit BotID, True
                                End Select
                            End If
                    End Select
                End If

            ElseIf Command = "!disable" Then
                If .Bot_Type = ALIAS_REF Then
                    Exit Function
                ElseIf .Bot_Enabled = 0 Then
                    PrivateMessage BotID, PlayerID, "Already disabled", 0
                Else
                    If .Bot_Type = BOUNTYGAME_REF Then PublicMessage BotID, "*timereset", 0
                    If .Bot_Type = CONQUER_REF Or .Bot_Type = ELIM_REF Then
                        If .Bot_Status = STARTED Then PublicMessage BotID, "*lock", 0
                    End If
                    .Bot_Enabled = 0
                    PrivateMessage BotID, PlayerID, "Disabled", 0
                    PublicMessage BotID, "*arena" + .MyName + "(" + GetTypeString(.Bot_Type) + ") disabled by " + .pList(PlayerID).SSName, 1
                    AddDebug BotID, "Disabled by " + .pList(PlayerID).SSName, YELLOW
                End If

            ElseIf Left(Command, 8) = "!suicide" Then
                Select Case LCase(LTrim(Mid(Command, 9)))
                    Case "on"
                        If .Suicide = 1 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already allowed", 0
                        Else
                            .Suicide = 1
                            PrivateMessage BotID, PlayerID, "Player suicide allowed", 0
                            PublicMessage BotID, "*arena Player suicide allowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                        End If
                    Case "off"
                        If .Suicide = 0 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already disallowed", 0
                        Else
                            .Suicide = 0
                            PrivateMessage BotID, PlayerID, "Player suicide disallowed", 0
                            PublicMessage BotID, "*arena Player suicide disallowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter: !suicide <on/off>", 0
                End Select

            Else
                HandleGeneral = True

            End If

        Case ALLOW.OP_SUPER
            If Left(Command, 6) = "!spawn" Then
                For B = 1 To MAX_BOTS
                    If BotList(B).SlotClosed = 0 Then GoTo FoundOne
                Next
                PrivateMessage BotID, PlayerID, "Maximum for bot spawns is " + CStr(MAX_BOTS), 0
                Exit Function
FoundOne:
                Select Case LCase(Mid(Command, 8, 1))
                    Case "a"
                        PrivateMessage BotID, PlayerID, "Alias search engine created: " + Mid(Command, 10), 0
                        SpawnBot BotID, ALIAS_REF, Mid(Command, 10)
                    Case "e"
                        PrivateMessage BotID, PlayerID, "Elimination referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, ELIM_REF, Mid(Command, 10)
                    Case "z"
                        PrivateMessage BotID, PlayerID, "Zombie referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, ZOMBIES_REF, Mid(Command, 10)
                    Case "s"
                        PrivateMessage BotID, PlayerID, "SWZ Ship-checking referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, SWZ_REF, Mid(Command, 10)
                    Case "d"
                        PrivateMessage BotID, PlayerID, "DSB Ship-checking referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, DSB_REF, Mid(Command, 10)
                    Case "c"
                        PrivateMessage BotID, PlayerID, "Conquer! referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, CONQUER_REF, Mid(Command, 10)
                    Case "b"
                        PrivateMessage BotID, PlayerID, "BountyGame referee created: " + Mid(Command, 10), 0
                        SpawnBot BotID, BOUNTYGAME_REF, Mid(Command, 10)
                    Case "m"
                        PrivateMessage BotID, PlayerID, "Monkey god bot created: " + Mid(Command, 10), 0
                        SpawnBot BotID, SARUNOKAMI_REF, Mid(Command, 10)
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid type. Choices: (A)liasing,(B)ountyGame,(C)onquer!,(D)SB Shipchecker,(E)lim/race,(Z)ombies,(S)WZ Shipchecker,(M)onkey god bot", 0
                End Select

            ElseIf Command = "!status" Then
                O = GetState(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No status to report", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Command = "!rules" Then
                O = GetRules(BotID)
                If O = "" Then
                    PrivateMessage BotID, PlayerID, "This 'ref has no special game rules", 0
                Else
                    For I = 1 To Len(O) Step 90
                        PrivateMessage BotID, PlayerID, Mid(O, I, 90), 0
                    Next
                End If

            ElseIf Left(Command, 10) = "!killprize" Then
                I = Val(LTrim(Mid(Command, 11, 4)))
                If I > -1 And I <= 28 Then
                    If I = 0 Then
                        PrivateMessage BotID, PlayerID, "Kill prize disabled", 0
                        If .KillPrize > 0 Then PublicMessage BotID, "*arena Kill prize disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                        .KillPrize = 0
                    Else
                        PrivateMessage BotID, PlayerID, "Kill prize changed to " + PrizeNames(I), 0
                        PublicMessage BotID, "*arena Kill prize changed to " + PrizeNames(I) + " by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                        .KillPrize = I
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Invalid prize number. Choices: <No, 1 to 28>", 0
                End If

            ElseIf Command = "!quit" Or Command = "!exit" Or Command = "!leave" Or Command = "!bye" Then
                If .Suicide = 1 Then
                    If .pList(PlayerID).ShipType < 8 Then
                        PrivateMessage BotID, PlayerID, "*spec", 0
                        PrivateMessage BotID, PlayerID, "Good bye. Come back soon", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Suiciding is disabled by zone staff", 0
                End If

            ElseIf Command = "!lag" Then
                PrivateMessage BotID, PlayerID, "PING Current:" + CStr(.PingTime) + " ms  Average:" + CStr(.AvgPing) + "ms  C2S:" + Str(Round(.TotalLost / .TotalReliable, 2)) + "%  Accuracy:" + CStr(.TotalPings), 0

            ElseIf Left(Command, 4) = "!say" Then
                Command = LTrim(Mid(Command, 5))
                If Left(Command, 1) = ":" Then
                    RemoteMessage BotID, Command, 0
                ElseIf Left(Command, 1) = ";" Then
                    O = LTrim(Mid(Command, 4))
                    If Left(O, 1) <> "*" And Left(O, 1) <> "?" Then
                        ChannelMessage BotID, Mid(Command, 2, 1) + ";" + O, 0
                    End If
                ElseIf Left(Command, 2) = "//" Then
                    O = LTrim(Mid(Command, 3))
                    If Left(O, 1) <> "*" And Left(O, 1) <> "?" Then
                        TeamMessage BotID, O, 0
                    End If
                Else
                    If Left(Command, 6) = "*arena" Or Left(Command, 5) = "*zone" Then
                        PublicMessage BotID, Command, 0
                    ElseIf Left(Command, 1) <> "*" And Left(Command, 1) <> "?" Then
                        PublicMessage BotID, Command, 0
                    End If
                End If

            ElseIf Left(Command, 5) = "!door" Then
                If HasSysop Then
                    I = Val(Mid(LTrim(Command), 6, 4))
                    If I >= 0 And I <= 255 Then
                        PublicMessage BotID, "?set Door:DoorMode:" + CStr(I), 0
                        PrivateMessage BotID, PlayerID, "Door:DoorMode changed to " + CStr(I), 0
                    Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Choices: Any number from 0 to 255", 0
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "DoorMode changing cannot be used unless the bot has SysOp access", 0
                End If

            ElseIf Left(Command, 5) = "!ship" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 1))
                If I >= 0 And I <= 8 Then
                    If I = 0 Then
                        If .LockShip = 0 Then
                            PrivateMessage BotID, PlayerID, "ShipLock already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Any ship may now be used. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "ShipLock disabled", 0
                            .LockShip = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "ShipLock already set to " + CStr(I), 0
                        Else
                            If .Bot_Type <> SWZ_REF And .Bot_Type <> DSB_REF Then
                                PublicMessage BotID, "*arena Only ship #" + CStr(I) + " ( " + ShipNames(I) + " ) is allowed. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                                PrivateMessage BotID, PlayerID, "ShipLock set to " + CStr(I), 0
                                .LockShip = I
                                B = I - 1
                                For I = 0 To MAX_PLAYERS
                                    If .pList(I).SSName <> "" And .pList(I).ShipType <> B Then
                                        PrivateMessage BotID, I, "*setship " + CStr(B + 1), 0
                                    End If
                                Next
                            Else
                                PrivateMessage BotID, PlayerID, "ShipLock cannot be used in combination with Ship-checkers", 0
                            End If
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !ship <no,1-8>", 0
                End If

            ElseIf Left(Command, 5) = "!spec" Then
                I = Val(Left(LTrim(Mid(Command, 6)), 2))
                If I >= 0 And I <= 10 Then
                    If I = 0 Then
                        If .AutoSpec = 0 Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Death restrictions are lifted. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec disabled", 0
                            .AutoSpec = 0
                        End If
                    Else
                        If .LockShip = I Then
                            PrivateMessage BotID, PlayerID, "AutoSpec already set to " + CStr(I), 0
                        Else
                            PublicMessage BotID, "*arena Removing players on " + CStr(I) + " deaths. Set by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            PrivateMessage BotID, PlayerID, "AutoSpec set to " + CStr(I), 0
                            .AutoSpec = I
                            B = I - 1
                            For I = 0 To MAX_PLAYERS
                                If .pList(I).SSName <> "" And .pList(I).Losses >= B Then
                                    PrivateMessage BotID, I, "*spec", 0
                                    PrivateMessage BotID, I, "*spec", 0
                                End If
                            Next
                        End If
                    End If
                Else
                    PrivateMessage BotID, PlayerID, "Format: !spec <no,1-10>", 0
                End If

            ElseIf Left(Command, 10) = "!advertise" Then
                PublicMessage BotID, "*zone " + LTrim(Mid(Command, 11)) + "  -" + .pList(PlayerID).SSName, 0

            ElseIf Left(Command, 6) = "!error" Then
                O = LCase(LTrim(Mid(Command, 7, 16)))
                If O = "" Or O = "off" Then
                    .ErrorChannel = ""
                    PrivateMessage BotID, PlayerID, "Error broadcasting off", 0
                Else
                    .ErrorChannel = O
                    PublicMessage CurrentBot, "?chat=" + BotList(CurrentBot).ErrorChannel, 0
                    PrivateMessage BotID, PlayerID, "Error broadcasting on: Channel=" + O, 0
                End If

            ElseIf Command = "!listops" Or Command = "!listop" Or Command = "!oplist" Then
                O = GetOpList(False)

                If O = "" Then
                    PrivateMessage BotID, PlayerID, "No operators", 0
                Else
                    For I = 1 To Len(O) Step 85
                        PrivateMessage BotID, PlayerID, "Ops: " + Mid(O, I, 85), 0
                    Next
                End If

            ElseIf Left(Command, 3) = "!op" Then
                Select Case LCase(Mid(Command, 5, 1))
                    Case "i"
                        B = FindOperator(Mid(Command, 7))
                        If B > 0 Then
                            If OpList(B).OperatorStatus = OP_SIMPLE Then
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is already a Simple-level operator", 0
                            Else
                                OpList(B).OperatorStatus = OP_SIMPLE
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " changed to a Simple-level operator", 0
                            End If
                        Else
                            AddOp BotID, Mid(Command, 7), OP_SIMPLE
                            PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is now a Simple-level operator", 0
                        End If
                    Case "a"
                        B = FindOperator(Mid(Command, 7))
                        If B > 0 Then
                            If OpList(B).OperatorStatus = OP_ACCOUNT Then
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is already a Account-level operator", 0
                            Else
                                OpList(B).OperatorStatus = OP_ACCOUNT
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " changed to an Account-level operator", 0
                            End If
                        Else
                            AddOp BotID, Mid(Command, 7), OP_ACCOUNT
                            PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is now an Account-level operator", 0
                        End If
                    Case "s"
                        B = FindOperator(Mid(Command, 7))
                        If B > 0 Then
                            If OpList(B).OperatorStatus = OP_SUPER Then
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is already a Super-level operator", 0
                            Else
                                OpList(B).OperatorStatus = OP_SUPER
                                PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " changed to a Super-level operator", 0
                            End If
                        Else
                            AddOp BotID, Mid(Command, 7), OP_SUPER
                            PrivateMessage BotID, PlayerID, "Op: " + Mid(Command, 7) + " is now a Super-level operator", 0
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid operator type. Choices: s(I)mple,(A)ccount,(S)uper", 0
                End Select

            ElseIf Left(Command, 7) = "!attach" Then
                Select Case LTrim(Mid(Command, 8))
                    Case "on"
                        UDPSend BotID, Chr(16) + GetString2(PlayerID), True
                        .AttachedTo = PlayerID
                    Case "off"
                        UDPSend BotID, Chr(16) + GetString2(-1), True
                        .AttachedTo = -1
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Choices: on / off", 0
                End Select

            ElseIf Left(Command, 4) = "!dop" Then
                B = FindOperator(Mid(Command, 6))
                If B > 0 Then
                    DelOp BotID, B
                    PrivateMessage BotID, PlayerID, "DOp: " + Mid(Command, 6) + " stripped of operator status", 0
                Else
                    PrivateMessage BotID, PlayerID, "DOp: " + Mid(Command, 6) + " is not an operator", 0
                End If

            ElseIf Left(Command, 3) = "!go" Then
                O = GetArenaString(LTrim(Mid(Command, 4, 16)))
                PrivateMessage BotID, PlayerID, "Moving to '" + O + "'", 0
                LeaveArena BotID
                EnterArena BotID, 8, O, 1600, 1280

            ElseIf Command = "!close" Or Command = "!kill" Then
                PublicMessage BotID, "*arena " + .MyName + " shutdown by " + .pList(PlayerID).SSName, 0
                UnloadBot BotID, True

'            ElseIf Left(Command, 8) = "!getfile" Then
'                PublicMessage BotID, "*getfile " + LTrim(Mid(Command, 9)), 0

'            ElseIf Command = "!getsettings" Then
'                PublicMessage BotID, "?getsettings", 0

            ElseIf Left(Command, 6) = "!close" Then
                For I = 1 To MAX_BOTS
                    If BotList(I).SlotClosed = 1 And LCase(BotList(I).MyName) = LCase(LTrim(Mid(Command, 7))) Then
                        PublicMessage I, "*arena " + BotList(I).MyName + " shutdown by " + .pList(PlayerID).SSName + "(" + .ArenaName + ")", 0
                        UnloadBot I, True
                    End If
                Next

            ElseIf Command = "!terminate" Then
                Unload MainFrm

            ElseIf Left(Command, 10) = "!eventeams" Then
                Select Case Val(LTrim(Mid(Command, 11, 4)))
                    Case Is < 0
                        PrivateMessage BotID, PlayerID, "Invalid parameter. 0 to disable, 1-255 for number of players to trigger on", 0
                    Case Is = 0
                        If .EvenTeams = 0 Then
                            PrivateMessage BotID, PlayerID, "Team-evening already disabled", 0
                        Else
                            PublicMessage BotID, "*arena Team-evening disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                            PrivateMessage BotID, PlayerID, "Team-evening disabled", 0
                            .EvenTeams = 0
                        End If
                    Case Is <= 10
                        B = Val(LTrim(Mid(Command, 11, 2)))
                        If .EvenTeams = B Then
                            PrivateMessage BotID, PlayerID, "Team-evening already using that number of players to trigger on", 0
                        Else
                            If .EvenTeams = 0 Then
                                PublicMessage BotID, "*arena Team-evening enabled allowing a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            Else
                                PublicMessage BotID, "*arena Team-evening now allows a difference of " + CStr(B) + " players before triggering, by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                            End If
                            PrivateMessage BotID, PlayerID, "Team-evening enabled", 0
                            .EvenTeams = B
                        End If
                    Case Is > 10
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Format: !eventeams <off,1-10>", 0
                End Select

            ElseIf Left(Command, 9) = "!setprize" Then
                I = Val(LTrim(Mid(Command, 10, 4)))
                If Abs(I) <= 28 Then
                    .PrizeNumber = I
                    PrivateMessage BotID, PlayerID, "Periodic prize changed to " + PrizeNames(I), 0
                    If .PrizeEnabled = 1 Then PublicMessage BotID, "*arena Periodic prize changed to " + PrizeNames(I) + " by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                Else
                    PrivateMessage BotID, PlayerID, "Invalid prize number. Choices: Any number -28 to 28", 0
                End If

            ElseIf Left(Command, 10) = "!prizetime" Then
                I = Val(LTrim(Mid(Command, 11, 4)))
                If I >= 1 And I <= 10 Then
                    PrivateMessage BotID, PlayerID, "Periodic prizes changed to every " + CStr(I) + " second(s)", 0
                    If .PrizeEnabled = 1 Then PublicMessage BotID, "*arena Periodic prizes changed to every " + CStr(I) + " second(s) by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                    .PrizeWait = I
                Else
                    PrivateMessage BotID, PlayerID, "Invalid periodic time. Choices: Any number 1-10", 0
                End If

            ElseIf Left(Command, 7) = "!prizes" Then
                Select Case LTrim(Mid(Command, 8))
                    Case "on"
                        If .PrizeEnabled = 1 Then
                            PrivateMessage BotID, PlayerID, "Periodic prizes already enabled", 0
                        Else
                            If .PrizeWait = 0 Then
                                PrivateMessage BotID, PlayerID, "Use !prizetime <second(s)> before enabling periodic prizes", 0
                            Else
                                PrivateMessage BotID, PlayerID, "Periodic " + PrizeNames(.PrizeNumber) + "'s every " + CStr(.PrizeWait) + " second(s) enabled", 0
                                PublicMessage BotID, "*arena Periodic " + PrizeNames(.PrizeNumber) + "'s every " + CStr(.PrizeWait) + " second(s) enabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                                .PrizeEnabled = 1
                            End If
                        End If
                    Case "off"
                        If .PrizeEnabled = 0 Then
                            PrivateMessage BotID, PlayerID, "Periodic prizes already disabled", 0
                        Else
                            PrivateMessage BotID, PlayerID, "Periodic prizes disabled", 0
                            PublicMessage BotID, "*arena Periodic prizes disabled by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                            .PrizeEnabled = 0
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter. Format: !prizes <on/off>", 0
                End Select

            ElseIf Left(Command, 8) = "!suicide" Then
                Select Case LCase(LTrim(Mid(Command, 9)))
                    Case "on"
                        If .Suicide = 1 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already allowed", 0
                        Else
                            .Suicide = 1
                            PrivateMessage BotID, PlayerID, "Player suicide allowed", 0
                            PublicMessage BotID, "*arena Player suicide allowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 2
                        End If
                    Case "off"
                        If .Suicide = 0 Then
                            PrivateMessage BotID, PlayerID, "Player suicide already disallowed", 0
                        Else
                            .Suicide = 0
                            PrivateMessage BotID, PlayerID, "Player suicide disallowed", 0
                            PublicMessage BotID, "*arena Player suicide disallowed by " + .pList(PlayerID).SSName + "  -" + .MyName, 1
                        End If
                    Case Else
                        PrivateMessage BotID, PlayerID, "Invalid parameter: !suicide <on/off>", 0
                End Select

'            ElseIf Command = "!grab" Then
'                GetBall BotID, 0

'            ElseIf Command = "!shoot" Then
'                FireBall BotID, 0, 10, 10

            ElseIf Command = "!enable" Then
                If .Bot_Enabled = 1 Then
                    PrivateMessage BotID, PlayerID, "Already enabled", 0
                Else
                    Select Case .Bot_Type
                        Case BOT_FLAVORS.ALIAS_REF
                        Case BOT_FLAVORS.ELIM_REF
                            If IsPublicArena(.ArenaName) Then
                                PrivateMessage BotID, PlayerID, "Enable: " + .MyName + " cannot be enabled in public arenas", 0
                            Else
                                .Bot_Status = CHECK
                                .Bot_Enabled = 1
                                PublicMessage BotID, "*arena " + .MyName + "(ElimRef) enabled by " + .pList(PlayerID).SSName, 2
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                            End If
                        Case Else
                            If .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "The bot is busy. Try again in 30 seconds", 0
                            ElseIf .Bot_Type = SARUNOKAMI_REF And FTPList(BotID).FTP_Name <> "" Then
                                PrivateMessage BotID, PlayerID, "Monkey god bot requires sysop to edit settings", 0
                            Else
                                .Bot_Enabled = 1
                                PrivateMessage BotID, PlayerID, "Enabled", 0
                                PublicMessage BotID, "*arena " + .MyName + "(" + GetTypeString(.Bot_Type) + ") enabled by " + .pList(PlayerID).SSName, 2
                                AddDebug BotID, "Enabled by " + .pList(PlayerID).SSName, YELLOW
                                Select Case .Bot_Type
                                    Case BOT_FLAVORS.CONQUER_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.ZOMBIES_REF
                                        .Bot_Status = CHECK
                                    Case BOT_FLAVORS.SARUNOKAMI_REF
                                        PublicMessage BotID, "?set Security:SecurityKickoff:0", 0
                                        DownloadSettings BotID
                                    Case BOT_FLAVORS.BOUNTYGAME_REF
                                        NewRabbit BotID, True
                                End Select
                            End If
                    End Select
                End If

            ElseIf Command = "!disable" Then
                If .Bot_Type = ALIAS_REF Then
                    Exit Function
                ElseIf .Bot_Enabled = 0 Then
                    PrivateMessage BotID, PlayerID, "Already disabled", 0
                Else
                    If .Bot_Type = BOUNTYGAME_REF Then PublicMessage BotID, "*timereset", 0
                    If .Bot_Type = CONQUER_REF Or .Bot_Type = ELIM_REF Then
                        If .Bot_Status = STARTED Then PublicMessage BotID, "*lock", 0
                    End If
                    .Bot_Enabled = 0
                    PrivateMessage BotID, PlayerID, "Disabled", 0
                    PublicMessage BotID, "*arena" + .MyName + "(" + GetTypeString(.Bot_Type) + ") disabled by " + .pList(PlayerID).SSName, 1
                    AddDebug BotID, "Disabled by " + .pList(PlayerID).SSName, YELLOW
                End If

            ElseIf Left(Command, 10) = "!logscores" Then
                If LTrim(Mid(Command, 11)) = "on" Then
                    .LogScores = 1
                    PrivateMessage BotID, PlayerID, "Wins/losses/flag victories are now being logged to Scores.txt", 0
                Else
                    .LogScores = 0
                    PrivateMessage BotID, PlayerID, "Wins/losses/flag victories not being logged to Scores.txt", 0
                End If

            Else
                HandleGeneral = True

            End If
    End Select

End With
Exit Function
FlyPaper:
    AddDebug BotID, "Error detected in HandleGeneral(" + Command + "): " + Err.Description, RED
    Resume Next
End Function
